/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.vs;

import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.IStrategyFactory;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Strategy;
import com.ibm.appscan.internal.discovery.vs.SLNStrategy;
import java.io.File;
import java.io.FilenameFilter;

public class VSSolutionStrategyFactory
implements IStrategyFactory {
    public Strategy createStrategy(File fileOrDirectory, IStrategyFactoryRegistry registry) {
        if (this.shouldHandleVSSolution()) {
            if (fileOrDirectory.isDirectory()) {
                File[] files = fileOrDirectory.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".sln");
                    }
                });
                return files != null && files.length > 0 ? new SLNStrategy(fileOrDirectory, null, registry) : null;
            }
            if (fileOrDirectory.isFile()) {
                return fileOrDirectory.getName().endsWith(".sln") ? new SLNStrategy(fileOrDirectory.getParentFile(), fileOrDirectory, registry) : null;
            }
        }
        return null;
    }

    public boolean isBuildOutput() {
        return false;
    }

    public void loadUniqueTarget(IScan scan) {
    }

    private boolean shouldHandleVSSolution() {
        if (SystemUtil.useNewDotNetFrontend()) {
            return true;
        }
        if (SystemUtil.isSourceCodeOnly()) {
            return System.getProperty("useVisualStudio") != null;
        }
        return SystemUtil.isWindows();
    }
}

