/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.custom.scanner.sca.data;

import com.hcl.appscan.common.thirdpartylib.license.ILicense;
import com.hcl.appscan.common.thirdpartylib.license.License;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class SCALicense {
    private String m_libraryName;
    private JSONObject m_licenseInfo;
    private String m_hash;
    private String m_version;
    private String m_technology;

    public SCALicense(String libraryName, JSONObject licenseInfo, String hash, String version, String technology) {
        this.m_libraryName = libraryName;
        this.m_licenseInfo = licenseInfo;
        this.m_hash = hash;
        this.m_version = version;
        this.m_technology = technology;
    }

    public ILicense toLicense() throws AppScanException {
        try {
            License license = new License(this.m_libraryName, this.m_hash, this.getJsonValue(this.m_licenseInfo, "licenseName"), "", "", this.getJsonValue(this.m_licenseInfo, "licenseDistribution"), this.getJsonValue(this.m_licenseInfo, "licenseAgreement").toUpperCase().replace('-', '_'), this.getJsonValue(this.m_licenseInfo, "licenseRisk"), this.getJsonValue(this.m_licenseInfo, "licenseLinking"), this.convertCopyLeftText(this.getJsonValue(this.m_licenseInfo, "licenseCopyleft")), this.convertRoyaltYFreeText(this.getJsonValue(this.m_licenseInfo, "licenseRoyalty")), this.getJsonValue(this.m_licenseInfo, "licenseUrl"), this.m_version, this.getLibraryHash());
            return license;
        }
        catch (IOException | NoSuchAlgorithmException | JSONException e) {
            throw new AppScanException(e);
        }
    }

    private String getJsonValue(JSONObject obj, String key) throws JSONException {
        return obj.containsKey((Object)key) && !obj.isNull(key) ? obj.getString(key) : "";
    }

    private String convertCopyLeftText(String copyLeftStr) {
        if (copyLeftStr.equalsIgnoreCase("Non-copyleft license")) {
            return "NO";
        }
        if (copyLeftStr.equalsIgnoreCase("Copyleft applies on modifications as well as own code that uses the open-source software")) {
            return "FULL";
        }
        if (copyLeftStr.equalsIgnoreCase("Copyleft applies only to modifications")) {
            return "PARTIAL";
        }
        return copyLeftStr;
    }

    private String convertRoyaltYFreeText(String royaltyFreeStr) {
        if (royaltyFreeStr.equalsIgnoreCase("Royalty-free and no identified patent risks")) {
            return "YES";
        }
        if (royaltyFreeStr.equalsIgnoreCase("No patents granted")) {
            return "NO";
        }
        if (royaltyFreeStr.equalsIgnoreCase("Royalty-free unless litigated")) {
            return "CONDITIONAL";
        }
        return royaltyFreeStr;
    }

    private String getLibraryHash() throws NoSuchAlgorithmException, IOException {
        return SystemUtil.calculateSHA1((String)(this.m_libraryName.trim() + this.m_version.trim() + this.m_technology.trim()));
    }
}

