/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.vs;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.CustomTargetInfo;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTarget;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.DiscoveryCore;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Strategy;
import com.ibm.appscan.discovery.vs.Messages;
import com.ibm.appscan.discovery.vs.utils.VSAdapterFactory;
import com.ibm.appscan.discovery.vs.utils.VsDiscoveryRunner;
import com.ibm.appscan.internal.discovery.StrategyFactoryRegistry;
import com.ibm.appscan.internal.discovery.dir.DirectoryStrategy;
import com.ibm.appscan.internal.discovery.vs.NullStrategy;
import com.ibm.appscan.internal.discovery.vs.VSStrategy;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class VSSolutionStrategy
extends VSStrategy {
    private File m_solution;
    private StrategyFactoryRegistry m_registry;
    private String m_languageType;
    private static final String DEFAULT_LANUGAGE_TYPE = "DotNet";

    public VSSolutionStrategy() {
    }

    VSSolutionStrategy(File file, IStrategyFactoryRegistry registry) {
        this.init(file, registry);
    }

    public void init(File file, IStrategyFactoryRegistry registry) {
        this.m_solution = file;
        this.m_registry = (StrategyFactoryRegistry)registry;
        this.m_languageType = DEFAULT_LANUGAGE_TYPE;
    }

    public String getName() {
        return this.m_solution.getName();
    }

    public String getLanguageType() {
        return this.m_languageType;
    }

    public String getType() {
        return Messages.getMessage("solution", new Object[0]);
    }

    public String getPath() {
        return this.m_solution.getPath();
    }

    public String getStrategyClass() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void findScanTargets(IScanTargetProxy proxy, IProgress progress) {
        Map<String, Properties> targets = null;
        boolean addedTargets = false;
        String config = proxy.getBuildInfo().getProperty("configuration");
        String[] args = config != null ? new String[]{this.m_solution.getAbsolutePath(), "-c", config, "-l", VSSolutionStrategy.getLogDir(proxy)} : new String[]{this.m_solution.getAbsolutePath(), "-l", VSSolutionStrategy.getLogDir(proxy)};
        VsDiscoveryRunner runner = new VsDiscoveryRunner(args);
        try {
            targets = runner.run(proxy);
        }
        catch (AppScanException e) {
            proxy.getErrorManager().reportError(Messages.getMessage("solution.read.error", this.m_solution.getAbsolutePath(), e.getLocalizedMessage()));
        }
        boolean isFirstPass = true;
        if (targets != null && targets.size() > 0) {
            for (String target : targets.keySet()) {
                this.addSourceFilesToOpenSource(targets.get(target));
                try {
                    Map<Strategy, Properties> strategies = VSAdapterFactory.createTarget(targets.get(target), progress).toStrategies();
                    for (Strategy strategy : strategies.keySet()) {
                        if (strategy instanceof NullStrategy) {
                            proxy.getErrorManager().reportError(((NullStrategy)strategy).getMessage());
                            continue;
                        }
                        Map buildInfos = strategies.get(strategy);
                        CustomTargetInfo info = new CustomTargetInfo();
                        info.getBuildInfos().putAll(buildInfos);
                        if (!proxy.newScanTarget((ScanTargetStrategy)strategy, info)) continue;
                        addedTargets = true;
                        if (isFirstPass) {
                            this.m_languageType = strategy.getLanguageType();
                            isFirstPass = false;
                            continue;
                        }
                        if (this.m_languageType == strategy.getLanguageType()) continue;
                        this.m_languageType = DEFAULT_LANUGAGE_TYPE;
                    }
                }
                catch (AppScanException e) {
                    proxy.getErrorManager().reportError(e.getMessage());
                }
            }
        }
        if (!addedTargets) {
            String log = new File(CommonCore.getDirectoryLocator().getLogs(), "vs.log").getAbsolutePath();
            if (SystemUtil.isSourceCodeOnly()) {
                proxy.getLogManager().log(new Message(2, Messages.getMessage("solution.read.warning", this.m_solution.getAbsolutePath())));
                proxy.newScanTarget((ScanTargetStrategy)new DirectoryStrategy(this.m_solution.getParentFile(), DiscoveryCore.getThirdPartyLibTarget(), this.m_registry));
            } else {
                proxy.getLogManager().log(new Message(4, Messages.getMessage("error.no.targets", this.m_solution.getAbsolutePath(), log)));
            }
        }
    }

    protected Set<IScanFile> findScanFiles(IScanTargetMinProxy proxy, IProgress progress) {
        return null;
    }

    private void addSourceFilesToOpenSource(Properties props) {
        IScanTarget openSourceTarget = DiscoveryCore.getThirdPartyLibTarget();
        if (openSourceTarget == null || !props.containsKey("sources")) {
            return;
        }
        String sources = props.getProperty("sources");
        for (String source : sources.split(";")) {
            if (new File(source).exists()) {
                openSourceTarget.inject(source);
                continue;
            }
            if (!props.containsKey("project_file")) continue;
            String projectDir = new File(props.getProperty("project_file")).getParent();
            openSourceTarget.inject(new File(projectDir, source).getAbsolutePath());
        }
    }
}

