/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.scan;

import com.hcl.appscan.sdk.CoreConstants;
import com.hcl.appscan.sdk.Messages;
import com.hcl.appscan.sdk.app.CloudApplicationProvider;
import com.hcl.appscan.sdk.auth.IAuthenticationProvider;
import com.hcl.appscan.sdk.http.HttpClient;
import com.hcl.appscan.sdk.http.HttpPart;
import com.hcl.appscan.sdk.http.HttpResponse;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.logging.Message;
import com.hcl.appscan.sdk.scan.IScanServiceProvider;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONArtifact;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class CloudScanServiceProvider
implements IScanServiceProvider,
Serializable,
CoreConstants {
    private static final long serialVersionUID = 1L;
    private IProgress m_progress;
    private IAuthenticationProvider m_authProvider;

    public CloudScanServiceProvider(IProgress progress, IAuthenticationProvider authProvider) {
        this.m_progress = progress;
        this.m_authProvider = authProvider;
    }

    @Override
    public String createAndExecuteScan(String type, Map<String, String> params) {
        if (this.loginExpired() || !this.verifyApplication(params.get("AppId"))) {
            return null;
        }
        this.m_progress.setStatus(new Message(0, Messages.getMessage("message.running.scan", new Object[0])));
        String request_url = this.m_authProvider.getServer() + String.format("/api/v2/Scans/%s", type);
        Map<String, String> request_headers = this.m_authProvider.getAuthorizationHeader(true);
        HttpClient client = new HttpClient(this.m_authProvider.getProxy());
        try {
            HttpResponse response = client.postForm(request_url, request_headers, params);
            int status = response.getResponseCode();
            JSONObject json = (JSONObject)response.getResponseBodyAsJSON();
            if (status == 201) {
                this.m_progress.setStatus(new Message(0, Messages.getMessage("message.created.scan", new Object[0])));
                return json.getString("Id");
            }
            if (json != null && json.has("Message")) {
                String errorResponse = json.getString("Message");
                JSONArray jsonArray = json.getJSONArray("FormatParams");
                if (jsonArray != null) {
                    String[] test = new String[jsonArray.size()];
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        test[i] = (String)jsonArray.get(i);
                    }
                    errorResponse = MessageFormat.format(errorResponse, test);
                }
                this.m_progress.setStatus(new Message(2, errorResponse));
            } else {
                this.m_progress.setStatus(new Message(2, Messages.getMessage("error.submit.scan", status)));
            }
        }
        catch (IOException | JSONException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.submit.scan", e.getLocalizedMessage())));
        }
        return null;
    }

    @Override
    public String submitFile(File file) throws IOException {
        if (this.loginExpired()) {
            return null;
        }
        this.m_progress.setStatus(new Message(0, Messages.getMessage("message.uploading.file", file.getAbsolutePath())));
        String fileUploadAPI = this.m_authProvider.getServer() + "/api/v2/FileUpload";
        ArrayList<HttpPart> parts = new ArrayList<HttpPart>();
        parts.add(new HttpPart("fileToUpload", file, "multipart/form-data"));
        HttpClient client = new HttpClient(this.m_authProvider.getProxy());
        try {
            HttpResponse response = client.postMultipart(fileUploadAPI, this.m_authProvider.getAuthorizationHeader(true), parts);
            JSONObject object = (JSONObject)response.getResponseBodyAsJSON();
            if (!object.has("Message")) {
                return object.getString("FileId");
            }
            this.m_progress.setStatus(new Message(2, object.getString("Message")));
        }
        catch (JSONException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.upload.file", file, e.getLocalizedMessage())));
        }
        return null;
    }

    @Override
    public JSONObject getScanDetails(String scanId) throws IOException, JSONException {
        if (this.loginExpired()) {
            return null;
        }
        String request_url = this.m_authProvider.getServer() + String.format("/api/v2/Scans/%s", scanId);
        Map<String, String> request_headers = this.m_authProvider.getAuthorizationHeader(true);
        HttpClient client = new HttpClient(this.m_authProvider.getProxy());
        try {
            HttpResponse response = client.get(request_url, request_headers, null);
            if (response.getResponseCode() == 200 || response.getResponseCode() == 201) {
                return (JSONObject)response.getResponseBodyAsJSON();
            }
            if (response.getResponseCode() == -1) {
                return new JSONObject().put("Status", (Object)"Unknown");
            }
            if (response.getResponseCode() != 400) {
                JSONArtifact json = response.getResponseBodyAsJSON();
                if (json != null && ((JSONObject)json).has("Message")) {
                    this.m_progress.setStatus(new Message(2, ((JSONObject)json).getString("Message")));
                }
                if (response.getResponseCode() == 403 && json != null && ((JSONObject)json).has("Key") && ((JSONObject)json).get("Key").equals("UNAUTHORIZED_ACTION")) {
                    return (JSONObject)json;
                }
            }
            if (response.getResponseCode() == 400) {
                this.m_progress.setStatus(new Message(2, Messages.getMessage("error.invalid.job.id", scanId)));
            }
        }
        catch (IOException | JSONException e) {
            return new JSONObject().put("Status", (Object)"Unknown");
        }
        return null;
    }

    @Override
    public JSONArray getNonCompliantIssues(String scanId) throws IOException, JSONException {
        if (this.loginExpired()) {
            return null;
        }
        String request_url = this.m_authProvider.getServer() + String.format("/api/v2/Issues/CountBySeverity/%s/%s", "Scan", scanId);
        request_url = request_url + "?applyPolicies=All";
        Map<String, String> request_headers = this.m_authProvider.getAuthorizationHeader(true);
        request_headers.put("Content-Type", "application/json; charset=UTF-8");
        request_headers.put("Accept", "application/json");
        HttpClient client = new HttpClient(this.m_authProvider.getProxy());
        HttpResponse response = client.get(request_url, request_headers, null);
        if (response.getResponseCode() == 200) {
            return (JSONArray)response.getResponseBodyAsJSON();
        }
        if (response.getResponseCode() == 400) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.getting.info", "Scan", scanId)));
        } else {
            JSONObject obj = (JSONObject)response.getResponseBodyAsJSON();
            if (obj != null && obj.has("Message")) {
                this.m_progress.setStatus(new Message(2, obj.getString("Message")));
            } else {
                this.m_progress.setStatus(new Message(2, Messages.getMessage("error.getting.details", response.getResponseCode())));
            }
        }
        return null;
    }

    @Override
    public IAuthenticationProvider getAuthenticationProvider() {
        return this.m_authProvider;
    }

    private boolean loginExpired() {
        if (this.m_authProvider.isTokenExpired()) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("login.token.expired", new Object[0])));
            return true;
        }
        return false;
    }

    private boolean verifyApplication(String appId) {
        CloudApplicationProvider provider;
        if (appId != null && !appId.trim().equals("") && (provider = new CloudApplicationProvider(this.m_authProvider)).getApplications() != null && provider.getApplications().keySet().contains(appId)) {
            return true;
        }
        this.m_progress.setStatus(new Message(2, Messages.getMessage("error.invalid.app", appId)));
        return false;
    }

    @Override
    public void setProgress(IProgress progress) {
        this.m_progress = progress;
    }
}

