/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.utils.jaxapp;

import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.utils.JAXUtils;
import com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.utils.jaxapp.ContextResolverProvider;
import com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.utils.jaxapp.JaxRSResource;
import com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.utils.jaxapp.MessageBodyReaderProvider;
import com.ibm.appscan.frameworks.highlevelapi.jaxhandler.internal.utils.jaxapp.MessageBodyWriterProvider;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeClass;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.generics.ClassSignature;
import com.ibm.wala.types.generics.ClassTypeSignature;
import com.ibm.wala.types.generics.TypeArgument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class JAXApp {
    private F4FApp app;
    private Collection<MessageBodyReaderProvider> readProviders;
    private Collection<MessageBodyWriterProvider> writeProviders;
    private Collection<ContextResolverProvider> contextResolversProviders;
    private Map<IClass, MessageBodyReaderProvider> readProvidersMap;
    private Map<IClass, MessageBodyWriterProvider> writeProvidersMap;
    private Map<IClass, ContextResolverProvider> contextResolversProvidersMap;
    private Collection<JaxRSResource> rootResources;
    private Collection<JaxRSResource> subResources;
    private Map<IClass, JaxRSResource> resourcesMap;
    Logger logger = TaintLogger.i().getLogger();

    public JAXApp() {
        this.readProviders = new ArrayList<MessageBodyReaderProvider>();
        this.writeProviders = new ArrayList<MessageBodyWriterProvider>();
        this.contextResolversProviders = new ArrayList<ContextResolverProvider>();
        this.rootResources = new ArrayList<JaxRSResource>();
        this.subResources = new ArrayList<JaxRSResource>();
        this.resourcesMap = new HashMap<IClass, JaxRSResource>();
        this.readProvidersMap = new HashMap<IClass, MessageBodyReaderProvider>();
        this.writeProvidersMap = new HashMap<IClass, MessageBodyWriterProvider>();
        this.contextResolversProvidersMap = new HashMap<IClass, ContextResolverProvider>();
    }

    public void constructApp(F4FApp app) {
        this.app = app;
        for (IClass clazz : app.getAllApplicationClasses()) {
            JaxRSResource res;
            this.logger.info((Object)Messages.getString((String)"framework.class.found", (Object[])new Object[]{clazz.getName().toString()}));
            if (JAXUtils.hasAnnotation(app, clazz, "Ljavax/ws/rs/Path").booleanValue()) {
                this.logger.info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{"Ljavax/ws/rs/Path"}));
                res = new JaxRSResource(app, clazz);
                this.rootResources.add(res);
                this.resourcesMap.put(clazz, res);
                this.logger.info((Object)Messages.getString((String)"framework.class.found", (Object[])new Object[]{"root resource: " + clazz.getName().toString()}));
                continue;
            }
            if (JAXUtils.hasAnnotation(app, clazz, "Ljavax/ws/rs/ext/Provider").booleanValue()) {
                IClass contextResolverClass;
                IClass readerTypeClass;
                IClass writterTypeClass;
                this.logger.info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{"Ljavax/ws/rs/ext/Provider"}));
                IClass writterInterface = null;
                IClass readerInterface = null;
                IClass contextResolverInterface = null;
                String writterType = null;
                String readerType = null;
                String contextResolverType = null;
                for (IClass current = clazz; current != null; current = current.getSuperclass()) {
                    block8: for (IClass interf : current.getDirectInterfaces()) {
                        TypeArgument[] ta;
                        ClassTypeSignature[] sis;
                        ClassSignature signature2;
                        if (writterInterface == null && interf.getName().toString().equals("Ljavax/ws/rs/ext/MessageBodyWriter")) {
                            this.logger.info((Object)Messages.getString((String)"framework.interface.found", (Object[])new Object[]{"Ljavax/ws/rs/ext/MessageBodyWriter"}));
                            writterInterface = interf;
                            if (current instanceof ShrikeClass) {
                                try {
                                    signature2 = ((ShrikeClass)current).getClassSignature();
                                    for (ClassTypeSignature si : sis = signature2.getSuperinterfaceSignatures()) {
                                        ta = si.getTypeArguments();
                                        if (ta == null || ta.length != 1) continue;
                                        writterType = JAXUtils.convertToSimpleName(ta[0].toString());
                                        break;
                                    }
                                }
                                catch (InvalidClassFileException signature2) {
                                    // empty catch block
                                }
                            }
                        }
                        if (readerInterface == null && interf.getName().toString().equals("Ljavax/ws/rs/ext/MessageBodyReader")) {
                            this.logger.info((Object)Messages.getString((String)"framework.interface.found", (Object[])new Object[]{"Ljavax/ws/rs/ext/MessageBodyReader"}));
                            readerInterface = interf;
                            if (current instanceof ShrikeClass) {
                                try {
                                    signature2 = ((ShrikeClass)current).getClassSignature();
                                    for (ClassTypeSignature si : sis = signature2.getSuperinterfaceSignatures()) {
                                        ta = si.getTypeArguments();
                                        if (ta == null || ta.length != 1) continue;
                                        readerType = JAXUtils.convertToSimpleName(ta[0].toString());
                                        break;
                                    }
                                }
                                catch (InvalidClassFileException signature3) {
                                    // empty catch block
                                }
                            }
                        }
                        if (contextResolverInterface != null || !interf.getName().toString().equals("Ljavax/ws/rs/ext/ContextResolver")) continue;
                        this.logger.info((Object)Messages.getString((String)"framework.interface.found", (Object[])new Object[]{"Ljavax/ws/rs/ext/ContextResolver"}));
                        contextResolverInterface = interf;
                        if (!(current instanceof ShrikeClass)) continue;
                        try {
                            signature2 = ((ShrikeClass)current).getClassSignature();
                            for (ClassTypeSignature si : sis = signature2.getSuperinterfaceSignatures()) {
                                ta = si.getTypeArguments();
                                if (ta == null || ta.length != 1) continue;
                                contextResolverType = JAXUtils.convertToSimpleName(ta[0].toString());
                                continue block8;
                            }
                        }
                        catch (InvalidClassFileException invalidClassFileException) {
                        }
                    }
                    if (writterInterface != null && readerInterface != null && contextResolverType != null) break;
                }
                if (writterInterface != null && writterType != null && (writterTypeClass = app.getIClass(writterType)) != null) {
                    MessageBodyWriterProvider writter = new MessageBodyWriterProvider(app, clazz, writterInterface);
                    this.writeProviders.add(writter);
                    this.writeProvidersMap.put(writterTypeClass, writter);
                    this.logger.info((Object)Messages.getString((String)"framework.class.found", (Object[])new Object[]{"entity writer provider: " + writterTypeClass.getName().toString()}));
                }
                if (readerInterface != null && readerType != null && (readerTypeClass = app.getIClass(readerType)) != null) {
                    MessageBodyReaderProvider reader = new MessageBodyReaderProvider(app, clazz, readerInterface, readerTypeClass);
                    this.readProviders.add(reader);
                    this.readProvidersMap.put(readerTypeClass, reader);
                    this.logger.info((Object)Messages.getString((String)"framework.class.found", (Object[])new Object[]{"entity reader provider: " + readerTypeClass.getName().toString()}));
                }
                if (contextResolverInterface == null || contextResolverType == null || (contextResolverClass = app.getIClass(contextResolverType)) == null) continue;
                ContextResolverProvider contextResolver = new ContextResolverProvider(app, clazz, contextResolverInterface, contextResolverClass);
                this.contextResolversProviders.add(contextResolver);
                this.contextResolversProvidersMap.put(contextResolverClass, contextResolver);
                this.logger.info((Object)Messages.getString((String)"framework.class.found", (Object[])new Object[]{"context resolver provider: " + contextResolverClass.getName().toString()}));
                continue;
            }
            res = new JaxRSResource(app, clazz);
            if (res.getSupportedMethods().size() <= 0) continue;
            this.subResources.add(res);
            this.resourcesMap.put(clazz, res);
            this.logger.debug((Object)Messages.getString((String)"framework.class.found", (Object[])new Object[]{"resource: " + clazz.getName().toString()}));
        }
    }

    public Collection<JaxRSResource> getRootResources() {
        return this.rootResources;
    }

    public Collection<JaxRSResource> getSubResources() {
        return this.subResources;
    }

    public F4FApp getApp() {
        return this.app;
    }

    public MessageBodyReaderProvider getReadProvider(IClass clazz) {
        MessageBodyReaderProvider reader = this.readProvidersMap.get(clazz);
        return reader;
    }

    public MessageBodyWriterProvider getWriteProvider(IClass clazz) {
        MessageBodyWriterProvider writter = this.writeProvidersMap.get(clazz);
        return writter;
    }

    public ContextResolverProvider getContextResolverProvider(IClass clazz) {
        ContextResolverProvider contextResolver = this.contextResolversProvidersMap.get(clazz);
        return contextResolver;
    }

    public JaxRSResource getResource(IClass clazz) {
        return this.resourcesMap.get(clazz);
    }

    public Collection<IField> getAnnotatedFields(IClass clazz, String annotationQN) {
        ArrayList<IField> annotatedFields = new ArrayList<IField>();
        Collection fields = clazz.getAllFields();
        for (IField field : fields) {
            if (!JAXUtils.hasAnnotation(this.app, field, annotationQN).booleanValue()) continue;
            annotatedFields.add(field);
        }
        return annotatedFields;
    }

    public boolean isSubResourceLocator(IMethod method) {
        return JAXUtils.isSubResourceLocator(this.app, method);
    }
}

