/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common;

public class HashUtil {
    public static final int SEED = 23;
    private static final int ODD_PRIME_NUMBER = 37;

    private static int firstTerm(int aSeed) {
        return 37 * aSeed;
    }

    public static int hash(int aSeed, boolean aBoolean) {
        return HashUtil.firstTerm(aSeed) + (aBoolean ? 1 : 0);
    }

    public static int hash(int aSeed, char c) {
        return HashUtil.firstTerm(aSeed) + c;
    }

    public static int hash(int aSeed, char[] chars) {
        int ret = aSeed;
        for (int i = 0; i < chars.length; ++i) {
            ret = HashUtil.hash(ret, chars[i]);
        }
        return ret;
    }

    public static int hash(int aSeed, int i) {
        return HashUtil.firstTerm(aSeed) + i;
    }

    public static int hash(int aSeed, long l) {
        return HashUtil.firstTerm(aSeed) + (int)(l ^ l >>> 32);
    }

    public static int hash(int aSeed, float f) {
        return HashUtil.hash(aSeed, Float.floatToIntBits(f));
    }

    public static int hash(int aSeed, double d) {
        return HashUtil.hash(aSeed, Double.doubleToLongBits(d));
    }
}

