/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.utils;

import com.ibm.appscan.common.CommonCore;
import java.io.File;
import java.io.IOException;

public class PresetUtil {
    private static final String PRESET_HINT = "preset_hint";
    private static final String SCAN_SPEED = "scan_speed";
    private static final String PRESET_HINT_EXT = ".presethint";
    private static final String PRESET_SURFACE = "surface";
    private static final String PRESET_SIMPLE = "simple";
    private static final String PRESET_MINIMAL = "minimal";
    private static final String PRESET_BALANCED = "balanced";
    private static final String PRESET_STANDARD = "standard";
    private static final String PRESET_THOROUGH = "thorough";

    public static void checkPresetHint(File directory) throws IOException {
        String presetHint = System.getProperty(PRESET_HINT);
        if (presetHint == null) {
            presetHint = System.getProperty(SCAN_SPEED);
        }
        if (presetHint == null || presetHint.trim().equals("")) {
            presetHint = CommonCore.getConfiguration().getSettingValue(PRESET_HINT, PRESET_STANDARD);
        }
        if (PresetUtil.mapPresetHint(presetHint) != null) {
            new File(directory, PresetUtil.mapPresetHint(presetHint) + PRESET_HINT_EXT).createNewFile();
        }
    }

    public static String getPresetHint(File directory) {
        if (new File(directory, "surface.presethint").isFile()) {
            return PRESET_SURFACE;
        }
        if (new File(directory, "minimal.presethint").isFile()) {
            return PRESET_MINIMAL;
        }
        if (new File(directory, "standard.presethint").isFile()) {
            return PRESET_STANDARD;
        }
        if (new File(directory, "thorough.presethint").isFile()) {
            return PRESET_THOROUGH;
        }
        return null;
    }

    public static String mapPresetHint(String speed_input) {
        if (PRESET_SIMPLE.equalsIgnoreCase(speed_input) || PRESET_SURFACE.equalsIgnoreCase(speed_input)) {
            return PRESET_SURFACE;
        }
        if (PRESET_BALANCED.equalsIgnoreCase(speed_input) || PRESET_MINIMAL.equalsIgnoreCase(speed_input)) {
            return PRESET_MINIMAL;
        }
        if (PRESET_THOROUGH.equalsIgnoreCase(speed_input)) {
            return PRESET_THOROUGH;
        }
        return null;
    }
}

