/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.utils;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Messages;
import com.ibm.appscan.common.SaaSConstants;
import com.ibm.appscan.common.http.HttpClient;
import com.ibm.appscan.common.http.HttpResponse;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.ConnectionHelper;
import com.ibm.appscan.common.utils.ServerUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.common.utils.WebServiceUtil;
import com.ibm.security.annotation.SuppressSecurityTrace;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.json.JSONArtifact;
import org.apache.commons.json.JSONObject;

public class VersionUtil
implements SaaSConstants {
    public static final String FAKE_OS = "FakeOS";
    public static final int VERSION_MATCH = 0;
    public static final int BUILD_NUMBER_MISMATCH = 1;
    public static final int MINOR_MISMATCH = 2;
    public static final int MAJOR_MISMATCH = 3;
    private static final String WINDOWS = "win";
    private static final String MAC = "mac";
    private static final String LINUX = "linux";
    private static final String META = "&meta=true";
    private static final String SACU_URL_EV = "SACLIENTUTIL_DOWNLOAD_URL";
    private static final String SACU_VER_EV = "SACLIENTUTIL_DOWNLOAD_VERSION";

    public static boolean usingLatest() {
        String localVersion = VersionUtil.getLocalToolsVersion();
        return VersionUtil.isLatest(localVersion);
    }

    public static boolean isLatest(String localVersion) {
        String serverVersion = VersionUtil.getServerToolsVersion();
        return VersionUtil.compare(localVersion, serverVersion) == 0;
    }

    public static boolean isLower() {
        String localVersion = VersionUtil.getLocalToolsVersion();
        String serverVersion = VersionUtil.getServerToolsVersion();
        return VersionUtil.isLower(localVersion, serverVersion);
    }

    public static int compareWithLatest(String localVersion) {
        String serverVersion = VersionUtil.getServerToolsVersion();
        return VersionUtil.compare(localVersion, serverVersion);
    }

    public static String getLocalToolsVersion() {
        return CommonCore.class.getPackage().getImplementationVersion();
    }

    @SuppressSecurityTrace
    public static String getServerToolsVersion() {
        String url = null;
        String version = null;
        String versionEV = System.getenv(SACU_VER_EV);
        if (versionEV != null) {
            return versionEV;
        }
        try {
            JSONObject object;
            JSONArtifact responseContent;
            HttpClient httpClient;
            HttpResponse response;
            if (SystemUtil.shouldAcceptSSL() || SystemUtil.isDevelopment()) {
                ConnectionHelper.bypassSSL();
            }
            if ((response = (httpClient = new HttpClient()).get(url = VersionUtil.getUtilityDownloadURL() + META, null, null)).isSuccess() && (responseContent = response.getResponseBodyAsJSON()) != null && (object = (JSONObject)responseContent).keySet().contains("VersionNumber")) {
                version = object.getString("VersionNumber");
            }
        }
        catch (SSLHandshakeException e) {
            CommonCore.getLogManager().log(new Message(4, Messages.getMessage("err.ssl", WebServiceUtil.getServer())));
            CommonCore.getIOConsole().println(Messages.getMessage("err.ssl", WebServiceUtil.getServer()));
        }
        catch (Exception e) {
            CommonCore.getLogManager().log(new Message(2, Messages.getMessage("err.server.version.check", WebServiceUtil.getServer())));
            CommonCore.getLogManager().log(new Message(e));
        }
        return version;
    }

    @SuppressSecurityTrace
    public static String getMainVersion() {
        String url = null;
        String mainVersion = "1.0";
        try {
            JSONObject object;
            JSONArtifact responseContent;
            HttpClient httpClient;
            HttpResponse response;
            if (SystemUtil.shouldAcceptSSL() || SystemUtil.isDevelopment()) {
                ConnectionHelper.bypassSSL();
            }
            if ((response = (httpClient = new HttpClient()).get(url = ServerUtil.getSettingServerUrl() + "/assets/versions.json", null, null)).isSuccess() && (responseContent = response.getResponseBodyAsJSON()) != null && (object = (JSONObject)responseContent).keySet().contains("MainVersion")) {
                mainVersion = object.getString("MainVersion");
            }
        }
        catch (SSLHandshakeException e) {
            CommonCore.getLogManager().log(new Message(4, Messages.getMessage("err.ssl", WebServiceUtil.getServer())));
            CommonCore.getIOConsole().println(Messages.getMessage("err.ssl", WebServiceUtil.getServer()));
        }
        catch (Exception e) {
            CommonCore.getLogManager().log(new Message(2, Messages.getMessage("err.server.version.check", WebServiceUtil.getServer())));
            CommonCore.getLogManager().log(new Message(e));
        }
        return mainVersion;
    }

    public static String getEnvName() {
        String mainVersion = VersionUtil.getMainVersion();
        if ("1.0".equals(mainVersion)) {
            return "ASoC";
        }
        String versionNumber = mainVersion.split("-")[0];
        return "360/" + versionNumber;
    }

    public static String replaceEnvPath(String message) {
        return message.replace("/appscan/ASoC/", "/appscan/" + VersionUtil.getEnvName() + "/");
    }

    private static String getOS() {
        if (SystemUtil.isPropertySet(FAKE_OS)) {
            return System.getProperty(FAKE_OS);
        }
        if (SystemUtil.isWindows()) {
            return WINDOWS;
        }
        if (SystemUtil.isMac()) {
            return MAC;
        }
        return LINUX;
    }

    public static String getUtilityDownloadURL() {
        String url = System.getenv(SACU_URL_EV);
        if (url == null) {
            url = CommonCore.getDirectoryLocator().isProductBundle() != false ? WebServiceUtil.getServer() + "/api/v4/Tools/SAClientUtilBundle" + "?os=" + VersionUtil.getOS() : WebServiceUtil.getServer() + "/api/v4/Tools/SAClientUtil" + "?os=" + VersionUtil.getOS();
        }
        return url;
    }

    static int compare(String localVersion, String serverVersion) {
        if (localVersion != null && serverVersion != null) {
            String[] local = localVersion.split("\\.");
            String[] server = serverVersion.split("\\.");
            try {
                for (int iter = 0; iter < local.length && iter < server.length; ++iter) {
                    int lVersion = Integer.parseInt(local[iter]);
                    int sVersion = Integer.parseInt(server[iter]);
                    if (iter == 0 && lVersion < sVersion) {
                        return 3;
                    }
                    if (iter == 1 && lVersion != sVersion) {
                        return 2;
                    }
                    if (iter != 2 || lVersion == sVersion) continue;
                    return 1;
                }
            }
            catch (NumberFormatException e) {
                CommonCore.getLogManager().log(new Message(2, Messages.getMessage("err.local.version.check", new Object[0])));
            }
        }
        return 0;
    }

    static boolean isLower(String localVersion, String serverVersion) {
        if (localVersion != null && serverVersion != null) {
            String[] local = localVersion.split("\\.");
            String[] server = serverVersion.split("\\.");
            for (int iter = 0; iter < local.length && iter < server.length; ++iter) {
                int lVersion = Integer.parseInt(local[iter]);
                int sVersion = Integer.parseInt(server[iter]);
                if (!(iter == 0 && lVersion < sVersion || iter == 1 && lVersion < sVersion) && (iter != 2 || lVersion >= sVersion)) continue;
                return true;
            }
        }
        return false;
    }
}

