/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.utils;

import com.ibm.appscan.common.SaaSConstants;
import com.ibm.appscan.common.utils.ServerUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import java.util.regex.Pattern;

public class WebServiceUtil
implements SaaSConstants {
    private static final String INVALID_CHAR_REGEX = "^[()._ -]+$";

    public static String getApiEnv() {
        if (SystemUtil.isDevelopment()) {
            return "Local";
        }
        return "SCX";
    }

    public static String getSCXServer() {
        if (!WebServiceUtil.getApiEnv().equals("SCX")) {
            return "https://cloud.appscan.com";
        }
        return WebServiceUtil.getServer();
    }

    public static String getServer() {
        return ServerUtil.getServerUrl();
    }

    public static boolean isV2APIs() {
        return false;
    }

    public static String getServer(String key) {
        key = key.contains("_") ? key.substring(0, key.indexOf("_")) : null;
        return ServerUtil.getServerUrl(key);
    }

    public static boolean isValidFilename(String filename) {
        for (int i = 0; i < filename.length(); ++i) {
            char c = filename.charAt(i);
            if (Character.isSpaceChar(c) || Character.isLetterOrDigit(c) || Pattern.matches(INVALID_CHAR_REGEX, c + "")) continue;
            return false;
        }
        return true;
    }

    public static String getValidFilename(String filename) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < filename.length(); ++i) {
            char c = filename.charAt(i);
            if (!Character.isSpaceChar(c) && !Character.isLetterOrDigit(c) && !Pattern.matches(INVALID_CHAR_REGEX, c + "")) continue;
            builder.append(c);
        }
        return builder.toString();
    }
}

