/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.common.build;

import com.ibm.appscan.common.build.BuilderDefinition;
import com.ibm.appscan.common.build.BuilderType;
import com.ibm.appscan.common.build.IBuildManager;
import com.ibm.appscan.common.xml.XMLFileReader;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;

public class BuilderReader
extends XMLFileReader {
    private static final String E_BUILDER = "Builder";
    private static final String E_PROPERTY = "Property";
    private static final String A_TYPE = "type";
    private static final String A_NAME = "name";
    private static final String A_VALUE = "value";
    private String m_name;
    private IBuildManager m_buildManager;
    private BuilderDefinition m_tempBuilder = null;
    private BuilderDefinition m_builder = null;
    private Map<String, String> m_properties = new Hashtable<String, String>();

    public BuilderReader(File file, IBuildManager buildManager) {
        super(file);
        this.m_buildManager = buildManager;
    }

    private boolean processBuilder(StartElement element) {
        BuilderType<? extends BuilderDefinition> builderType;
        this.m_name = this.getAttribute(element, A_NAME);
        String type = this.getAttribute(element, A_TYPE);
        if (type != null && (builderType = this.m_buildManager.getBuilderType(type)) != null) {
            this.m_tempBuilder = builderType.create();
            return true;
        }
        return false;
    }

    private void processProperty(StartElement element) {
        String name = this.getAttribute(element, A_NAME);
        String value = this.getAttribute(element, A_VALUE);
        if (name != null && value != null) {
            this.m_properties.put(name, value);
        }
    }

    @Override
    protected boolean process(StartElement element) {
        String name = element.getName().getLocalPart();
        if (E_BUILDER.equals(name)) {
            return this.processBuilder(element);
        }
        if (E_PROPERTY.equals(name)) {
            this.processProperty(element);
        }
        return true;
    }

    @Override
    protected boolean process(EndElement element) {
        if (E_BUILDER.equals(element.getName().getLocalPart()) && this.m_tempBuilder != null) {
            if (this.m_tempBuilder.init(this.m_name, this.m_properties)) {
                this.m_builder = this.m_tempBuilder;
            }
            return false;
        }
        return true;
    }

    public BuilderDefinition getBuilder() {
        return this.m_builder;
    }
}

