/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.common.logging;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.logging.LogManager;
import com.ibm.appscan.common.logging.Message;
import java.io.File;
import java.util.logging.Logger;

public class DefaultLogManager
extends LogManager {
    private static final Logger FALLBACK_LOG = Logger.getLogger("com.ibm.appscan.common");
    private String m_logName;

    public DefaultLogManager(String logName) {
        this.m_logName = logName;
    }

    @Override
    public File getLogFile() {
        return new File(CommonCore.getDirectoryLocator().getLogs(), this.m_logName);
    }

    @Override
    protected void fallbackLog(Message message) {
        switch (message.getSeverity()) {
            case 4: {
                FALLBACK_LOG.severe(message.getText());
                break;
            }
            case 2: {
                FALLBACK_LOG.warning(message.getText());
                break;
            }
            default: {
                FALLBACK_LOG.info(message.getText());
            }
        }
    }

    @Override
    public void log(Exception e) {
        this.log(new Message(e));
    }
}

