/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.exclude;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.exclude.Loader;
import com.ibm.appscan.exclude.exclusions.AspExclusion;
import com.ibm.appscan.exclude.exclusions.BaseExclusion;
import com.ibm.appscan.exclude.exclusions.CPPExclusion;
import com.ibm.appscan.exclude.exclusions.CssExclusion;
import com.ibm.appscan.exclude.exclusions.DotNetExclusion;
import com.ibm.appscan.exclude.exclusions.ExclusionException;
import com.ibm.appscan.exclude.exclusions.JSExclusion;
import com.ibm.appscan.exclude.exclusions.JavaExclusion;
import com.ibm.appscan.exclude.exclusions.PhpExclusion;
import java.util.HashMap;

public class ExclusionProvider {
    private HashMap<Language.LANGUAGE, BaseExclusion> m_exclusions = new HashMap();
    private static ExclusionProvider s_exclusion_provider = new ExclusionProvider();

    private ExclusionProvider() {
    }

    private HashMap<Language.LANGUAGE, BaseExclusion> getExclusions() {
        return this.m_exclusions;
    }

    private static ExclusionProvider getInstance() {
        return s_exclusion_provider;
    }

    public static BaseExclusion getExclusion(Language.LANGUAGE lang) throws ExclusionException {
        if (!ExclusionProvider.getInstance().getExclusions().containsKey(lang)) {
            if (lang == Language.LANGUAGE.JAVA) {
                ExclusionProvider.getInstance().getExclusions().put(lang, new JavaExclusion());
            } else if (lang == Language.LANGUAGE.DOT_NET) {
                ExclusionProvider.getInstance().getExclusions().put(lang, new DotNetExclusion());
            } else if (lang == Language.LANGUAGE.PHP) {
                ExclusionProvider.getInstance().getExclusions().put(lang, new PhpExclusion());
            } else if (lang == Language.LANGUAGE.C_PLUS_PLUS) {
                ExclusionProvider.getInstance().getExclusions().put(lang, new CPPExclusion());
            } else if (lang == Language.LANGUAGE.ASP) {
                ExclusionProvider.getInstance().getExclusions().put(lang, new AspExclusion());
            } else if (lang == Language.LANGUAGE.JAVASCRIPT) {
                ExclusionProvider.getInstance().getExclusions().put(lang, new JSExclusion());
            } else if (lang == Language.LANGUAGE.CSS) {
                ExclusionProvider.getInstance().getExclusions().put(lang, new CssExclusion());
            }
            if (ExclusionProvider.getInstance().getExclusions().get(lang) != null && !SystemUtil.isThirdParty()) {
                Loader l = new Loader(ExclusionProvider.getInstance().getExclusions().get(lang));
                l.load();
            }
        }
        return ExclusionProvider.getInstance().getExclusions().get(lang);
    }

    public static BaseExclusion getExclusion(String lang) throws ExclusionException {
        Language.LANGUAGE language = Language.getLanguage((String)lang);
        return ExclusionProvider.getExclusion(language);
    }

    public static enum EXCLUSION_TYPE {
        INCLUSION{

            public String toString() {
                return "inclusions";
            }
        }
        ,
        EXCLUSION{

            public String toString() {
                return "exclusions";
            }
        };

    }
}

