/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.exclude.exclusions;

import com.ibm.appscan.common.xml.DOMWriter;
import com.ibm.appscan.exclude.ExclusionFileInformation;
import com.ibm.appscan.exclude.ExclusionProvider;
import com.ibm.appscan.exclude.exclusions.BaseExclusion;
import com.ibm.appscan.exclude.exclusions.ExclusionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;

public class ExclusionWriter
extends ExclusionFileInformation {
    private DocumentBuilder m_builder;
    private Transformer m_transformer;

    public ExclusionWriter(BaseExclusion ex) {
        super(ex);
    }

    public void write() throws ExclusionException {
        this.writeExclusons(this.getExclusion());
    }

    public void writeExclusons(BaseExclusion ex) throws ExclusionException {
        this.write(ex.getExcludedPackages(), ex.getExcludedClasses(), ex.getExcludedMethods(), ex.getExcludedFiles(), ExclusionProvider.EXCLUSION_TYPE.EXCLUSION);
    }

    public void write(Set<String> packages, Set<String> classes, Set<String> methods, Set<String> files, ExclusionProvider.EXCLUSION_TYPE type) throws ExclusionException {
        if (packages != null && packages.size() > 0 || classes != null && classes.size() > 0 || methods != null && methods.size() > 0 || files != null && files.size() > 0) {
            DOMWriter writer;
            File f = type == ExclusionProvider.EXCLUSION_TYPE.EXCLUSION ? this.getExclusionFile() : this.getInclusionFile();
            try {
                this.init();
                writer = new DOMWriter(f, this.m_builder);
            }
            catch (IOException e) {
                throw new ExclusionException(e);
            }
            if (type == ExclusionProvider.EXCLUSION_TYPE.EXCLUSION) {
                writer.beginElement("Exclusions");
            } else if (type == ExclusionProvider.EXCLUSION_TYPE.INCLUSION) {
                writer.beginElement("Inclusions");
            } else {
                writer.beginElement("Unknown");
            }
            if (packages != null && packages.size() > 0) {
                writer.beginElement("packages");
                for (String pack : this.getSortedList(packages)) {
                    writer.beginElement("package");
                    writer.setAttribute("name", pack);
                    writer.endElement();
                }
                writer.endElement();
            }
            if (classes != null && classes.size() > 0) {
                writer.beginElement("classes");
                for (String clazz : this.getSortedList(classes)) {
                    writer.beginElement("class");
                    writer.setAttribute("name", clazz);
                    writer.endElement();
                }
                writer.endElement();
            }
            if (methods != null && methods.size() > 0) {
                writer.beginElement("methods");
                if (methods != null && methods.size() > 0) {
                    for (String method : this.getSortedList(methods)) {
                        writer.beginElement("method");
                        writer.setAttribute("name", method);
                        writer.endElement();
                    }
                }
                writer.endElement();
            }
            if (files != null && files.size() > 0) {
                writer.beginElement("files");
                for (String file : this.getSortedList(files)) {
                    writer.beginElement("file");
                    writer.setAttribute("name", file);
                    writer.endElement();
                }
                writer.endElement();
            }
            writer.endElement();
            try {
                writer.write(this.m_transformer);
            }
            catch (TransformerException e) {
                throw new ExclusionException(e);
            }
        }
    }

    private ArrayList<String> getSortedList(Set<String> list) {
        ArrayList<String> ret = new ArrayList<String>(list);
        Collections.sort(ret);
        return ret;
    }

    private void init() throws ExclusionException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            this.m_builder = factory.newDocumentBuilder();
            TransformerFactory transform_factory = TransformerFactory.newInstance();
            this.m_transformer = transform_factory.newTransformer();
            this.m_transformer.setOutputProperty("indent", "yes");
            this.m_transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            this.m_transformer.setOutputProperty("standalone", "yes");
        }
        catch (ParserConfigurationException e) {
            throw new ExclusionException(e);
        }
        catch (TransformerConfigurationException tce) {
            throw new ExclusionException(tce);
        }
    }
}

