/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.cg;

import java.io.Serializable;

public class AccuracyLevel
implements Serializable {
    private static final long serialVersionUID = -3123460509887654321L;
    private static final int DEFAULT_LEVEL = 2;
    private static final AccuracyLevel defaultAccuracyLevel = AccuracyLevel.makeFromLevel(2);
    private static final AccuracyLevel defaultSummaryLevel = AccuracyLevel.makeFromLevel(2, 1);
    private static final AccuracyLevel defaultUnboundedLevel = AccuracyLevel.makeFromLevel(2, Integer.MAX_VALUE);
    private final int accuracyLevel;
    private final int tabulationBound;
    private final int maxCallGraphSize;
    private int initialExpansionBound;

    public static AccuracyLevel getDefaultLevel() {
        return defaultAccuracyLevel;
    }

    public static AccuracyLevel getDefaultSummaryLevel() {
        return defaultSummaryLevel;
    }

    public static AccuracyLevel getDefaultUnboundedLevel() {
        return defaultUnboundedLevel;
    }

    public static AccuracyLevel makeFromLevel(int accuracyLevel) {
        return AccuracyLevel.makeFromLevel(accuracyLevel, 3 + (accuracyLevel - 2));
    }

    public static AccuracyLevel makeFromLevel(int accuracyLevel, int initialExpansionBound) {
        if (accuracyLevel < 0 || accuracyLevel >= 10) {
            throw new IllegalArgumentException("expected accuracy level to be 0 to 9, but was " + accuracyLevel);
        }
        int tabulationBound = 1000000 + (accuracyLevel - 2) * 100000;
        int maxCallGraphSize = tabulationBound / 100;
        return new AccuracyLevel(accuracyLevel, tabulationBound, maxCallGraphSize, initialExpansionBound);
    }

    private AccuracyLevel(int accuracyLevel, int tabulationBound, int maxCallGraphSize, int initialExpansionBound) {
        this.tabulationBound = tabulationBound;
        this.accuracyLevel = accuracyLevel;
        this.maxCallGraphSize = maxCallGraphSize;
        this.initialExpansionBound = initialExpansionBound;
    }

    public int getTabulationBound() {
        return this.tabulationBound;
    }

    public int getMaxCallGraphSize() {
        return this.maxCallGraphSize;
    }

    public int getInitialExpansionBound() {
        return this.initialExpansionBound;
    }

    public String toString() {
        return "" + this.accuracyLevel;
    }
}

