/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.core;

import com.ibm.wala.andromeda.cg.util.TaintAnalysisCache;
import com.ibm.wala.andromeda.models.OfflineSpecification;
import com.ibm.wala.andromeda.util.QueueNoDuplicates;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.CodeScanner;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.SparseVector;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.impl.NodeWithNumber;
import com.ibm.wala.util.graph.impl.SlowSparseNumberedGraph;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CHATaintCallGraph
implements CallGraph {
    private final IClassHierarchy cha;
    private final SlowSparseNumberedGraph<CGNode> g = SlowSparseNumberedGraph.make();
    private final Map<MethodReference, CGNode> mr2node = HashMapFactory.make();
    private final OfflineSpecification spec;
    private final Collection<CGNode> leaves = HashSetFactory.make();
    private Collection<CGNode> entrypointNodes;

    public CHATaintCallGraph(IClassHierarchy cha, Collection<IMethod> entryMethods, OfflineSpecification spec) {
        this.cha = cha;
        this.spec = spec;
        this.build(entryMethods);
    }

    private void build(Collection<IMethod> entryMethods) {
        this.createEntrypointNodes(entryMethods);
        QueueNoDuplicates q = new QueueNoDuplicates();
        for (CGNode en : this.entrypointNodes) {
            this.registerNode(en);
            q.push((Object)en);
        }
        while (!q.isEmpty()) {
            CGNode n = (CGNode)q.pop();
            IMethod m = n.getMethod();
            if (this.spec.hasSpecForMethod(m)) {
                this.leaves.add(n);
                continue;
            }
            Collection callSiteRefs = null;
            try {
                callSiteRefs = CodeScanner.getCallSites((IMethod)m);
            }
            catch (InvalidClassFileException e) {
                System.err.println("Could not scan method " + m.getSignature() + (Object)((Object)e));
                this.leaves.add(n);
                continue;
            }
            assert (callSiteRefs != null);
            if (callSiteRefs.isEmpty()) {
                this.leaves.add(n);
            }
            for (CallSiteReference csr : callSiteRefs) {
                Set possibleTargets = this.cha.getPossibleTargets(csr.getDeclaredTarget());
                for (IMethod possibleTarget : possibleTargets) {
                    CHANode tn = new CHANode(possibleTarget);
                    this.registerNode(n, tn, csr);
                    q.push((Object)tn);
                }
            }
        }
    }

    private void createEntrypointNodes(Collection<IMethod> entryMethods) {
        this.entrypointNodes = HashSetFactory.make((int)entryMethods.size());
        for (IMethod em : entryMethods) {
            if (em.isNative() || em.isSynthetic()) continue;
            CHANode en = new CHANode(em);
            this.entrypointNodes.add(en);
        }
    }

    private void registerNode(CGNode n) {
        MethodReference mr = n.getMethod().getReference();
        this.mr2node.put(mr, n);
        this.g.addNode((Object)n);
    }

    private void registerNode(CGNode n, CGNode succNode, CallSiteReference csr) {
        MethodReference mr = succNode.getMethod().getReference();
        this.mr2node.put(mr, succNode);
        this.g.addNode((Object)succNode);
        this.g.addEdge((Object)n, (Object)succNode);
        n.addTarget(csr, succNode);
    }

    public Collection<CGNode> getLeaves() {
        return this.leaves;
    }

    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }

    public Collection<CGNode> getEntrypointNodes() {
        return this.entrypointNodes;
    }

    public CGNode getFakeRootNode() {
        Assertions.UNREACHABLE();
        return null;
    }

    public CGNode getNode(IMethod method, Context C) {
        return this.mr2node.get(method.getReference());
    }

    public Set<CGNode> getNodes(MethodReference m) {
        return Collections.singleton(this.mr2node.get(m));
    }

    public int getNumberOfTargets(CGNode node, CallSiteReference site) {
        return this.getPossibleTargets(node, site).size();
    }

    public Iterator<CallSiteReference> getPossibleSites(CGNode src, CGNode target) {
        ArrayList<CallSiteReference> result = new ArrayList<CallSiteReference>();
        CHANode caller = (CHANode)src;
        Iterator it = src.iterateCallSites();
        while (it.hasNext()) {
            CallSiteReference site = (CallSiteReference)it.next();
            if (!caller.getPossibleTargets(site).contains(target)) continue;
            result.add(site);
        }
        return result.iterator();
    }

    public Set<CGNode> getPossibleTargets(CGNode node, CallSiteReference site) {
        assert (node instanceof CHANode);
        CHANode n = (CHANode)node;
        return n.getPossibleTargets(site);
    }

    public void removeNodeAndEdges(CGNode N) throws UnsupportedOperationException {
        this.g.removeNodeAndEdges((Object)N);
    }

    public void addNode(CGNode n) {
        this.g.addNode((Object)n);
    }

    public boolean containsNode(CGNode N) {
        return this.g.containsNode((Object)N);
    }

    public int getNumberOfNodes() {
        return this.g.getNumberOfNodes();
    }

    public Iterator<CGNode> iterator() {
        return this.g.iterator();
    }

    public void removeNode(CGNode n) {
        this.g.removeNode((Object)n);
    }

    public void addEdge(CGNode src, CGNode dst) {
        this.g.addEdge((Object)src, (Object)dst);
    }

    public int getPredNodeCount(CGNode N) {
        return this.g.getPredNodeCount((Object)N);
    }

    public Iterator<CGNode> getPredNodes(CGNode N) {
        return this.g.getPredNodes((Object)N);
    }

    public int getSuccNodeCount(CGNode N) {
        return this.g.getSuccNodeCount((Object)N);
    }

    public Iterator<CGNode> getSuccNodes(CGNode N) {
        return this.g.getSuccNodes((Object)N);
    }

    public boolean hasEdge(CGNode src, CGNode dst) {
        return this.g.hasEdge((Object)src, (Object)dst);
    }

    public void removeAllIncidentEdges(CGNode node) throws UnsupportedOperationException {
        this.g.removeAllIncidentEdges((Object)node);
    }

    public void removeEdge(CGNode src, CGNode dst) throws UnsupportedOperationException {
        this.g.removeEdge((Object)src, (Object)dst);
    }

    public void removeIncomingEdges(CGNode node) throws UnsupportedOperationException {
        this.g.removeIncomingEdges((Object)node);
    }

    public void removeOutgoingEdges(CGNode node) throws UnsupportedOperationException {
        this.g.removeOutgoingEdges((Object)node);
    }

    public int getMaxNumber() {
        return this.g.getMaxNumber();
    }

    public CGNode getNode(int number) {
        return (CGNode)this.g.getNode(number);
    }

    public int getNumber(CGNode N) {
        return this.g.getNumber((Object)N);
    }

    public Iterator<CGNode> iterateNodes(IntSet s) {
        return this.g.iterateNodes(s);
    }

    public IntSet getPredNodeNumbers(CGNode node) {
        return this.g.getPredNodeNumbers((Object)node);
    }

    public IntSet getSuccNodeNumbers(CGNode node) {
        return this.g.getSuccNodeNumbers((Object)node);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (CGNode n : this.g) {
            result.append(n + "\n");
            if (n.getMethod() == null) continue;
            Iterator sites = n.iterateCallSites();
            while (sites.hasNext()) {
                CallSiteReference site = (CallSiteReference)sites.next();
                Iterator<CGNode> targets = this.getPossibleTargets(n, site).iterator();
                if (targets.hasNext()) {
                    result.append(" - " + site + "\n");
                }
                while (targets.hasNext()) {
                    CGNode target = targets.next();
                    result.append("     -> " + target + "\n");
                }
            }
        }
        return result.toString();
    }

    public CGNode getFakeWorldClinitNode() {
        return null;
    }

    public class CHANode
    extends NodeWithNumber
    implements CGNode {
        private final SparseVector<IntSet> targets = new SparseVector();
        private final IMethod m;

        public CHANode(IMethod m) {
            this.m = m;
        }

        public boolean addTarget(CallSiteReference site, CGNode target) {
            int n;
            int pc = site.getProgramCounter();
            MutableSharedBitVectorIntSet s = (MutableSharedBitVectorIntSet)this.targets.get(pc);
            if (s == null) {
                s = new MutableSharedBitVectorIntSet();
                this.targets.set(pc, (Object)s);
            }
            if (s.contains(n = CHATaintCallGraph.this.g.getNumber((Object)target))) {
                return false;
            }
            s.add(n);
            CHATaintCallGraph.this.g.addEdge((Object)this, (Object)target);
            return true;
        }

        public Set<CGNode> getPossibleTargets(CallSiteReference site) {
            IntSet s = (IntSet)this.targets.get(site.getProgramCounter());
            if (s == null) {
                return Collections.emptySet();
            }
            HashSet result = HashSetFactory.make((int)s.size());
            IntIterator it = s.intIterator();
            while (it.hasNext()) {
                result.add(CHATaintCallGraph.this.g.getNode(it.next()));
            }
            return result;
        }

        public Context getContext() {
            return Everywhere.EVERYWHERE;
        }

        public DefUse getDU() {
            return TaintAnalysisCache.soleInstance().getDefUse(this.m, (Context)Everywhere.EVERYWHERE);
        }

        public IR getIR() {
            return TaintAnalysisCache.soleInstance().getIR(this.m, (Context)Everywhere.EVERYWHERE);
        }

        public IMethod getMethod() {
            return this.m;
        }

        public Iterator<CallSiteReference> iterateCallSites() {
            Iterator<CallSiteReference> result;
            try {
                result = CodeScanner.getCallSites((IMethod)this.m).iterator();
            }
            catch (InvalidClassFileException icfe) {
                result = Collections.emptySet().iterator();
            }
            return result;
        }

        public Iterator<NewSiteReference> iterateNewSites() {
            Iterator<NewSiteReference> result;
            try {
                result = CodeScanner.getNewSites((IMethod)this.m).iterator();
            }
            catch (InvalidClassFileException icfe) {
                result = Collections.emptySet().iterator();
            }
            return result;
        }

        public IClassHierarchy getClassHierarchy() {
            return CHATaintCallGraph.this.cha;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.m == null ? 0 : this.m.getSignature().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            CHANode other = (CHANode)((Object)obj);
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.m == null ? other.m != null : !this.m.getSignature().equals(other.m.getSignature()));
        }

        public String toString() {
            return "Node: " + this.m.toString();
        }

        private CHATaintCallGraph getOuterType() {
            return CHATaintCallGraph.this;
        }
    }
}

