/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.andromeda.core;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DependenceMap<T> {
    private final Map<T, Set<T>> internalMap = HashMapFactory.make();

    public void registerElement(T element) {
        if (!this.internalMap.containsKey(element)) {
            this.internalMap.put(element, HashSetFactory.make());
        }
    }

    public void registerDependence(T element, T dependent) {
        Set dependents = MapUtil.findOrCreateSet(this.internalMap, element);
        dependents.add(dependent);
    }

    public void registerDependence(T element, Set<T> dependents) {
        if (!this.internalMap.containsKey(element)) {
            this.internalMap.put(element, HashSetFactory.make());
        }
        this.internalMap.get(element).addAll(dependents);
    }

    public Set<T> getElements() {
        return this.internalMap.keySet();
    }

    public void registerDependences(T element, Set<T> dependents) {
        Set<Object> mappedSet;
        if (!this.internalMap.containsKey(element)) {
            mappedSet = HashSetFactory.make();
            this.internalMap.put(element, mappedSet);
        } else {
            mappedSet = this.internalMap.get(element);
        }
        for (T dependent : dependents) {
            mappedSet.add(dependent);
        }
    }

    public Set<T> getDependents(T element) {
        Set<T> mapDependents = this.internalMap.get(element);
        HashSet result = HashSetFactory.make();
        if (mapDependents != null) {
            result.addAll(mapDependents);
            mapDependents.clear();
        }
        return result;
    }

    public void clear() {
        this.internalMap.clear();
    }
}

