/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.source.scanner.results;

import com.hcl.appscan.source.scanner.ActionRunner;
import com.hcl.appscan.source.scanner.Messages;
import com.hcl.appscan.source.scanner.logging.SourceCodeScannerException;
import com.hcl.appscan.source.scanner.results.ConvertResultsAction;
import com.hcl.appscan.source.scanner.results.FilteredFile;
import com.hcl.appscan.source.scanner.results.GetResultsAction;
import com.hcl.appscan.source.scanner.results.IResult;
import com.hcl.appscan.source.scanner.storage.IScanStorage;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.IOUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.json.JSON;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class SourceCodeScannerResult
implements IResult {
    private String m_jobId;
    private IScanStorage m_storage;
    private IProgress m_progress;
    private File m_rawResult;
    private JSONObject m_rawJsonResult;

    public SourceCodeScannerResult(String jobId, IScanStorage storage, IProgress progress) {
        this.m_jobId = jobId;
        this.m_storage = storage;
        this.m_progress = progress;
    }

    @Override
    public void getRawResult(File destination) throws SourceCodeScannerException {
        this.m_progress.setStatus(new Message(1, Messages.getMessage("getting.results", new Object[0])));
        this.m_rawResult = new File(destination, this.m_jobId + ".json");
        GetResultsAction getResultAction = new GetResultsAction(this.m_jobId, this.m_rawResult, this.m_storage);
        ActionRunner.executeAction(getResultAction, this.m_progress);
    }

    @Override
    public void getConvertedResult(File destination, Map<String, String> sourceFileMap, String language) throws SourceCodeScannerException {
        if (this.m_rawResult == null || !this.m_rawResult.isFile()) {
            this.getRawResult(destination);
        }
        try {
            this.loadRawResult();
        }
        catch (FileNotFoundException | JSONException e) {
            throw new SourceCodeScannerException(e);
        }
        this.m_progress.setStatus(new Message(1, Messages.getMessage("processing.results", new Object[0])));
        ConvertResultsAction convertResultAction = new ConvertResultsAction(this.m_rawJsonResult, destination, this.m_jobId, sourceFileMap, language);
        ActionRunner.executeAction(convertResultAction, this.m_progress, 1);
    }

    @Override
    public List<String> getErrorFiles() throws SourceCodeScannerException {
        try {
            ArrayList<String> files = new ArrayList<String>();
            JSONObject rawResult = this.loadRawResult();
            JSONArray errorFiles = rawResult.getJSONArray("ErrorFiles");
            for (int i = 0; i < errorFiles.length(); ++i) {
                files.add(errorFiles.getString(i));
            }
            return files;
        }
        catch (FileNotFoundException | JSONException e) {
            throw new SourceCodeScannerException(e);
        }
    }

    @Override
    public List<FilteredFile> getFilteredFiles() throws SourceCodeScannerException {
        try {
            ArrayList<FilteredFile> filteredFiles = new ArrayList<FilteredFile>();
            JSONObject rawResult = this.loadRawResult();
            JSONArray filtered = rawResult.getJSONArray("FilteredFiles");
            for (int i = 0; i < filtered.length(); ++i) {
                filteredFiles.add(new FilteredFile(filtered.getJSONObject(i)));
            }
            return filteredFiles;
        }
        catch (FileNotFoundException | JSONException e) {
            throw new SourceCodeScannerException(e);
        }
    }

    private JSONObject loadRawResult() throws FileNotFoundException, JSONException {
        if (this.m_rawJsonResult == null) {
            FileReader reader = new FileReader(this.m_rawResult);
            try {
                this.m_rawJsonResult = (JSONObject)JSON.parse((Reader)reader);
            }
            finally {
                IOUtil.close((Closeable)reader);
            }
        }
        return this.m_rawJsonResult;
    }
}

