/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.aspdotnetmvc3;

import com.ibm.appscan.frameworks.FrameworksInput;
import com.ibm.appscan.frameworks.aspdotnet.AspDotNetEntrypoints;
import com.ibm.appscan.frameworks.aspdotnet.AspDotNetFrameworkInfoGenerator;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.processing.F4FActionProcessor;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.collections.HashMapFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class EntrypointCreator {
    private F4FApp app;
    private FrameworksInput fwInput;
    private Map<String, Set<String>> entrypointSig2UrlMap;
    private List<String> excludedEntrypointSigList = new ArrayList<String>();

    public EntrypointCreator(FrameworksInput fwInput, F4FApp app) {
        this.app = app;
        this.fwInput = fwInput;
    }

    public void addExcludedEntrypoint(String entryPointSig) {
        this.excludedEntrypointSigList.add(entryPointSig);
    }

    public void generateEntryPoints() {
        this.initializeEntrypointSig2UrlMap();
        this.removeExcludedEntrypoints();
        for (String key : this.entrypointSig2UrlMap.keySet()) {
            for (String value : this.entrypointSig2UrlMap.get(key)) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.method.url", (Object[])new Object[]{key, value}));
            }
        }
        F4FActionProcessor.addUrls(this.entrypointSig2UrlMap);
    }

    private void initializeEntrypointSig2UrlMap() {
        try {
            Properties options = this.fwInput.getOptions();
            String precompileOutputDir = options.getProperty("aspnet.precompile.dir");
            if (precompileOutputDir != null) {
                String virtualPath = AspDotNetFrameworkInfoGenerator.getVirtualPath((Properties)options);
                AspDotNetEntrypoints oldAspDotNetEntryPoints = AspDotNetEntrypoints.make((String)precompileOutputDir, (String)virtualPath, (IClassHierarchy)this.app.getClassHierarchy());
                this.entrypointSig2UrlMap = oldAspDotNetEntryPoints.generateEntrypointSig2URLMapping();
            }
            if (this.entrypointSig2UrlMap == null) {
                this.entrypointSig2UrlMap = HashMapFactory.make();
            }
        }
        catch (Exception e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
    }

    private void removeExcludedEntrypoints() {
        if (this.entrypointSig2UrlMap == null) {
            this.initializeEntrypointSig2UrlMap();
        }
        for (String currSig : this.excludedEntrypointSigList) {
            if (!this.entrypointSig2UrlMap.containsKey(currSig)) continue;
            this.entrypointSig2UrlMap.remove(currSig);
        }
    }
}

