/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.jsp.compilers;

import com.ibm.appscan.common.xml.XMLFileReader;
import com.ibm.appscan.common.xml.XMLStreamReader;
import java.io.File;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;

public class ServletMappings
extends XMLFileReader {
    private static final String SERVLET = "servlet";
    private static final String SERVLET_MAPPING = "servlet-mapping";
    private static final String SERVLET_NAME = "servlet-name";
    private static final String SERVLET_CLASS = "servlet-class";
    private static final String URL_PATTERN = "url-pattern";
    private String m_currentName = null;
    private String m_currentClass = null;
    private String m_currentPattern = null;
    private Map<String, String> m_servlets = new Hashtable<String, String>();
    private Map<String, String> m_servletMappings = new Hashtable<String, String>();

    public ServletMappings(File descriptor) {
        super(descriptor);
    }

    protected boolean process(StartElement element, XMLStreamReader.ElementValue value) throws XMLStreamException {
        String name = element.getName().getLocalPart();
        if (SERVLET.equals(name)) {
            this.m_currentName = null;
            this.m_currentClass = null;
        } else if (SERVLET_MAPPING.equals(name)) {
            this.m_currentName = null;
            this.m_currentPattern = null;
        } else if (SERVLET_NAME.equals(name)) {
            this.m_currentName = value.getText();
        } else if (SERVLET_CLASS.equals(name)) {
            this.m_currentClass = value.getText();
        } else if (URL_PATTERN.equals(name)) {
            this.m_currentPattern = value.getText();
        }
        return true;
    }

    protected boolean process(EndElement element) {
        String name = element.getName().getLocalPart();
        if (SERVLET.equals(name)) {
            if (this.m_currentName != null && this.m_currentClass != null) {
                this.m_servlets.put(this.m_currentName, this.m_currentClass);
            }
        } else if (SERVLET_MAPPING.equals(name) && this.m_currentName != null && this.m_currentPattern != null) {
            this.m_servletMappings.put(this.m_currentPattern, this.m_currentName);
        }
        return true;
    }

    public String getServletClass(String path) {
        String name = this.m_servletMappings.get(path);
        return name == null ? null : this.m_servlets.get(name);
    }
}

