/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class PPFInfo {
    private boolean loaded = false;
    private final List<String> sourceRoots = new ArrayList<String>();
    private final List<String> sourceExcludes = new ArrayList<String>();
    String ppfFileName;

    public PPFInfo() {
    }

    public static PPFInfo make(String inPpfFileName) throws XPathExpressionException {
        return new PPFInfo(inPpfFileName);
    }

    public List<String> getSourceRoots() {
        if (!this.loaded) {
            this.loadFile();
        }
        return this.sourceRoots;
    }

    public List<String> getExcludedSources() {
        if (!this.loaded) {
            this.loadFile();
        }
        return this.sourceExcludes;
    }

    private PPFInfo(String inputFileName) {
        this.ppfFileName = inputFileName;
    }

    private void loadFile() {
        try {
            File ppfFile = new File(this.ppfFileName);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document ppfDoc = db.parse(ppfFile);
            this.getSourceRoots(ppfDoc);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void getSourceRoots(Document doc) {
        try {
            String docuri = doc.getDocumentURI();
            File parent = null;
            if (docuri != null && docuri.length() > 0) {
                parent = new File(new URI(docuri)).getParentFile();
            }
            NodeList sourceNodes = doc.getElementsByTagName("Source");
            for (int i = 0; i < sourceNodes.getLength(); ++i) {
                NamedNodeMap attributes = sourceNodes.item(i).getAttributes();
                String path = attributes.getNamedItem("path").getNodeValue();
                String exclude = attributes.getNamedItem("exclude").getNodeValue();
                String web = attributes.getNamedItem("web").getNodeValue();
                File sourceDir = null;
                sourceDir = parent != null ? new File(parent, path.trim()) : new File(path.trim());
                if (exclude.equals("true")) {
                    this.sourceExcludes.add(sourceDir.getCanonicalPath());
                    continue;
                }
                this.sourceRoots.add(sourceDir.getCanonicalPath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

