/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.aspdotnet;

import com.ibm.appscan.frameworks.util.DOMParserWithLineNumbers;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class CompiledFileInfo {
    private String virtualPath;
    private String type;
    private String assembly;

    public CompiledFileInfo(String filename) throws FileNotFoundException, IOException, SAXException {
        DOMParserWithLineNumbers parser = new DOMParserWithLineNumbers(filename);
        Document document = parser.getDocument();
        this.populate(document, filename);
    }

    private void populate(Document document, String filename) {
        XPath xpath = this.createXPath();
        try {
            XPathExpression xPathExpression = xpath.compile("/preserve");
            Node preserveNode = (Node)xPathExpression.evaluate(document, XPathConstants.NODE);
            if (preserveNode != null) {
                this.virtualPath = this.getStringAttrValue(preserveNode, "virtualPath");
                this.type = this.getStringAttrValue(preserveNode, "type");
                this.assembly = this.getStringAttrValue(preserveNode, "assembly");
            }
        }
        catch (XPathExpressionException e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.parsing", (Object[])new Object[]{filename}));
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
    }

    private XPath createXPath() {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        return xpath;
    }

    public String getVirtualPath() {
        return this.virtualPath;
    }

    public String getType() {
        return this.type;
    }

    public String getAssembly() {
        return this.assembly;
    }

    private String getStringAttrValue(Node item, String attrName) {
        Node value = item.getAttributes().getNamedItem(attrName);
        return value == null ? null : value.getNodeValue();
    }
}

