/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.aspdotnet.util;

import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.dotnet.loader.CLRClass;
import com.ibm.wala.dotnet.loader.CLRLanguage;
import com.ibm.wala.dotnet.types.CLRTypeReference;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.strings.StringStuff;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DotNetVDBUtil {
    public static final Map<String, String> systemName2VDBShortName;
    private static final Logger taintLogger;
    private static final Map<String, String> vdbShortName2SystemName;
    private static final Set<String> fullyQualifiedPrimitiveTypes;

    public static String walaDotNet2VDBSignature(String walaDotNetSig) {
        return DotNetVDBUtil.convert2VDBSigHelper(walaDotNetSig, false);
    }

    public static String unqualified2QualifiedVDBSignature(String unqualifiedVDBSig) {
        return DotNetVDBUtil.walaDotNet2FullyQualifiedVDBSignature(DotNetVDBUtil.vdb2WalaDotNetSignature(unqualifiedVDBSig));
    }

    public static String walaDotNet2FullyQualifiedVDBSignature(String walaDotNetSig) {
        return DotNetVDBUtil.convert2VDBSigHelper(walaDotNetSig, true);
    }

    public static String convertWalaDotNetGenericSig2VDB(TypeReference ref, IClassHierarchy cha) throws UnresolvedGenericTypeException {
        if (DotNetVDBUtil.instantiatedGenericType(ref)) {
            CLRClass clrKlass = (CLRClass)cha.lookupClass(ref);
            if (clrKlass == null) {
                taintLogger.debug((Object)("could not resolve generic type " + ref));
                throw new UnresolvedGenericTypeException();
            }
            assert (clrKlass.isWith());
            IClass baseKlass = clrKlass.withGetBase();
            if (baseKlass == null) {
                taintLogger.debug((Object)("could not resolve base class of generic type " + clrKlass));
                throw new UnresolvedGenericTypeException();
            }
            String walaDeclaringType = baseKlass.getName().toString();
            walaDeclaringType = walaDeclaringType.substring(0, walaDeclaringType.indexOf("`"));
            StringBuilder vdbType = new StringBuilder(DotNetVDBUtil.walaDotNet2FullyQualifiedVDBType(walaDeclaringType));
            vdbType.append("<");
            for (int i = 0; i < clrKlass.withGetNumParams(); ++i) {
                IClass typeParam = clrKlass.withGetParam(i);
                if (typeParam == null) {
                    taintLogger.debug((Object)("could not resolve type parameter " + i + " of generic type " + clrKlass + ", base type " + baseKlass));
                    throw new UnresolvedGenericTypeException();
                }
                vdbType.append(DotNetVDBUtil.convertWalaDotNetGenericSig2VDB(typeParam.getReference(), cha));
                if (i >= clrKlass.withGetNumParams() - 1) continue;
                vdbType.append(",");
            }
            vdbType.append(">");
            String vdbTypeStr = vdbType.toString();
            if (vdbTypeStr.contains("<")) {
                vdbTypeStr = vdbTypeStr.replaceAll("<", "&lt;");
            }
            return vdbTypeStr;
        }
        return DotNetVDBUtil.walaDotNet2FullyQualifiedVDBType(ref.getName().toUnicodeString());
    }

    private static boolean instantiatedGenericType(TypeReference t) {
        String packageName = t.getName().getPackage().toString();
        return packageName.equals("with");
    }

    private static String convert2VDBSigHelper(String walaDotNetSig, boolean fullyQualified) {
        int ind = walaDotNetSig.indexOf(40);
        String methodName = walaDotNetSig.substring(0, ind);
        String descriptor = walaDotNetSig.substring(ind);
        TypeName[] parameterTypeNames = StringStuff.parseForParameterNames((Language)CLRLanguage.lang, (String)descriptor);
        TypeName returnType = StringStuff.parseForReturnTypeName((Language)CLRLanguage.lang, (String)descriptor);
        StringBuilder result = new StringBuilder();
        String vdbMethodName = DotNetVDBUtil.walaToVDBMethodName(methodName);
        result.append(vdbMethodName);
        result.append('(');
        if (parameterTypeNames != null) {
            for (int i = 0; i < parameterTypeNames.length; ++i) {
                String parameterType = DotNetVDBUtil.convert2VDBTypeHelper(parameterTypeNames[i].toUnicodeString(), fullyQualified);
                result.append(parameterType);
                if (i >= parameterTypeNames.length - 1) continue;
                result.append(';');
            }
        }
        result.append("):");
        result.append(DotNetVDBUtil.convert2VDBTypeHelper(returnType.toUnicodeString(), fullyQualified));
        return result.toString();
    }

    public static String walaToVDBMethodName(String methodName) {
        if (methodName.endsWith(".ctor")) {
            String[] names = methodName.split("\\.");
            String unqualifiedTypeName = names[names.length - 3];
            methodName = methodName.replace(".ctor", unqualifiedTypeName);
        }
        methodName = methodName.replace(".cctor", "<cctor>");
        methodName = methodName.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        return methodName;
    }

    public static String walaDotNet2VDBType(String walaDotNetType) {
        return DotNetVDBUtil.convert2VDBTypeHelper(walaDotNetType, false);
    }

    public static String walaDotNet2FullyQualifiedVDBType(String walaDotNetType) {
        return DotNetVDBUtil.convert2VDBTypeHelper(walaDotNetType, true);
    }

    private static String convert2VDBTypeHelper(String walaDotNetType, boolean fullyQualified) {
        if (walaDotNetType == null) {
            throw new IllegalArgumentException("jvmType is null");
        }
        StringBuffer readable = new StringBuffer();
        int numberOfDimensions = 0;
        if (walaDotNetType.length() == 0) {
            throw new IllegalArgumentException("ill-formed type : " + walaDotNetType);
        }
        walaDotNetType = DotNetVDBUtil.stripRefAndPtr(walaDotNetType);
        char prefix = walaDotNetType.charAt(0);
        while (prefix == '[') {
            prefix = walaDotNetType.charAt(++numberOfDimensions);
        }
        String typeName = walaDotNetType.substring(numberOfDimensions);
        typeName = DotNetVDBUtil.stripRefAndPtr(typeName);
        typeName = typeName.substring(1);
        typeName = StringStuff.slashToDot((String)typeName);
        if (!fullyQualified && systemName2VDBShortName.containsKey(typeName)) {
            typeName = systemName2VDBShortName.get(typeName);
        }
        readable.append(typeName);
        for (int i = 0; i < numberOfDimensions; ++i) {
            readable.append("[]");
        }
        String vdbTypeStr = readable.toString();
        if (vdbTypeStr.contains("<")) {
            vdbTypeStr = vdbTypeStr.replaceAll("<", "&lt;");
        }
        return vdbTypeStr;
    }

    private static String stripRefAndPtr(String walaDotNetType) {
        int index = 0;
        char c = walaDotNetType.charAt(index);
        while (c == '&' || c == '*') {
            c = walaDotNetType.charAt(++index);
        }
        return walaDotNetType.substring(index);
    }

    public static String vdb2WalaDotNetSignature(String vdbSig) {
        int openParenInd = vdbSig.indexOf(40);
        String methodName = vdbSig.substring(0, openParenInd);
        String vdbDescriptor = vdbSig.substring(openParenInd);
        StringBuilder result = new StringBuilder();
        result.append(methodName);
        result.append('(');
        int closeIndInDescriptor = vdbDescriptor.indexOf(41);
        String vdbParams = vdbDescriptor.substring(1, closeIndInDescriptor);
        String vdbReturn = vdbDescriptor.substring(closeIndInDescriptor + 2);
        if (!vdbParams.equals("")) {
            String[] vdbParamTypes = vdbParams.split(";");
            for (int i = 0; i < vdbParamTypes.length; ++i) {
                result.append(DotNetVDBUtil.vdb2WalaDotNetDescriptorType(vdbParamTypes[i]));
            }
        }
        result.append(')');
        result.append(DotNetVDBUtil.vdb2WalaDotNetDescriptorType(vdbReturn));
        return result.toString();
    }

    public static String vdb2WalaDotNetDescriptorType(String vdbType) {
        if (vdbType == null) {
            throw new IllegalArgumentException("dString is null");
        }
        int arrayIndex = vdbType.indexOf("[]");
        if (arrayIndex > -1) {
            String baseType = vdbType.substring(0, arrayIndex);
            int dim = (vdbType.length() - arrayIndex) / 2;
            baseType = DotNetVDBUtil.vdb2WalaDotNetDescriptorType(baseType);
            StringBuffer result = new StringBuffer("[");
            for (int i = 1; i < dim; ++i) {
                result.append("[");
            }
            result.append(baseType);
            return result.toString();
        }
        String result = vdbType;
        if (vdbShortName2SystemName.containsKey(result)) {
            result = vdbShortName2SystemName.get(result);
        }
        String prefix = fullyQualifiedPrimitiveTypes.contains(result) ? "P" : "L";
        return prefix + result.replace('.', '/') + ";";
    }

    public static String vdb2WalaDotNetType(String vdbType) {
        if (vdbType == null) {
            throw new IllegalArgumentException("dString is null");
        }
        int arrayIndex = vdbType.indexOf("[]");
        if (arrayIndex > -1) {
            String baseType = vdbType.substring(0, arrayIndex);
            int dim = (vdbType.length() - arrayIndex) / 2;
            baseType = DotNetVDBUtil.vdb2WalaDotNetType(baseType);
            StringBuffer result = new StringBuffer("[");
            for (int i = 1; i < dim; ++i) {
                result.append("[");
            }
            result.append(baseType);
            return result.toString();
        }
        String result = vdbType;
        if (vdbShortName2SystemName.containsKey(result)) {
            result = vdbShortName2SystemName.get(result);
        }
        String prefix = fullyQualifiedPrimitiveTypes.contains(result) ? "P" : "L";
        return prefix + result.replace('.', '/');
    }

    static {
        taintLogger = TaintLogger.i().getLogger();
        HashMap tmp = HashMapFactory.make();
        tmp.put("System.String", "string");
        tmp.put("System.Int32", "int");
        tmp.put("System.Int16", "short");
        tmp.put("System.Int64", "long");
        tmp.put("System.Char", "char");
        tmp.put("System.Boolean", "bool");
        tmp.put("System.IntPtr", "IntPtr");
        tmp.put("System.UInt16", "ushort");
        tmp.put("System.UInt32", "uint");
        tmp.put("System.UInt64", "ulong");
        tmp.put("System.Void", "void");
        systemName2VDBShortName = Collections.unmodifiableMap(tmp);
        vdbShortName2SystemName = MapUtil.invertOneToOneMap(systemName2VDBShortName);
        fullyQualifiedPrimitiveTypes = HashSetFactory.make();
        for (String primitiveType : CLRTypeReference.getAllPrimitives()) {
            fullyQualifiedPrimitiveTypes.add(StringStuff.slashToDot((String)primitiveType));
        }
    }

    public static class UnresolvedGenericTypeException
    extends Exception {
    }
}

