/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.condition;

import com.ibm.wala.stringAnalysis.condition.AndCondition;
import com.ibm.wala.stringAnalysis.condition.ConjunctiveCondition;
import com.ibm.wala.stringAnalysis.condition.FalseCondition;
import com.ibm.wala.stringAnalysis.condition.ICondition;
import com.ibm.wala.stringAnalysis.condition.IPathCondition;
import com.ibm.wala.stringAnalysis.condition.IPathConditionCollector;
import com.ibm.wala.stringAnalysis.condition.IPrimitiveCondition;
import com.ibm.wala.stringAnalysis.condition.OrCondition;
import com.ibm.wala.stringAnalysis.condition.PathCondition;
import com.ibm.wala.stringAnalysis.condition.RefCondition;
import com.ibm.wala.stringAnalysis.condition.TrueCondition;
import com.ibm.wala.util.debug.Assertions;

public class Normalizer {
    static Normalizer singleton = new Normalizer();

    protected Normalizer() {
    }

    public static Normalizer create() {
        return singleton;
    }

    public IPathCondition normalize(ICondition e, IPathConditionCollector collector, int d) {
        if (e instanceof TrueCondition) {
            PathCondition ret = new PathCondition();
            ConjunctiveCondition empty = new ConjunctiveCondition();
            ret.add(empty);
            return ret;
        }
        if (e instanceof FalseCondition) {
            PathCondition ret = new PathCondition();
            return ret;
        }
        if (e instanceof IPrimitiveCondition) {
            PathCondition ret = new PathCondition();
            ConjunctiveCondition singleton = new ConjunctiveCondition();
            singleton.add((IPrimitiveCondition)e);
            ret.add(singleton);
            return ret;
        }
        if (e instanceof OrCondition) {
            OrCondition oc = (OrCondition)e;
            IPathCondition e1 = this.normalize(oc.e1, collector, d);
            IPathCondition e2 = this.normalize(oc.e2, collector, d);
            PathCondition ret = new PathCondition();
            ret.addAll(e1);
            ret.addAll(e2);
            return ret;
        }
        if (e instanceof AndCondition) {
            AndCondition ac = (AndCondition)e;
            IPathCondition e1 = this.normalize(ac.e1, collector, d);
            IPathCondition e2 = this.normalize(ac.e2, collector, d);
            PathCondition ret = new PathCondition();
            for (ConjunctiveCondition c1 : e1) {
                for (ConjunctiveCondition c2 : e2) {
                    ConjunctiveCondition conj = new ConjunctiveCondition();
                    conj.addAll(c1);
                    conj.addAll(c2);
                    ret.add(conj);
                }
            }
            return ret;
        }
        if (e instanceof RefCondition) {
            IPathCondition p;
            RefCondition rc = (RefCondition)e;
            if (d > 0 && (p = collector.getCondition(rc.bb, --d)) != null) {
                return p;
            }
            PathCondition ret = new PathCondition();
            ConjunctiveCondition empty = new ConjunctiveCondition();
            ret.add(empty);
            return ret;
        }
        Assertions.UNREACHABLE((Object)e);
        return null;
    }
}

