/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.condition.dnf;

import com.ibm.wala.stringAnalysis.condition.IPrimitiveCondition;
import com.ibm.wala.stringAnalysis.condition.dnf.Conjuction;
import com.ibm.wala.stringAnalysis.condition.dnf.Dnf;
import com.ibm.wala.stringAnalysis.condition.dnf.Formula;
import com.ibm.wala.stringAnalysis.condition.dnf.Term;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.perf.Stopwatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class DnfMinimizer {
    private static ArrayList<Pair<String, Long>> timings = null;
    private static Stopwatch swGlobal = null;
    private final Map<Dnf, Dnf> cache = HashMapFactory.make();

    public static void traceTimings() {
        timings = new ArrayList();
        swGlobal = new Stopwatch();
    }

    public static void printTiming() {
        if (timings == null) {
            throw new IllegalStateException("Should call traceTimings before analysis.");
        }
        System.out.println("Timing: " + swGlobal.getCount() + " invocations in " + ((double)swGlobal.getElapsedMillis() + 0.0) / 1000.0 + " seconds");
        Collections.sort(timings, new Comparator<Pair<String, Long>>(){

            @Override
            public int compare(Pair<String, Long> o1, Pair<String, Long> o2) {
                int ret = (int)((Long)o1.snd - (Long)o2.snd);
                if (ret == 0) {
                    ret = ((String)o1.fst).compareTo((String)o2.fst);
                }
                return ret;
            }
        });
        for (Pair<String, Long> p : timings) {
            System.out.println(p);
        }
    }

    public Dnf minimize(Dnf dnf) {
        Dnf ret = this.cache.get(dnf);
        if (ret == null) {
            Stopwatch swCurrent = null;
            if (timings != null) {
                swCurrent = new Stopwatch();
                swCurrent.start();
            }
            ret = DnfMinimizer.minimize_(dnf);
            if (timings != null) {
                swCurrent.stop();
                long elapsedMillis = swCurrent.getElapsedMillis();
                timings.add((Pair<String, Long>)Pair.make((Object)(dnf.toString() + " -> " + ret.toString()), (Object)elapsedMillis));
            }
            this.cache.put(dnf, ret);
            this.cache.put(ret, ret);
        }
        return ret;
    }

    private static Dnf minimize_(Dnf dnf) {
        Dnf ret;
        if (dnf.getNumberOfDisjunctions() <= 1) {
            ret = dnf;
        } else {
            Collection<IPrimitiveCondition> allPrimitiveConditions = dnf.getAllPrimitiveConditions();
            ArrayList<IPrimitiveCondition> baseConditions = new ArrayList<IPrimitiveCondition>();
            for (IPrimitiveCondition c : allPrimitiveConditions) {
                DnfMinimizer.findOrCreate(baseConditions, c);
            }
            int n = baseConditions.size();
            assert (n > 0);
            Formula f = DnfMinimizer.dnfToFormula(dnf, baseConditions, n);
            f.reduceToPrimeImplicants();
            f.reducePrimeImplicantsToSubset();
            ret = DnfMinimizer.formulaToDnf(f, baseConditions, n);
        }
        return ret;
    }

    private static Dnf formulaToDnf(Formula f, List<IPrimitiveCondition> baseConditions, int n) {
        ArrayList<Conjuction> conjunctions = new ArrayList<Conjuction>();
        for (Term t : f.getTerms()) {
            ArrayList<IPrimitiveCondition> primitiveConditions = new ArrayList<IPrimitiveCondition>();
            byte[] vals = t.getVals();
            for (int i = 0; i < n; ++i) {
                if (vals[i] == 1) {
                    primitiveConditions.add(baseConditions.get(i));
                    continue;
                }
                if (vals[i] != 0) continue;
                primitiveConditions.add(baseConditions.get(i).inverse());
            }
            IPrimitiveCondition[] primitiveConditionsArr = new IPrimitiveCondition[primitiveConditions.size()];
            primitiveConditions.toArray(primitiveConditionsArr);
            Conjuction c = Conjuction.make(primitiveConditionsArr);
            conjunctions.add(c);
        }
        Conjuction[] conjunctionsArr = new Conjuction[conjunctions.size()];
        conjunctions.toArray(conjunctionsArr);
        return new Dnf(conjunctionsArr);
    }

    private static Formula dnfToFormula(Dnf dnf, List<IPrimitiveCondition> baseConditions, int n) {
        Conjuction[] disjunctions = dnf.getDisjunctions();
        ArrayList<Term> terms = new ArrayList<Term>(disjunctions.length);
        for (int i = 0; i < disjunctions.length; ++i) {
            Conjuction c = disjunctions[i];
            terms.add(c.toTerm(baseConditions));
        }
        Formula f = new Formula(terms);
        return f;
    }

    private static int findOrCreate(List<IPrimitiveCondition> baseConditions, IPrimitiveCondition c) {
        for (int i = 0; i < baseConditions.size(); ++i) {
            IPrimitiveCondition c1 = baseConditions.get(i);
            if (c1.equals(c)) {
                return i + 1;
            }
            if (!c1.inverse().equals(c)) continue;
            return -(i + 1);
        }
        baseConditions.add(c);
        return baseConditions.size();
    }
}

