/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.ssa;

import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.util.collections.SortedIterator;
import com.ibm.wala.automaton.util.labeledgraph.MutableEdgeDecorator;
import com.ibm.wala.automaton.util.labeledgraph.SimpleMutableEdgeDecorator;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.stringAnalysis.util.SecSAUtil;
import com.ibm.wala.util.collections.CompoundIterator;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public abstract class LabelledSSACFG<T>
implements ControlFlowGraph<SSAInstruction, ISSABasicBlock>,
MutableEdgeDecorator<ISSABasicBlock, T> {
    private final SSACFGEdgeDecorator<T> labels = new SSACFGEdgeDecorator();
    private final Map<ISSABasicBlock, Set<ISSABasicBlock>> succLabels = new HashMap<ISSABasicBlock, Set<ISSABasicBlock>>();
    private final Map<ISSABasicBlock, Set<ISSABasicBlock>> predLabels = new HashMap<ISSABasicBlock, Set<ISSABasicBlock>>();
    private final SSACFG ssacfg;

    public LabelledSSACFG(SSACFG aCFG) {
        this.ssacfg = aCFG;
    }

    protected abstract void makeLabels();

    public void addLabel(ISSABasicBlock src, T label, ISSABasicBlock dest) {
        this.labels.addLabel(src.getNumber(), label, dest.getNumber());
        if (!this.ssacfg.hasEdge(src, dest)) {
            this.labels.addLabel(src.getNumber(), label, dest.getNumber());
            Set<ISSABasicBlock> succ = this.succLabels.get(src);
            if (succ == null) {
                succ = new HashSet<ISSABasicBlock>();
                this.succLabels.put(src, succ);
            }
            succ.add(dest);
            Set<ISSABasicBlock> pred = this.predLabels.get(dest);
            if (pred == null) {
                pred = new HashSet<ISSABasicBlock>();
                this.predLabels.put(dest, pred);
            }
            pred.add(src);
        }
    }

    public T getLabel(ISSABasicBlock src, ISSABasicBlock dest) {
        return (T)this.labels.getLabel(src.getNumber(), dest.getNumber());
    }

    public String dump(String indent) {
        SortedIterator ibb = new SortedIterator(this.iterator(), SecSAUtil.nodeNumberComparator);
        Vector<ISSABasicBlock> l = new Vector<ISSABasicBlock>(this.getNumberOfNodes());
        StringBuilder buf = new StringBuilder(l.size() * 16);
        while (ibb.hasNext()) {
            ISSABasicBlock b = (ISSABasicBlock)ibb.next();
            l.add(b);
            SortedIterator ibb2 = new SortedIterator(this.getSuccNodes(b), SecSAUtil.nodeNumberComparator);
            while (ibb2.hasNext()) {
                ISSABasicBlock b2 = (ISSABasicBlock)ibb2.next();
                buf.append(indent);
                buf.append(b.getGraphNodeId());
                buf.append(this.edgeToString(b, b2));
                buf.append(b2.getGraphNodeId());
                buf.append(SAUtil.lineSeparator);
            }
        }
        return buf.toString();
    }

    public String toString() {
        return this.dump(SAUtil.lineSeparator);
    }

    public String edgeToString(ISSABasicBlock n1, ISSABasicBlock n2) {
        return this.labels.edgeToString(n1.getNumber(), n2.getNumber());
    }

    public void removeLabel(ISSABasicBlock src, ISSABasicBlock dest) {
        this.labels.removeLabel(src.getNumber(), dest.getNumber());
    }

    public boolean hasEdge(ISSABasicBlock src, ISSABasicBlock dst) {
        return this.ssacfg.hasEdge(src, dst) || null != this.labels.getLabel(src.getNumber(), dst.getNumber());
    }

    public int getPredNodeCount(ISSABasicBlock b) throws IllegalArgumentException {
        Set<ISSABasicBlock> s = this.predLabels.get(b);
        int n = s == null ? 0 : s.size();
        return this.ssacfg.getPredNodeCount(b) + n;
    }

    public IntSet getPredNodeNumbers(ISSABasicBlock node) throws UnimplementedError {
        IntSet s1 = this.ssacfg.getPredNodeNumbers(node);
        BitVectorIntSet s2 = new BitVectorIntSet();
        Set<ISSABasicBlock> ns = this.predLabels.get(node);
        if (ns != null) {
            for (ISSABasicBlock bb : ns) {
                s2.add(bb.getNumber());
            }
        }
        return s1.union((IntSet)s2);
    }

    public Iterator<ISSABasicBlock> getPredNodes(ISSABasicBlock b) throws IllegalArgumentException {
        Iterator i1 = this.ssacfg.getPredNodes(b);
        Set<ISSABasicBlock> s2 = this.predLabels.get(b);
        return s2 == null ? i1 : new CompoundIterator(i1, s2.iterator());
    }

    public int getSuccNodeCount(ISSABasicBlock b) throws IllegalArgumentException {
        Set<ISSABasicBlock> s = this.succLabels.get(b);
        int n = s == null ? 0 : s.size();
        return this.ssacfg.getSuccNodeCount(b) + n;
    }

    public IntSet getSuccNodeNumbers(ISSABasicBlock b) throws IllegalArgumentException {
        IntSet s1 = this.ssacfg.getSuccNodeNumbers(b);
        BitVectorIntSet s2 = new BitVectorIntSet();
        Set<ISSABasicBlock> ns = this.succLabels.get(b);
        if (ns != null) {
            for (ISSABasicBlock bb : ns) {
                s2.add(bb.getNumber());
            }
        }
        return s1.union((IntSet)s2);
    }

    public Iterator<ISSABasicBlock> getSuccNodes(ISSABasicBlock b) throws IllegalArgumentException {
        Iterator i1 = this.ssacfg.getSuccNodes(b);
        Set<ISSABasicBlock> s2 = this.succLabels.get(b);
        return s2 == null ? i1 : new CompoundIterator(i1, s2.iterator());
    }

    public String toGraphviz() {
        StringBuffer buff = new StringBuffer();
        buff.append("digraph G {");
        buff.append(AUtil.lineSeparator);
        buff.append("  \"\" [fillcolor=black, shape=point]");
        buff.append(AUtil.lineSeparator);
        buff.append("  \"\" -> \"0\";");
        buff.append(AUtil.lineSeparator);
        ArrayList<String> lines = new ArrayList<String>();
        Iterator<ISSABasicBlock> i = this.iterator();
        while (i.hasNext()) {
            ISSABasicBlock bb = i.next();
            Iterator<ISSABasicBlock> j = this.getSuccNodes(bb);
            while (j.hasNext()) {
                ISSABasicBlock nbb = j.next();
                T label = this.getLabel(bb, nbb);
                String line = "  \"" + bb.getNumber() + "\" -> \"" + nbb.getNumber() + "\"";
                if (label != null) {
                    line = line + "\" [label=\"" + label + "\"]";
                }
                line = line + ";";
                lines.add(line);
            }
        }
        Collections.sort(lines);
        for (String line : lines) {
            buff.append(line);
            buff.append(AUtil.lineSeparator);
        }
        buff.append("}");
        return buff.toString();
    }

    public ISSABasicBlock entry() {
        return this.ssacfg.entry();
    }

    public ISSABasicBlock exit() {
        return this.ssacfg.exit();
    }

    public ISSABasicBlock getBlockForInstruction(int index) {
        return this.ssacfg.getBlockForInstruction(index);
    }

    public BitVector getCatchBlocks() {
        return this.ssacfg.getCatchBlocks();
    }

    public Collection<ISSABasicBlock> getExceptionalPredecessors(ISSABasicBlock b) {
        return this.ssacfg.getExceptionalPredecessors(b);
    }

    public List<ISSABasicBlock> getExceptionalSuccessors(ISSABasicBlock b) {
        return this.ssacfg.getExceptionalSuccessors(b);
    }

    public SSAInstruction[] getInstructions() {
        return this.ssacfg.getInstructions();
    }

    public IMethod getMethod() {
        return this.ssacfg.getMethod();
    }

    public Collection<ISSABasicBlock> getNormalPredecessors(ISSABasicBlock b) {
        return this.ssacfg.getNormalPredecessors(b);
    }

    public Collection<ISSABasicBlock> getNormalSuccessors(ISSABasicBlock b) {
        return this.ssacfg.getNormalSuccessors(b);
    }

    public int getProgramCounter(int index) {
        return this.ssacfg.getProgramCounter(index);
    }

    public void removeNodeAndEdges(ISSABasicBlock n) throws UnsupportedOperationException {
        this.ssacfg.removeNodeAndEdges(n);
    }

    public void addNode(ISSABasicBlock n) {
        this.ssacfg.addNode(n);
    }

    public boolean containsNode(ISSABasicBlock n) {
        return this.ssacfg.containsNode(n);
    }

    public int getNumberOfNodes() {
        return this.ssacfg.getNumberOfNodes();
    }

    public Iterator<ISSABasicBlock> iterator() {
        return this.ssacfg.iterator();
    }

    public void removeNode(ISSABasicBlock n) {
        this.ssacfg.removeNode(n);
    }

    public void addEdge(ISSABasicBlock src, ISSABasicBlock dst) {
        this.ssacfg.addEdge(src, dst);
    }

    public void removeAllIncidentEdges(ISSABasicBlock node) throws UnsupportedOperationException {
        this.ssacfg.removeAllIncidentEdges(node);
    }

    public void removeEdge(ISSABasicBlock src, ISSABasicBlock dst) throws UnsupportedOperationException {
        this.ssacfg.removeEdge(src, dst);
    }

    public void removeIncomingEdges(ISSABasicBlock node) throws UnsupportedOperationException {
        this.ssacfg.removeIncomingEdges(node);
    }

    public void removeOutgoingEdges(ISSABasicBlock node) throws UnsupportedOperationException {
        this.ssacfg.removeOutgoingEdges(node);
    }

    public int getMaxNumber() {
        return this.ssacfg.getMaxNumber();
    }

    public ISSABasicBlock getNode(int number) {
        return this.ssacfg.getNode(number);
    }

    public int getNumber(ISSABasicBlock N) {
        return this.ssacfg.getNumber(N);
    }

    public Iterator<ISSABasicBlock> iterateNodes(IntSet s) {
        return this.ssacfg.iterateNodes(s);
    }

    public SSACFG.BasicBlock getBasicBlock(int bb) {
        return this.ssacfg.getBasicBlock(bb);
    }

    protected class SSACFGEdgeDecorator<X>
    extends SimpleMutableEdgeDecorator<Integer, X> {
        protected SSACFGEdgeDecorator() {
        }

        public String edgeToString(Integer n1, Integer n2) {
            Object label = this.getLabel(n1, n2);
            if (label == null) {
                return " --> ";
            }
            return " -{" + label.toString() + "}-> ";
        }
    }
}

