/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.ssa;

import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.cfg.Util;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.ssa.ConstantValue;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.ssa.Value;
import com.ibm.wala.stringAnalysis.condition.AndCondition;
import com.ibm.wala.stringAnalysis.condition.CaseCondition;
import com.ibm.wala.stringAnalysis.condition.DefCondition;
import com.ibm.wala.stringAnalysis.condition.FalseCondition;
import com.ibm.wala.stringAnalysis.condition.ICondition;
import com.ibm.wala.stringAnalysis.condition.IPrimitiveCondition;
import com.ibm.wala.stringAnalysis.condition.NotCaseCondition;
import com.ibm.wala.stringAnalysis.condition.PhiCondition;
import com.ibm.wala.stringAnalysis.condition.RangeCondition;
import com.ibm.wala.stringAnalysis.condition.RefCondition;
import com.ibm.wala.stringAnalysis.condition.TrueCondition;
import com.ibm.wala.stringAnalysis.condition.VarCondition;
import com.ibm.wala.stringAnalysis.ssa.LabelledSSACFG;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.debug.Assertions;
import java.util.Iterator;

public class SSACFGWithConditions
extends LabelledSSACFG<ICondition> {
    private static boolean useGetBlockForInstruction = true;
    private final IR ir;
    private final DefUse du;

    public SSACFGWithConditions(IR ir) {
        super(ir.getControlFlowGraph());
        this.ir = ir;
        this.du = new DefUse(ir);
        this.makeLabels();
        this.debugPrint(ir);
    }

    private void debugPrint(IR ir) {
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)"-- control-flow graph with condition labels --");
            SAUtil.println((Object)ir);
            SAUtil.println((Object)this);
            SAUtil.println((Object)("digraph " + ir.getMethod().getName() + " {"));
            Iterator<ISSABasicBlock> iterator = this.iterator();
            while (iterator.hasNext()) {
                ISSABasicBlock src = iterator.next();
                Iterator<ISSABasicBlock> iterator2 = this.iterator();
                while (iterator2.hasNext()) {
                    ISSABasicBlock dst = iterator2.next();
                    if (!this.hasEdge(src, dst)) continue;
                    SAUtil.print((Object)("  BB" + src.getNumber() + " -> BB" + dst.getNumber()));
                    ICondition c = this.getLabel(src, dst);
                    if (c == null) {
                        SAUtil.println((Object)";");
                        continue;
                    }
                    SAUtil.println((Object)(" [label=\"" + c + "\"];"));
                }
            }
            SAUtil.println((Object)"}");
        }
    }

    private ISSABasicBlock getBlockForIndex(int index) {
        if (useGetBlockForInstruction) {
            return this.getBlockForInstruction(index);
        }
        return this.getBasicBlock(index);
    }

    protected ICondition getConditionLabel(int v, boolean b) {
        block16: {
            SSAInstruction instruction;
            block17: {
                block15: {
                    instruction = this.du.getDef(v);
                    if (!(instruction instanceof SSAAbstractInvokeInstruction)) break block15;
                    SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)instruction;
                    if (invoke.getDeclaredResultType().equals((Object)TypeReference.Boolean)) {
                        return new VarCondition(b ? v : -v);
                    }
                    if (invoke.getDeclaredResultType().equals((Object)TypeReference.Int)) {
                        return b ? new NotCaseCondition(v, 0) : new CaseCondition(v, 0);
                    }
                    break block16;
                }
                if (!(instruction instanceof SSAUnaryOpInstruction)) break block17;
                SSAUnaryOpInstruction uop = (SSAUnaryOpInstruction)instruction;
                if (uop.getOpcode().equals(IUnaryOpInstruction.Operator.NEG)) {
                    return this.getConditionLabel(uop.getUse(0), !b);
                }
                break block16;
            }
            if (instruction instanceof SSAComparisonInstruction || !(instruction instanceof SSAPhiInstruction)) break block16;
            SSAPhiInstruction phi = (SSAPhiInstruction)instruction;
            int u0 = phi.getUse(0);
            int u1 = phi.getUse(1);
            Value val0 = this.ir.getSymbolTable().getValue(u0);
            Value val1 = this.ir.getSymbolTable().getValue(u1);
            int[] path = new int[]{0, 1};
            if (!(val0 instanceof ConstantValue)) {
                int u = u0;
                u0 = u1;
                u1 = u;
                Value val = val0;
                val0 = val1;
                val1 = val;
                path[0] = 1;
                path[1] = 0;
            }
            if (val0 instanceof ConstantValue) {
                Object obj1;
                Object obj0 = ((ConstantValue)val0).getValue();
                if (obj0 instanceof Boolean) {
                    Boolean bval0 = (Boolean)obj0;
                    IPrimitiveCondition c = (IPrimitiveCondition)this.getConditionLabel(u1, b);
                    if (b == bval0) {
                        PhiCondition phic = new PhiCondition(u1, c);
                        this.appendDef(phic);
                        return phic;
                    }
                    PhiCondition phic1 = new PhiCondition(u1, c);
                    PhiCondition phic2 = new PhiCondition(-u1, FalseCondition.theInstance);
                    this.appendDef(phic1);
                    this.appendDef(phic2);
                    return new AndCondition(phic1, phic2);
                }
                if (obj0 instanceof Integer && val1 instanceof ConstantValue && (obj1 = ((ConstantValue)val1).getValue()) instanceof Integer) {
                    boolean i1;
                    boolean i0 = (Integer)obj0 != 0;
                    boolean bl = i1 = (Integer)obj1 != 0;
                    if (i0 == b) {
                        ISSABasicBlock bb = this.ir.getBasicBlockForInstruction(this.du.getDef(v));
                        int idx = 0;
                        Iterator<ISSABasicBlock> i = this.getPredNodes(bb);
                        while (i.hasNext()) {
                            ISSABasicBlock pred = i.next();
                            if (idx == path[0]) {
                                return new RefCondition(pred.getNumber());
                            }
                            ++idx;
                        }
                    } else if (i1 == b) {
                        ISSABasicBlock bb = this.ir.getBasicBlockForInstruction(this.du.getDef(v));
                        int idx = 0;
                        Iterator<ISSABasicBlock> i = this.getPredNodes(bb);
                        while (i.hasNext()) {
                            ISSABasicBlock pred = i.next();
                            if (idx == path[1]) {
                                return new RefCondition(pred.getNumber());
                            }
                            ++idx;
                        }
                    }
                }
            }
        }
        return TrueCondition.theInstance;
    }

    @Override
    protected void makeLabels() {
        Iterator<ISSABasicBlock> bbs = this.iterator();
        while (bbs.hasNext()) {
            ISSABasicBlock bb = bbs.next();
            this.makeLabels(bb);
        }
    }

    protected void makeLabels(ISSABasicBlock bb) {
        if (bb.getLastInstructionIndex() < 0) {
            return;
        }
        if (Util.endsWithConditionalBranch((ControlFlowGraph)this, (IBasicBlock)bb)) {
            this.makeLabelsForConditionalBranch(bb);
        } else if (Util.endsWithSwitch((ControlFlowGraph)this, (IBasicBlock)bb)) {
            this.makeLabelsForSwitch(bb);
        }
    }

    private void makeLabelsForSwitch(ISSABasicBlock bb) {
        SSASwitchInstruction instr = (SSASwitchInstruction)Util.getLastInstruction((ControlFlowGraph)this, (IBasicBlock)bb);
        int val = instr.getUse(0);
        int defaultIdx = instr.getDefault();
        ISSABasicBlock defaultBlock = this.getBlockForIndex(defaultIdx);
        int[] caseAndLabels = instr.getCasesAndLabels();
        for (int i = 0; i < caseAndLabels.length; ++i) {
            int idx;
            int c = caseAndLabels[i];
            if ((idx = caseAndLabels[++i]) == defaultIdx) continue;
            ISSABasicBlock succ = this.getBlockForIndex(idx);
            CaseCondition cond = new CaseCondition(val, c);
            NotCaseCondition defaultCond = new NotCaseCondition(val, c);
            this.appendLabel(bb, cond, succ);
            this.appendLabel(bb, defaultCond, defaultBlock);
        }
    }

    private void makeLabelsForConditionalBranch(ISSABasicBlock bb) {
        ICondition thenLabel;
        boolean base;
        ISSABasicBlock thenB = (ISSABasicBlock)Util.getTakenSuccessor((ControlFlowGraph)this, (IBasicBlock)bb);
        ISSABasicBlock elseB = (ISSABasicBlock)Util.getNotTakenSuccessor((ControlFlowGraph)this, (IBasicBlock)bb);
        SSAConditionalBranchInstruction instr = (SSAConditionalBranchInstruction)Util.getLastInstruction((ControlFlowGraph)this, (IBasicBlock)bb);
        int condVar0 = instr.getUse(0);
        int condVar1 = instr.getUse(1);
        Value val0 = this.ir.getSymbolTable().getValue(instr.getUse(0));
        Value val1 = this.ir.getSymbolTable().getValue(instr.getUse(1));
        IConditionalBranchInstruction.IOperator op = instr.getOperator();
        if (val0 instanceof ConstantValue) {
            Value t = val0;
            val0 = val1;
            val1 = t;
            int v = condVar0;
            condVar0 = condVar1;
            condVar1 = v;
            if (op.equals(IConditionalBranchInstruction.Operator.GE)) {
                op = IConditionalBranchInstruction.Operator.LE;
            } else if (op.equals(IConditionalBranchInstruction.Operator.GT)) {
                op = IConditionalBranchInstruction.Operator.LT;
            } else if (op.equals(IConditionalBranchInstruction.Operator.LE)) {
                op = IConditionalBranchInstruction.Operator.GE;
            } else if (op.equals(IConditionalBranchInstruction.Operator.LT)) {
                op = IConditionalBranchInstruction.Operator.GT;
            }
        }
        if (!(val1 instanceof ConstantValue)) {
            return;
        }
        ConstantValue cval = (ConstantValue)val1;
        Object obj = cval.getValue();
        if (obj instanceof Integer) {
            Integer ival = (Integer)obj;
            int i = ival;
            if (i != 0 && op.equals(IConditionalBranchInstruction.Operator.EQ)) {
                CaseCondition thenLabel2 = new CaseCondition(condVar0, i);
                NotCaseCondition elseLabel = new NotCaseCondition(condVar0, i);
                this.appendLabel(bb, thenLabel2, thenB);
                this.appendLabel(bb, elseLabel, elseB);
                return;
            }
            if (i != 0 && op.equals(IConditionalBranchInstruction.Operator.NE)) {
                NotCaseCondition thenLabel3 = new NotCaseCondition(condVar0, i);
                CaseCondition elseLabel = new CaseCondition(condVar0, i);
                this.appendLabel(bb, thenLabel3, thenB);
                this.appendLabel(bb, elseLabel, elseB);
                return;
            }
            if (op.equals(IConditionalBranchInstruction.Operator.GE)) {
                RangeCondition thenLabel4 = new RangeCondition(condVar0, i, RangeCondition.Operator.GE);
                RangeCondition elseLabel = new RangeCondition(condVar0, i, RangeCondition.Operator.LT);
                this.appendLabel(bb, thenLabel4, thenB);
                this.appendLabel(bb, elseLabel, elseB);
                return;
            }
            if (op.equals(IConditionalBranchInstruction.Operator.GT)) {
                RangeCondition thenLabel5 = new RangeCondition(condVar0, i, RangeCondition.Operator.GT);
                RangeCondition elseLabel = new RangeCondition(condVar0, i, RangeCondition.Operator.LE);
                this.appendLabel(bb, thenLabel5, thenB);
                this.appendLabel(bb, elseLabel, elseB);
                return;
            }
            if (op.equals(IConditionalBranchInstruction.Operator.LE)) {
                RangeCondition thenLabel6 = new RangeCondition(condVar0, i, RangeCondition.Operator.LE);
                RangeCondition elseLabel = new RangeCondition(condVar0, i, RangeCondition.Operator.GT);
                this.appendLabel(bb, thenLabel6, thenB);
                this.appendLabel(bb, elseLabel, elseB);
                return;
            }
            if (op.equals(IConditionalBranchInstruction.Operator.LT)) {
                RangeCondition thenLabel7 = new RangeCondition(condVar0, i, RangeCondition.Operator.LT);
                RangeCondition elseLabel = new RangeCondition(condVar0, i, RangeCondition.Operator.GE);
                this.appendLabel(bb, thenLabel7, thenB);
                this.appendLabel(bb, elseLabel, elseB);
                return;
            }
            if (i == 0) {
                base = false;
            } else {
                Assertions.UNREACHABLE();
                base = true;
            }
        } else if (obj instanceof Boolean) {
            Boolean bval = (Boolean)obj;
            base = bval;
        } else {
            return;
        }
        if (op.equals(IConditionalBranchInstruction.Operator.EQ)) {
            thenLabel = this.getConditionLabel(condVar0, base);
            ICondition elseLabel = this.getConditionLabel(condVar0, !base);
            this.appendLabel(bb, thenLabel, thenB);
            this.appendLabel(bb, elseLabel, elseB);
        } else if (op.equals(IConditionalBranchInstruction.Operator.NE)) {
            thenLabel = this.getConditionLabel(condVar0, !base);
            ICondition elseLabel = this.getConditionLabel(condVar0, base);
            this.appendLabel(bb, thenLabel, thenB);
            this.appendLabel(bb, elseLabel, elseB);
        } else {
            return;
        }
    }

    @Override
    public void removeLabel(ISSABasicBlock src, ISSABasicBlock dest) {
        Assertions.UNREACHABLE();
    }

    @Override
    public ICondition getLabel(ISSABasicBlock src, ISSABasicBlock dest) {
        return (ICondition)super.getLabel(src, dest);
    }

    public Integer getDefaultLabel() {
        return Integer.MAX_VALUE;
    }

    private void appendDef(PhiCondition label) {
        PhiCondition phi = label;
        int v = phi.vn > 0 ? phi.vn : -phi.vn;
        ISSABasicBlock defBB = this.ir.getBasicBlockForInstruction(this.du.getDef(v));
        Iterator<ISSABasicBlock> i = this.getSuccNodes(defBB);
        while (i.hasNext()) {
            ISSABasicBlock bb = i.next();
            this.appendLabel(defBB, new DefCondition(v), bb);
        }
    }

    private void appendLabel(ISSABasicBlock src, ICondition label, ISSABasicBlock dest) {
        ICondition cond = this.getLabel(src, dest);
        if (cond != null) {
            label = new AndCondition(label, cond);
        }
        super.addLabel(src, label, dest);
    }
}

