/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator;

import com.ibm.wala.automaton.grammar.string.DeepGrammarCopier;
import com.ibm.wala.automaton.grammar.string.DeepRuleCopier;
import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IGrammarCopier;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.IRuleCopier;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.automaton.string.VariableReplacer;
import com.ibm.wala.automaton.util.collections.Bag;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.stringAnalysis.condition.CaseCondition;
import com.ibm.wala.stringAnalysis.condition.ConjunctiveCondition;
import com.ibm.wala.stringAnalysis.condition.FalseCondition;
import com.ibm.wala.stringAnalysis.condition.IPathCondition;
import com.ibm.wala.stringAnalysis.condition.IPathConditionAnalysis;
import com.ibm.wala.stringAnalysis.condition.IPrimitiveCondition;
import com.ibm.wala.stringAnalysis.condition.IPrimitiveConditionVisitor;
import com.ibm.wala.stringAnalysis.condition.NotCaseCondition;
import com.ibm.wala.stringAnalysis.condition.RangeCondition;
import com.ibm.wala.stringAnalysis.condition.TrueCondition;
import com.ibm.wala.stringAnalysis.condition.VarCondition;
import com.ibm.wala.stringAnalysis.grammar.BBVariable;
import com.ibm.wala.stringAnalysis.grammar.CDVariable;
import com.ibm.wala.stringAnalysis.grammar.ConditionedInvocationSymbol;
import com.ibm.wala.stringAnalysis.grammar.ConstraintSymbol;
import com.ibm.wala.stringAnalysis.grammar.GR;
import com.ibm.wala.stringAnalysis.grammar.GRule;
import com.ibm.wala.stringAnalysis.grammar.InvocationSymbol;
import com.ibm.wala.stringAnalysis.grammar.ReturnVariable;
import com.ibm.wala.stringAnalysis.grammar.SignatureSymbol;
import com.ibm.wala.stringAnalysis.translator.IBB2Grammar;
import com.ibm.wala.stringAnalysis.translator.IConstraint;
import com.ibm.wala.stringAnalysis.translator.ISSA2Rule;
import com.ibm.wala.stringAnalysis.translator.ISymbolFactory;
import com.ibm.wala.stringAnalysis.translator.TranslationContext;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelRuntimeException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class PathSensitiveBB2GR<T>
implements IBB2Grammar<T> {
    private final IBB2Grammar<T> base;
    private final IVariableReplacer replaceHandler;
    final Map<ISSABasicBlock, ConstraintCollector<T>> constraintCollectors = new WeakHashMap<ISSABasicBlock, ConstraintCollector<T>>();

    public PathSensitiveBB2GR(IBB2Grammar<T> base, IVariableReplacer replaceHandler) {
        this.base = base;
        this.replaceHandler = replaceHandler;
    }

    public PathSensitiveBB2GR(IBB2Grammar<T> base) {
        this(base, new DefaultVariableReplacer());
    }

    @Override
    public ISSA2Rule<T> getSSA2Rule() {
        return this.base.getSSA2Rule();
    }

    @Override
    public GR translate(ISSABasicBlock bb, TranslationContext ctx) {
        IR ir = ctx.getIR();
        SSACFG cfg = ir.getControlFlowGraph();
        GR g = GR.createEmptyGR(ir);
        GR gr1 = this.base.translate(new SSABasicBlockWithoutPhis(bb), ctx);
        ISSA2Rule<T> ssa2rule = this.getSSA2Rule();
        ISymbolFactory<T> sf = ssa2rule.getSymbolFactory();
        for (SSAInstruction inst : bb) {
            if (!(inst instanceof SSAReturnInstruction)) continue;
            SSAReturnInstruction ret = (SSAReturnInstruction)inst;
            Collection<IVariable> vars = sf.createCDVariable(ret.getUse(0), ctx);
            for (IVariable v : vars) {
                if (!(v instanceof CDVariable)) continue;
                CDVariable cdv = (CDVariable)v;
                ReturnVariable retv = new ReturnVariable(cdv.getValueNumber(), cdv.getCGNode());
                GRule rule = ssa2rule.createRule(ir, (SSAInstruction)ret, retv, new ISymbol[]{cdv});
                gr1.addRule((IProductionRule)rule);
            }
        }
        GR gr2 = this.constrain(gr1, bb, null, -1, ctx);
        g.addRules(gr2.getRules());
        int m = 0;
        Iterator predi = cfg.getPredNodes(bb);
        while (predi.hasNext()) {
            ISSABasicBlock pred = (ISSABasicBlock)predi.next();
            GR pgr1 = this.base.translate(new SSABasicBlockOfPhis(bb, m, ctx.getInstructionFactory()), ctx);
            GR pgr2 = this.constrain(pgr1, bb, pred, m, ctx);
            g.addRules(pgr2.getRules());
            ++m;
        }
        return g;
    }

    private GR constrain(GR gr, ISSABasicBlock bb, ISSABasicBlock pred, int n, TranslationContext ctx) {
        IPathCondition pc;
        if (ctx.getProgressMonitor().isCanceled()) {
            throw CancelRuntimeException.make((String)"during constring");
        }
        IPathConditionAnalysis pca = ctx.getPathConditionAnalysis();
        if (pca == null) {
            return gr;
        }
        IPathCondition iPathCondition = pc = n < 0 ? pca.getCondition(bb) : pca.getConditions(bb).get(n);
        if (pc == null) {
            return gr;
        }
        GR result = null;
        Bag newRules = new Bag();
        IVariableFactory<IVariable> varFactory = this.getSSA2Rule().getSymbolFactory().getVariableFactory();
        for (ConjunctiveCondition condition : pc) {
            ConstraintCollector<T> constraintCollector;
            if (condition.isEmpty()) continue;
            if (this.constraintCollectors.containsKey(bb)) {
                constraintCollector = this.constraintCollectors.get(bb);
            } else {
                constraintCollector = new ConstraintCollector<T>(bb, this.getSSA2Rule().getSymbolFactory(), ctx);
                for (IPrimitiveCondition prim : condition) {
                    prim.visit(constraintCollector);
                }
            }
            Collection<Map<IVariable, ConstraintSymbol>> maps = constraintCollector.getMaps();
            for (Map<IVariable, ConstraintSymbol> m : maps) {
                DeepGrammarCopier copier = new DeepGrammarCopier((IRuleCopier)new DeepRuleCopier((ISymbolCopier)new VariableReplacerByConstraint(m, this.replaceHandler, bb, pred, (Collection<GRule>)newRules, varFactory, ctx)){

                    public IVariable copyLeft(IVariable v) {
                        return v;
                    }
                });
                if (result == null) {
                    result = (GR)gr.copy((IGrammarCopier)copier);
                    continue;
                }
                GR gr2 = (GR)gr.copy((IGrammarCopier)copier);
                result.addRules(gr2.getRules());
            }
        }
        if (result == null) {
            result = gr;
        }
        result.addRules((Collection)newRules);
        return result;
    }

    protected static class SSABasicBlockOfPhis
    extends SSABasicBlockWrapper {
        private final int N;
        final SSAInstructionFactory instructionFactory;

        public SSABasicBlockOfPhis(ISSABasicBlock bb, int N, SSAInstructionFactory instructionFactory) {
            super(bb);
            this.N = N;
            this.instructionFactory = instructionFactory;
        }

        @Override
        public Iterator<SSAPiInstruction> iteratePis() {
            return Collections.emptySet().iterator();
        }

        @Override
        public Iterator<SSAPhiInstruction> iteratePhis() {
            final Iterator<SSAPhiInstruction> i = super.iteratePhis();
            return new Iterator<SSAPhiInstruction>(){

                @Override
                public boolean hasNext() {
                    return i.hasNext();
                }

                @Override
                public SSAPhiInstruction next() {
                    SSAPhiInstruction phi = (SSAPhiInstruction)i.next();
                    SSAPhiInstruction cpy = (SSAPhiInstruction)phi.copyForSSA(SSABasicBlockOfPhis.this.instructionFactory, new int[]{phi.getDef()}, new int[]{phi.getUse(SSABasicBlockOfPhis.this.N)});
                    return cpy;
                }

                @Override
                public void remove() {
                    i.remove();
                }
            };
        }

        @Override
        public Iterator<SSAInstruction> iterator() {
            final Iterator<SSAPhiInstruction> i = this.iteratePhis();
            return new Iterator<SSAInstruction>(){

                @Override
                public boolean hasNext() {
                    return i.hasNext();
                }

                @Override
                public SSAInstruction next() {
                    return (SSAInstruction)i.next();
                }

                @Override
                public void remove() {
                    i.remove();
                }
            };
        }
    }

    protected static class SSABasicBlockWithoutPhis
    extends SSABasicBlockWrapper {
        public SSABasicBlockWithoutPhis(ISSABasicBlock bb) {
            super(bb);
        }

        @Override
        public Iterator<SSAPhiInstruction> iteratePhis() {
            return Collections.emptySet().iterator();
        }

        @Override
        public Iterator<SSAInstruction> iterator() {
            final Iterator<SSAInstruction> i = super.iterator();
            return new Iterator<SSAInstruction>(){
                private SSAInstruction peek;

                @Override
                public boolean hasNext() {
                    this.peek = null;
                    while (i.hasNext()) {
                        this.peek = (SSAInstruction)i.next();
                        if (this.peek instanceof SSAPhiInstruction) continue;
                    }
                    return this.peek != null;
                }

                @Override
                public SSAInstruction next() {
                    return this.peek;
                }

                @Override
                public void remove() {
                    i.remove();
                }
            };
        }
    }

    protected static class SSABasicBlockWrapper
    implements ISSABasicBlock {
        private ISSABasicBlock base;

        public SSABasicBlockWrapper(ISSABasicBlock bb) {
            this.base = bb;
        }

        public Iterator<TypeReference> getCaughtExceptionTypes() {
            return this.base.getCaughtExceptionTypes();
        }

        public int getFirstInstructionIndex() {
            return this.base.getFirstInstructionIndex();
        }

        public int getGraphNodeId() {
            return this.base.getGraphNodeId();
        }

        public SSAInstruction getLastInstruction() {
            return this.base.getLastInstruction();
        }

        public int getLastInstructionIndex() {
            return this.base.getLastInstructionIndex();
        }

        public IMethod getMethod() {
            return this.base.getMethod();
        }

        public int getNumber() {
            return this.base.getNumber();
        }

        public boolean isCatchBlock() {
            return this.base.isCatchBlock();
        }

        public boolean isEntryBlock() {
            return this.base.isEntryBlock();
        }

        public boolean isExitBlock() {
            return this.base.isExitBlock();
        }

        public Iterator<SSAPhiInstruction> iteratePhis() {
            return this.base.iteratePhis();
        }

        public Iterator<SSAPiInstruction> iteratePis() {
            return this.base.iteratePis();
        }

        public Iterator<SSAInstruction> iterator() {
            return this.base.iterator();
        }

        public void setGraphNodeId(int number) {
            this.base.setGraphNodeId(number);
        }
    }

    private static class VariableReplacerByConstraint
    extends VariableReplacer {
        private Collection<GRule> newRules;
        private TranslationContext ctx;
        private IVariableReplacer replaceHandler;
        private ISSABasicBlock bb;
        private ISSABasicBlock pred;
        private IVariableFactory<IVariable> varFactory;

        public VariableReplacerByConstraint(Map<IVariable, ConstraintSymbol> m, IVariableReplacer replaceHandler, ISSABasicBlock bb, ISSABasicBlock pred, Collection<GRule> newRules, IVariableFactory<IVariable> varFactory, TranslationContext ctx) {
            super(m);
            this.ctx = ctx;
            this.replaceHandler = replaceHandler;
            this.bb = bb;
            this.pred = pred;
            this.varFactory = varFactory;
            this.newRules = newRules;
        }

        public Collection<GRule> getAddedRules() {
            return this.newRules;
        }

        public ISymbol copy(ISymbol symbol) {
            if (this.ctx.getProgressMonitor().isCanceled()) {
                throw CancelRuntimeException.make((String)"during copy");
            }
            ISymbol s = super.copy(symbol);
            if (symbol instanceof IVariable && s instanceof ConstraintSymbol) {
                IVariable v = this.replaceHandler.replaceVariable((IVariable)symbol, (ConstraintSymbol)s, this.bb, this.pred, this.ctx, this.varFactory);
                GRule grule = new GRule(v, s);
                this.newRules.add(grule);
                return v;
            }
            return s;
        }
    }

    public static class ConstraintCollector<T>
    implements IPrimitiveConditionVisitor {
        private final TranslationContext ctx;
        private final ISSABasicBlock bb;
        private final ISymbolFactory<T> symFactory;
        private final Collection<Map<IVariable, ConstraintSymbol>> maps;

        public ConstraintCollector(ISSABasicBlock bb, ISymbolFactory<T> symFactory, TranslationContext ctx) {
            this.bb = bb;
            this.ctx = ctx;
            this.symFactory = symFactory;
            this.maps = new HashSet<Map<IVariable, ConstraintSymbol>>();
            this.maps.add(new HashMap());
        }

        public Collection<Map<IVariable, ConstraintSymbol>> getMaps() {
            return this.maps;
        }

        public Collection<Map<IVariable, ConstraintSymbol>> dupMaps() {
            HashSet<Map<IVariable, ConstraintSymbol>> ms = new HashSet<Map<IVariable, ConstraintSymbol>>();
            for (Map<IVariable, ConstraintSymbol> m : this.maps) {
                m = new HashMap<IVariable, ConstraintSymbol>(m);
                ms.add(m);
            }
            return ms;
        }

        private void putAnd(IVariable v, ConstraintSymbol cs) {
            this.putAnd(v, Collections.singleton(cs));
        }

        private void putAnd(IVariable v, Collection<ConstraintSymbol> css) {
            HashSet<Map<IVariable, ConstraintSymbol>> newMaps = new HashSet<Map<IVariable, ConstraintSymbol>>();
            Iterator<ConstraintSymbol> i = css.iterator();
            while (i.hasNext()) {
                Collection<Map<IVariable, ConstraintSymbol>> ms;
                if (this.ctx.getProgressMonitor().isCanceled()) {
                    throw CancelRuntimeException.make((String)"putAnd");
                }
                ConstraintSymbol cs = i.next();
                if (i.hasNext()) {
                    ms = this.dupMaps();
                    newMaps.addAll(ms);
                } else {
                    ms = this.maps;
                }
                for (Map<IVariable, ConstraintSymbol> m : ms) {
                    ConstraintSymbol c = m.get(v);
                    c = c == null ? cs : new ConstraintSymbol(c, cs);
                    m.put(v, c);
                }
            }
            this.maps.addAll(newMaps);
        }

        @Override
        public void onRange(RangeCondition condition) {
            IVariable v = this.symFactory.createValueNumberVariable(condition.var, this.ctx.getCGNode(), this.ctx.getCallGraph());
            SSAInstruction instruction = this.ctx.getDefUse().getDef(condition.var);
            if (instruction instanceof SSAAbstractInvokeInstruction) {
                SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)instruction;
                this.onVarForInvokeInstruction(invoke, condition, true);
            }
            ConstraintSymbol cs = null;
            char min = '\u0000';
            char max = '\uffff';
            switch (condition.op) {
                case GT: {
                    min = (char)(condition.boundary + 1L);
                    cs = new ConstraintSymbol((ISymbol)v, (ISymbol)new RangeSymbol(min, max));
                    this.putAnd(v, cs);
                    break;
                }
                case GE: {
                    min = (char)condition.boundary;
                    cs = new ConstraintSymbol((ISymbol)v, (ISymbol)new RangeSymbol(min, max));
                    this.putAnd(v, cs);
                    break;
                }
                case LT: {
                    max = (char)(condition.boundary - 1L);
                    cs = new ConstraintSymbol((ISymbol)v, (ISymbol)new RangeSymbol(min, max));
                    this.putAnd(v, cs);
                    break;
                }
                case LE: {
                    max = (char)condition.boundary;
                    cs = new ConstraintSymbol((ISymbol)v, (ISymbol)new RangeSymbol(min, max));
                    this.putAnd(v, cs);
                    break;
                }
                case EQ: {
                    cs = new ConstraintSymbol((ISymbol)v, (ISymbol)new CharSymbol((char)condition.boundary));
                    this.putAnd(v, cs);
                    break;
                }
                case NE: {
                    ConstraintSymbol cs1 = new ConstraintSymbol((ISymbol)v, (ISymbol)new RangeSymbol(min, (char)(condition.boundary - 1L)));
                    ConstraintSymbol cs2 = new ConstraintSymbol((ISymbol)v, (ISymbol)new RangeSymbol((char)(condition.boundary + 1L), max));
                    this.putAnd(v, Arrays.asList(cs1, cs2));
                }
            }
        }

        @Override
        public void onCase(CaseCondition condition) {
            IVariable v = this.symFactory.createValueNumberVariable(condition.var, this.ctx.getCGNode(), this.ctx.getCallGraph());
            SSAInstruction instruction = this.ctx.getDefUse().getDef(condition.var);
            if (instruction instanceof SSAAbstractInvokeInstruction) {
                SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)instruction;
                this.onVarForInvokeInstruction(invoke, condition, true);
            }
            ConstraintSymbol cs = new ConstraintSymbol((ISymbol)v, (ISymbol)new CharSymbol((char)condition.label));
            this.putAnd(v, cs);
        }

        @Override
        public void onFalse(FalseCondition condition) {
        }

        @Override
        public void onNotCase(NotCaseCondition condition) {
            IVariable v = this.symFactory.createValueNumberVariable(condition.var, this.ctx.getCGNode(), this.ctx.getCallGraph());
            SSAInstruction instruction = this.ctx.getDefUse().getDef(condition.var);
            if (instruction instanceof SSAAbstractInvokeInstruction) {
                SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)instruction;
                this.onVarForInvokeInstruction(invoke, condition, true);
            }
            ConstraintSymbol cs1 = new ConstraintSymbol((ISymbol)v, (ISymbol)new RangeSymbol('\u0000', (char)(condition.label - 1)));
            ConstraintSymbol cs2 = new ConstraintSymbol((ISymbol)v, (ISymbol)new RangeSymbol((char)(condition.label + 1), '\uffff'));
            this.putAnd(v, Arrays.asList(cs1, cs2));
        }

        @Override
        public void onTrue(TrueCondition condition) {
        }

        @Override
        public void onVar(VarCondition condition) {
            SSAInstruction instruction;
            DefUse du = this.ctx.getDefUse();
            int valueNumber = condition.var;
            boolean positive = true;
            if (valueNumber < 0) {
                valueNumber = -valueNumber;
                positive = false;
            }
            if ((instruction = du.getDef(valueNumber)) instanceof SSAAbstractInvokeInstruction) {
                SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)instruction;
                this.onVarForInvokeInstruction(invoke, condition, positive);
            } else if (!(instruction instanceof SSAComparisonInstruction) && SAUtil.DEBUG) {
                SAUtil.println((Object)("unsupported instruction: " + instruction));
            }
        }

        private void onVarForInvokeInstruction(SSAAbstractInvokeInstruction invoke, IPrimitiveCondition condition, boolean positive) {
            Set<String> signatures = this.symFactory.getRepository().getSignature(invoke, this.ctx);
            assert (signatures.size() == 1);
            String signature = signatures.iterator().next();
            String constraintSignature = (positive ? "&" : "!") + signature;
            IConstraint<T> tr = this.symFactory.getRepository().getConstraint(constraintSignature);
            if (tr == null) {
                if (SAUtil.DEBUG) {
                    SAUtil.println((Object)("unknown constraint: " + signature));
                }
            } else {
                Collection<IVariable> vars = this.extractConstraintTarget(invoke, tr);
                for (IVariable v : vars) {
                    Collection<InvocationSymbol> invokeSyms = this.symFactory.createInvocationSymbol(invoke, this.ctx);
                    assert (invokeSyms.size() == 1);
                    InvocationSymbol invokeSym = invokeSyms.iterator().next();
                    invokeSym = new ConditionedInvocationSymbol(invokeSym.getCallGraph(), invokeSym.getCGNode(), invokeSym.getInstruction(), new SignatureSymbol(constraintSignature), invokeSym.getReceiver(), invokeSym.getParameters(), condition);
                    ConstraintSymbol cs = new ConstraintSymbol((ISymbol)v, invokeSym);
                    this.putAnd(v, cs);
                }
            }
        }

        private Collection<IVariable> extractConstraintTarget(SSAAbstractInvokeInstruction invoke, IConstraint<T> tr) {
            Collection<IVariable> vars = tr.getConstraintTarget(invoke, this.symFactory, this.bb, this.ctx);
            if (vars == null) {
                return Collections.emptySet();
            }
            return vars;
        }
    }

    public static class DefaultVariableReplacer
    implements IVariableReplacer {
        @Override
        public IVariable replaceVariable(IVariable orig, ConstraintSymbol cs, ISSABasicBlock bb, ISSABasicBlock pred, TranslationContext ctx, IVariableFactory<IVariable> varFactory) {
            if (orig instanceof CDVariable) {
                CDVariable v = (CDVariable)orig;
                return new BBVariable(v.getValueNumber(), v.getCGNode(), bb, pred);
            }
            return varFactory.createVariable(Grammars.variablePrefix);
        }
    }

    public static interface IVariableReplacer {
        public IVariable replaceVariable(IVariable var1, ConstraintSymbol var2, ISSABasicBlock var3, ISSABasicBlock var4, TranslationContext var5, IVariableFactory<IVariable> var6);
    }
}

