/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator;

import com.ibm.wala.automaton.DMap;
import com.ibm.wala.automaton.grammar.string.DeepGrammarCopier;
import com.ibm.wala.automaton.grammar.string.DeepRuleCopier;
import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammarCopier;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.IRuleCopier;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.grammar.string.SimpleGrammarCopier;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.DeepSymbolCopier;
import com.ibm.wala.automaton.string.FreshStateFactory;
import com.ibm.wala.automaton.string.FreshVariableFactory;
import com.ibm.wala.automaton.string.IEnumerableSymbol;
import com.ibm.wala.automaton.string.IFormalLanguage;
import com.ibm.wala.automaton.string.ILanguageSymbol;
import com.ibm.wala.automaton.string.IStateFactory;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.ISymbolVisitor;
import com.ibm.wala.automaton.string.IValueSymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.automaton.string.SimpleSubstitution;
import com.ibm.wala.automaton.string.VariableCollector;
import com.ibm.wala.automaton.string.VariableReplacer;
import com.ibm.wala.stringAnalysis.grammar.ConstraintSymbol;
import com.ibm.wala.stringAnalysis.grammar.InvocationSymbol;
import com.ibm.wala.stringAnalysis.grammar.SignatureSymbol;
import com.ibm.wala.stringAnalysis.translator.IConstraintSolver;
import com.ibm.wala.stringAnalysis.translator.IRegexParser;
import com.ibm.wala.stringAnalysis.translator.ISolverCache;
import com.ibm.wala.stringAnalysis.translator.ISolverStack;
import com.ibm.wala.stringAnalysis.translator.ITranslator;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.stringAnalysis.translator.TranslationException;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.util.CancelRuntimeException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SimpleConstraintSolver<T extends IFormalLanguage>
implements IConstraintSolver<T> {
    private static boolean ENABLE_SOLVER_CACHE = true;
    protected int MAX_CYCLE = Integer.getInteger("com.ibm.wala.stringAnalysis.maxCycle", 4);
    protected int WIDENING_THRESHOLD = Integer.getInteger("com.ibm.wala.stringAnalysis.wideningThreshold", 2);
    protected int CHARSET_APPROXIMATION_THRESHOLD = Integer.getInteger("com.ibm.wala.stringAnalysis.charsetApproximationThreshold", 0);
    protected final ITranslatorRepository<T> translators;
    protected final ISolverCache<T> cache;
    protected final ISolverStack stack;
    protected final IVariableFactory<IVariable> varFactory;
    protected final IStateFactory stateFactory;
    protected final MonitorUtil.IProgressMonitor monitor;
    private static RangeSymbol anyChar = new RangeSymbol('\u0000', '\uffff');

    public static <T extends IGrammar> T substituteGrammars(T g, IVariableFactory<IVariable> varFactory) {
        return (T)new SimpleSubstitutionForSolver(varFactory).substitute(g);
    }

    public SimpleConstraintSolver(ITranslatorRepository<T> translators, ISolverCache<T> cache, ISolverStack stack, MonitorUtil.IProgressMonitor monitor) {
        this.translators = translators;
        this.cache = cache;
        this.stack = stack;
        this.varFactory = cache.getVariableFactory();
        this.stateFactory = new FreshStateFactory();
        this.monitor = monitor == null ? SAUtil.nullProgressMonitor : monitor;
    }

    protected <U extends IGrammar> U substituteGrammars(U g) {
        return SimpleConstraintSolver.substituteGrammars(g, this.varFactory);
    }

    public void fixDanglingRules(SimpleGrammar cfg, Collection<? extends IVariable> vars) {
        final Collection dvars = Grammars.collectUsedVariables((IGrammar)cfg, vars);
        cfg.traverseSymbols(new ISymbolVisitor(){

            public void onLeave(ISymbol symbol) {
            }

            public void onVisit(ISymbol symbol) {
                InvocationSymbol invokeSym;
                ISymbol recv;
                if (symbol instanceof InvocationSymbol && (recv = (invokeSym = (InvocationSymbol)symbol).getReceiver()) instanceof IVariable) {
                    dvars.add((IVariable)recv);
                }
            }
        });
        dvars.addAll(vars);
        dvars.removeAll(Grammars.collectLeftVariables((IGrammar)cfg));
        this.addAnyRule(cfg, dvars);
    }

    protected void addAnyRule(SimpleGrammar cfg, Collection<IVariable> dvars) {
        IVariable v = this.varFactory.createVariable("ANY");
        cfg.addRule((IProductionRule)new ProductionRule(v, new ISymbol[]{new RangeSymbol('\u0000', '\uffff'), v}));
        cfg.addRule((IProductionRule)new ProductionRule(v, new ISymbol[0]));
        for (IVariable dvar : dvars) {
            ProductionRule rule = new ProductionRule(dvar, (ISymbol)v);
            cfg.addRule((IProductionRule)rule);
            if (!SAUtil.DEBUG) continue;
            SAUtil.println((Object)("added the rule: " + rule));
        }
    }

    private Set<IProductionRule> cyclicRules(SimpleGrammar g, IVariable v) {
        Set<IProductionRule> rules = this.cyclicRules(g, v, v, new HashMap<IVariable, Set<IProductionRule>>());
        return rules;
    }

    private Set<IProductionRule> cyclicRules(final SimpleGrammar g, final IVariable v, final IVariable cur, final Map<IVariable, Set<IProductionRule>> h) {
        Set<IProductionRule> rules = h.get(cur);
        if (rules != null) {
            return rules;
        }
        rules = new HashSet<IProductionRule>();
        h.put(cur, rules);
        for (final IProductionRule r : g.getRules(cur)) {
            for (ISymbol s : r.getRight()) {
                s.traverse(new ISymbolVisitor(){

                    public void onLeave(ISymbol symbol) {
                    }

                    public void onVisit(ISymbol symbol) {
                        if (symbol instanceof IVariable) {
                            IVariable v2 = (IVariable)symbol;
                            if (v.equals(v2)) {
                                ((Set)h.get(cur)).add(r);
                            } else {
                                Set rs = SimpleConstraintSolver.this.cyclicRules(g, v, v2, h);
                                if (!rs.isEmpty()) {
                                    ((Set)h.get(cur)).add(r);
                                    ((Set)h.get(cur)).addAll(rs);
                                }
                            }
                        }
                    }
                });
            }
        }
        return rules;
    }

    private Collection<IVariable> collectNonConnectedVariables(SimpleGrammar g) {
        HashSet<IVariable> vars = new HashSet<IVariable>(g.getLeftVariables());
        Collection<IVariable> cvars = this.collectConnectedVariables(g);
        vars.removeAll(cvars);
        return vars;
    }

    private Collection<IVariable> collectConnectedVariables(SimpleGrammar g) {
        HashSet<IVariable> vars = new HashSet<IVariable>();
        DMap<IVariable, Set<IVariable>> revMap = new DMap<IVariable, Set<IVariable>>(){

            protected Set<IVariable> create(IVariable key) {
                return new HashSet<IVariable>();
            }
        };
        VariableCollector collector = new VariableCollector();
        for (IProductionRule r : g.getRules()) {
            IVariable lv = r.getLeft();
            for (ISymbol s : r.getRight()) {
                s.traverse((ISymbolVisitor)collector);
                for (IVariable v : collector.getSymbols()) {
                    ((Set)revMap.get(v)).add(lv);
                }
                collector.clear();
            }
        }
        IVariable start = g.getStartSymbol();
        this.collectConnectedVariables((Map<IVariable, Set<IVariable>>)revMap, start, vars);
        return vars;
    }

    private void collectConnectedVariables(Map<IVariable, Set<IVariable>> revMap, IVariable v, Collection<IVariable> s) {
        if (s.contains(v)) {
            return;
        }
        s.add(v);
        for (IVariable nv : revMap.get(v)) {
            this.collectConnectedVariables(revMap, nv, s);
        }
    }

    private SimpleGrammar[] splitCyclicRules(IVariable v, SimpleGrammar g) {
        Set<IProductionRule> cyclicRules = this.cyclicRules(g, v);
        SimpleGrammar g1 = new SimpleGrammar(v, (Collection)g.getRules());
        g1.getRules().removeAll(cyclicRules);
        Grammars.eliminateUselessRules((IGrammar)g1);
        Set exCyclic = g1.getRules(v);
        SimpleGrammar g2 = new SimpleGrammar(v, (Collection)g.getRules());
        g2.getRules().removeAll(exCyclic);
        Grammars.eliminateUselessRules((IGrammar)g2);
        return new SimpleGrammar[]{g1, g2};
    }

    private SimpleGrammar normalizeConstraintSymbols(SimpleGrammar g) {
        final HashMap m = new HashMap();
        g.traverseSymbols(new ISymbolVisitor(){
            int inConstraint = 0;

            public void onLeave(ISymbol symbol) {
                if (symbol instanceof ConstraintSymbol) {
                    --this.inConstraint;
                }
            }

            public void onVisit(ISymbol symbol) {
                if (symbol instanceof ConstraintSymbol) {
                    if (this.inConstraint == 0 && !m.containsKey(symbol)) {
                        IVariable v = (IVariable)SimpleConstraintSolver.this.varFactory.createSymbol(Grammars.variablePrefix);
                        m.put((ConstraintSymbol)symbol, v);
                    }
                    ++this.inConstraint;
                }
            }
        });
        SimpleGrammar g2 = (SimpleGrammar)g.copy((IGrammarCopier)new DeepGrammarCopier((IRuleCopier)new DeepRuleCopier((ISymbolCopier)new DeepSymbolCopier(){

            public ISymbol copy(ISymbol symbol) {
                if (m.containsKey(symbol)) {
                    return (ISymbol)m.get(symbol);
                }
                return super.copy(symbol);
            }
        })));
        for (Map.Entry entry : m.entrySet()) {
            ConstraintSymbol cs = (ConstraintSymbol)entry.getKey();
            IVariable v = (IVariable)entry.getValue();
            ProductionRule rule = new ProductionRule(v, (ISymbol)cs);
            g2.addRule((IProductionRule)rule);
        }
        g = g2;
        m.clear();
        return g;
    }

    private Collection<ISymbol> collectConstraints(ConstraintSymbol cs) {
        ISymbol base = cs.getBase();
        ISymbol constraint = cs.getConstraint();
        HashSet<ISymbol> r = new HashSet<ISymbol>();
        if (base instanceof ConstraintSymbol) {
            r.addAll(this.collectConstraints((ConstraintSymbol)base));
        }
        if (constraint instanceof CharSymbol) {
            r.add(constraint);
        } else if (constraint instanceof RangeSymbol) {
            r.add(constraint);
        } else if (constraint instanceof InvocationSymbol) {
            r.add(constraint);
        } else if (constraint instanceof ConstraintSymbol) {
            r.addAll(this.collectConstraints((ConstraintSymbol)constraint));
        } else {
            Assertions.UNREACHABLE((String)("unknown constraint: " + cs));
        }
        return r;
    }

    private Pair<RangeSymbol, Collection<InvocationSymbol>> optimizeConstraints(Collection<ISymbol> constraints) {
        HashSet<RangeSymbol> ranges = new HashSet<RangeSymbol>();
        HashSet<InvocationSymbol> invokes = new HashSet<InvocationSymbol>();
        for (ISymbol c : constraints) {
            if (c instanceof CharSymbol) {
                ranges.add(new RangeSymbol((IEnumerableSymbol)((CharSymbol)c), (IEnumerableSymbol)((CharSymbol)c)));
                continue;
            }
            if (c instanceof RangeSymbol) {
                ranges.add((RangeSymbol)c);
                continue;
            }
            if (c instanceof InvocationSymbol) {
                invokes.add((InvocationSymbol)c);
                continue;
            }
            Assertions.UNREACHABLE((String)("unknown constraint: " + c));
        }
        boolean isChar = false;
        RangeSymbol range = new RangeSymbol('\u0000', '\uffff');
        for (RangeSymbol r : ranges) {
            range = RangeSymbol.intersection((RangeSymbol)range, (RangeSymbol)r);
            isChar = true;
            if (range != null) continue;
            return null;
        }
        if (range == null) {
            return null;
        }
        if (isChar) {
            return Pair.make((Object)range, invokes);
        }
        return Pair.make(null, invokes);
    }

    private ConstraintSymbol optimizeConstraintSymbol(ConstraintSymbol cs) {
        Collection<ISymbol> constraints = this.collectConstraints(cs);
        Pair<RangeSymbol, Collection<InvocationSymbol>> optimized = this.optimizeConstraints(constraints);
        if (optimized == null) {
            return null;
        }
        ISymbol base = cs.getBase();
        while (base instanceof ConstraintSymbol) {
            base = ((ConstraintSymbol)base).getBase();
        }
        ConstraintSymbol c = null;
        for (InvocationSymbol invoke : (Collection)optimized.snd) {
            if (c == null) {
                c = new ConstraintSymbol(base, invoke);
                continue;
            }
            c = new ConstraintSymbol(c, invoke);
        }
        RangeSymbol range = (RangeSymbol)optimized.fst;
        if (range != null) {
            c = c == null ? new ConstraintSymbol(base, (ISymbol)range) : new ConstraintSymbol(c, (ISymbol)range);
        }
        return c;
    }

    private Collection<IProductionRule> createConstraintRules(IVariable v, ConstraintSymbol cs) {
        HashSet<IProductionRule> rules = new HashSet<IProductionRule>();
        if (cs == null) {
            rules.add((IProductionRule)new ProductionRule(v, new ISymbol[0]));
            return rules;
        }
        ISymbol base = cs.getBase();
        ISymbol constraint = cs.getConstraint();
        if (base instanceof ConstraintSymbol) {
            IVariable v2 = this.varFactory.createVariable(Grammars.variablePrefix);
            rules.addAll(this.createConstraintRules(v2, (ConstraintSymbol)base));
            if (constraint instanceof InvocationSymbol) {
                IVariable v3 = this.varFactory.createVariable(Grammars.variablePrefix);
                ProductionRule rule1 = new ProductionRule(v, (ISymbol)this.createIntersection((ISymbol)v2, (ISymbol)v3));
                ProductionRule rule2 = new ProductionRule(v3, constraint);
                rules.add((IProductionRule)rule1);
                rules.add((IProductionRule)rule2);
            } else {
                assert (constraint instanceof CharSymbol || constraint instanceof RangeSymbol);
                ProductionRule rule = new ProductionRule(v, (ISymbol)this.createIntersection((ISymbol)v2, constraint));
                rules.add((IProductionRule)rule);
            }
        } else if (constraint instanceof InvocationSymbol) {
            IVariable v2 = this.varFactory.createVariable(Grammars.variablePrefix);
            ProductionRule rule1 = new ProductionRule(v, (ISymbol)this.createIntersection(base, (ISymbol)v2));
            ProductionRule rule2 = new ProductionRule(v2, constraint);
            rules.add((IProductionRule)rule1);
            rules.add((IProductionRule)rule2);
        } else {
            assert (constraint instanceof CharSymbol || constraint instanceof RangeSymbol);
            ProductionRule rule = new ProductionRule(v, (ISymbol)this.createIntersection(base, constraint));
            rules.add((IProductionRule)rule);
        }
        return rules;
    }

    private InvocationSymbol createIntersection(ISymbol s1, ISymbol s2) {
        return new InvocationSymbol(new SignatureSymbol("&"), s1, new ISymbol[]{s2});
    }

    protected SimpleGrammar translateIntersections(SimpleGrammar g) {
        SimpleGrammar g1 = (SimpleGrammar)g.copy((IGrammarCopier)SimpleGrammarCopier.defaultCopier);
        for (IProductionRule rule : g.getRules()) {
            ISymbol s;
            if (!g1.getRules().contains(rule)) continue;
            if (this.monitor.isCanceled()) {
                throw CancelRuntimeException.make((String)"translating intersection");
            }
            List rhs = rule.getRight();
            if (rhs.size() != 1 || !((s = (ISymbol)rhs.get(0)) instanceof ConstraintSymbol)) continue;
            ConstraintSymbol cs = (ConstraintSymbol)s;
            g1.getRules().remove(rule);
            cs = this.optimizeConstraintSymbol(cs);
            Collection<IProductionRule> rules = this.createConstraintRules(rule.getLeft(), cs);
            g1.getRules().addAll(rules);
            Grammars.eliminateUselessRules((IGrammar)g1);
        }
        return g1;
    }

    private SimpleGrammar extractTargetGrammar(SimpleGrammar g, IProductionRule invokeRule, Collection<IProductionRule> remainingRules) {
        SimpleGrammar[] splits = this.splitGrammar(g, invokeRule);
        SimpleGrammar targetGrammar = splits[0];
        remainingRules.addAll(splits[1].getRules());
        return targetGrammar;
    }

    private SimpleGrammar[] splitGrammar(SimpleGrammar cfg, IProductionRule invokeRule) {
        IVariable start = invokeRule.getLeft();
        InvocationSymbol invoke = (InvocationSymbol)invokeRule.getRight(0);
        HashSet rules = new HashSet();
        HashSet vs = new HashSet();
        invoke.traverse((ISymbolVisitor)new VariableCollector(vs));
        Grammars.collectReachableRules((IGrammar)cfg, vs, rules);
        SimpleGrammar g1 = new SimpleGrammar(start, rules);
        SimpleGrammar g2 = cfg.dup();
        g1.addRule(invokeRule);
        g2.getRules().remove(invokeRule);
        for (IProductionRule r : cfg.getRules(start)) {
            if (!g1.getRules().contains(r)) continue;
            g2.getRules().remove(r);
        }
        Grammars.eliminateUselessRules((IGrammar)g2);
        return new SimpleGrammar[]{g1, g2};
    }

    private SimpleGrammar extractRewritingTarget(SimpleGrammar g, IProductionRule r) {
        HashSet vs = new HashSet();
        HashSet<IProductionRule> rules = new HashSet<IProductionRule>();
        r.traverseSymbols((ISymbolVisitor)new VariableCollector(vs));
        Grammars.collectReachableRules((IGrammar)g, vs, rules);
        rules.add(r);
        SimpleGrammar g1 = new SimpleGrammar(r.getLeft(), rules);
        return g1;
    }

    protected SimpleGrammar solveByRewriting(SimpleGrammar g) {
        int n = 0;
        int N = 200;
        Set rules = g.getRules();
        boolean modified = true;
        while (modified) {
            modified = false;
            for (IProductionRule r : new ArrayList(g.getRules())) {
                InvocationSymbol f;
                String signature;
                ITranslator<T> translator;
                ISymbol s0;
                if (n == N && this.monitor.isCanceled()) {
                    throw CancelRuntimeException.make((String)"rewriting the grammar");
                }
                int n2 = n = n == N ? 0 : n + 1;
                List l = r.getRight();
                if (l.isEmpty() || !((s0 = (ISymbol)l.get(0)) instanceof InvocationSymbol) || (translator = this.findAndInitTranslator(signature = this.findSignature(f = (InvocationSymbol)s0))).getTarget() != -2) continue;
                if (SAUtil.DEBUG) {
                    SAUtil.println((Object)("-- rewriting by " + signature));
                }
                SimpleGrammar tg = this.extractRewritingTarget(g, r);
                IVariable origStart = tg.getStartSymbol();
                if (!origStart.equals((tg = this.rewrite(signature, f, translator, r, tg)).getStartSymbol())) {
                    tg.addRule((IProductionRule)new ProductionRule(origStart, (ISymbol)tg.getStartSymbol()));
                }
                modified = true;
                rules.remove(r);
                rules.addAll(tg.getRules());
            }
        }
        return g;
    }

    protected SimpleGrammar rewrite(String signature, InvocationSymbol f, ITranslator<T> translator, IProductionRule r, SimpleGrammar tg) {
        tg = translator.prepare(this, signature, f.getReceiver(), f.getParameters(), r, tg);
        return tg;
    }

    protected abstract T minimize(T var1);

    protected abstract T substitute(T var1);

    protected abstract T concatResults(List<T> var1);

    protected abstract T composeResults(Collection<T> var1);

    protected abstract T composeResult(SimpleGrammar var1);

    protected abstract T composeResult(IValueSymbol var1);

    protected abstract T composeResult(ILanguageSymbol<?> var1);

    protected abstract SimpleGrammar composeGrammar(T var1);

    protected abstract boolean contains(T var1, T var2);

    protected abstract T approximate(T var1, int var2);

    protected T solveCyclic(IVariable v, T nonCyclic, SimpleGrammar cyclic, int cycle) {
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)"noncyclic --");
            SAUtil.println(nonCyclic);
            SAUtil.println((Object)"cyclic --");
            SAUtil.println((Object)cyclic);
        }
        IVariable v2 = this.varFactory.createVariable(Grammars.variablePrefix);
        HashMap<IVariable, IVariable> cm = new HashMap<IVariable, IVariable>();
        cm.put(v, v2);
        cyclic = (SimpleGrammar)cyclic.copy((IGrammarCopier)new DeepGrammarCopier((IRuleCopier)new DeepRuleCopier((ISymbolCopier)new VariableReplacer(cm)){

            public IVariable copyLeft(IVariable v) {
                return v;
            }
        }){

            public IVariable copyStartSymbol(IVariable v) {
                return v;
            }
        });
        Object input = nonCyclic;
        for (int i = 0; i < this.MAX_CYCLE; ++i) {
            if (this.monitor.isCanceled()) {
                return this.createAny();
            }
            T abase = this.approximate(input, i);
            SimpleGrammar g = new SimpleGrammar((IGrammar)cyclic);
            SimpleGrammar gsub = this.composeGrammar(abase);
            gsub = (SimpleGrammar)Grammars.useUniqueVariables((IGrammar)gsub, (IGrammar)g, new HashMap());
            g.addRule((IProductionRule)new ProductionRule(v2, (ISymbol)gsub.getStartSymbol()));
            g.getRules().addAll(gsub.getRules());
            if (SAUtil.DEBUG) {
                SAUtil.println((Object)"base --");
                SAUtil.println(abase);
                SAUtil.println((Object)"cyclic --");
                SAUtil.println((Object)g);
            }
            T res = this.solveInvocationSymbol(v, g, cycle + 1);
            if (SAUtil.DEBUG) {
                SAUtil.println((Object)"base --");
                SAUtil.println(abase);
                SAUtil.println((Object)"res --");
                SAUtil.println(res);
            }
            if (this.contains(abase, res)) {
                return abase;
            }
            LinkedList<T> c = new LinkedList<T>();
            c.add(abase);
            c.add(res);
            input = this.composeResults(c);
        }
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)"reaches the cycle limit.");
        }
        return this.createAny();
    }

    private T solveInvocationSymbol(IVariable v, SimpleGrammar g, int cycle) {
        g = g.dup(v);
        Grammars.eliminateUselessRules((IGrammar)g);
        g = this.solveAnyString(g);
        if (!this.hasInvocationSymbol(g)) {
            return this.minimize(this.substitute(this.composeResult(g)));
        }
        SimpleGrammar[] sub = this.splitCyclicRules(v, g);
        SimpleGrammar nonCyclic = sub[0];
        SimpleGrammar cyclicGrammar = sub[1];
        if (nonCyclic.getRules().isEmpty()) {
            SAUtil.println((Object)"PANIC! There is no non-cyclic rule.");
            return this.createAny();
        }
        if (!cyclicGrammar.getRules().isEmpty()) {
            return this.solveCyclicGrammar(v, g, nonCyclic, cyclicGrammar, cycle);
        }
        HashSet r = new HashSet();
        for (IProductionRule rule : g.getRules(v)) {
            if (this.monitor.isCanceled()) {
                return this.createAny();
            }
            List right = rule.getRight();
            ArrayList<Object> l = new ArrayList<Object>();
            for (ISymbol s : right) {
                if (s instanceof IVariable) {
                    IVariable sv = (IVariable)s;
                    T h = this.solveInvocationSymbol(sv, g, cycle);
                    l.add(h);
                    continue;
                }
                if (s instanceof InvocationSymbol) {
                    IProductionRule invokeRule = rule;
                    InvocationSymbol invoke = (InvocationSymbol)s;
                    HashSet<IProductionRule> rules = new HashSet<IProductionRule>();
                    this.stack.push(invokeRule);
                    SimpleGrammar target = this.extractTargetGrammar(g, invokeRule, rules);
                    IFormalLanguage result = null;
                    if (ENABLE_SOLVER_CACHE && this.cache.contains(invokeRule)) {
                        result = (IFormalLanguage)this.cache.get(invokeRule);
                        if (SAUtil.DEBUG) {
                            SAUtil.println((Object)"cached result --");
                            SAUtil.println((Object)result);
                        }
                    } else {
                        result = (IFormalLanguage)this.solveInvocation(target, invokeRule, invoke, cycle);
                        if (ENABLE_SOLVER_CACHE && cycle == 0) {
                            this.cache.put(invokeRule, result);
                        }
                    }
                    this.stack.pop();
                    l.add(result);
                    continue;
                }
                if (s instanceof IValueSymbol) {
                    IValueSymbol val = (IValueSymbol)s;
                    l.add(this.composeResult(val));
                    continue;
                }
                if (s instanceof ILanguageSymbol) {
                    ILanguageSymbol lsym = (ILanguageSymbol)s;
                    l.add(this.composeResult(lsym));
                    continue;
                }
                SAUtil.println((Object)("PANIC! unknown type: " + s.getClass()));
                l.add(this.createAny());
            }
            Object conc = this.concatResults(l);
            if (SAUtil.DEBUG) {
                SAUtil.println((Object)("concat results for " + rule));
                SAUtil.println(l);
                SAUtil.println((Object)("concatenated result for " + rule));
                SAUtil.println(conc);
            }
            r.add(conc);
        }
        Object res = this.composeResults(r);
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)("compose results for " + g.getStartSymbol()));
            SAUtil.println(r);
            SAUtil.println((Object)("composed result for " + g.getStartSymbol()));
            SAUtil.println(res);
        }
        res = this.substitute(res);
        res = this.minimize(res);
        return (T)res;
    }

    protected T solveCyclicGrammar(IVariable v, SimpleGrammar g, SimpleGrammar nonCyclic, SimpleGrammar cyclicGrammar, int cycle) {
        if (this.monitor.isCanceled()) {
            throw CancelRuntimeException.make((String)"solving cyclic grammar");
        }
        Collection<IVariable> cvs = this.collectNonConnectedVariables(g);
        if (!cvs.isEmpty()) {
            HashMap<IVariable, SimpleGrammar> m = new HashMap<IVariable, SimpleGrammar>();
            HashSet rm = new HashSet();
            FreshVariableFactory vf = new FreshVariableFactory((IGrammar)g);
            for (IVariable iVariable : cvs) {
                T ct = this.solveInvocationSymbol(iVariable, g, cycle);
                SimpleGrammar gsub = this.composeGrammar(ct);
                gsub = (SimpleGrammar)Grammars.useUniqueVariables((IGrammar)gsub, (IVariableFactory)vf, new HashMap());
                m.put(iVariable, gsub);
                rm.addAll(g.getRules(iVariable));
            }
            g.getRules().removeAll(rm);
            for (Map.Entry entry : m.entrySet()) {
                SimpleGrammar gsub = (SimpleGrammar)entry.getValue();
                ProductionRule r = new ProductionRule((IVariable)entry.getKey(), (ISymbol)gsub.getStartSymbol());
                g.addRule((IProductionRule)r);
                g.getRules().addAll(gsub.getRules());
            }
            if (!this.hasInvocationSymbol(g)) {
                T r = this.composeResult(g);
                r = this.substitute(r);
                r = this.minimize(r);
                return r;
            }
        }
        T t = this.solveInvocationSymbol(v, nonCyclic, cycle);
        return this.minimize(this.substitute(this.solveCyclic(v, t, cyclicGrammar, cycle)));
    }

    private boolean hasInvocationSymbol(SimpleGrammar g) {
        return this.hasInvocationSymbol(g.getStartSymbol(), g, new HashSet<IVariable>());
    }

    private boolean hasInvocationSymbol(IVariable v, SimpleGrammar g, Set<IVariable> h) {
        if (h.contains(v)) {
            return false;
        }
        h.add(v);
        for (IProductionRule r : g.getRules(v)) {
            for (ISymbol s : r.getRight()) {
                if (s instanceof InvocationSymbol) {
                    return true;
                }
                if (!(s instanceof IVariable) || !this.hasInvocationSymbol((IVariable)s, g, h)) continue;
                return true;
            }
        }
        return false;
    }

    private T solveInvocationSymbol(SimpleGrammar g, int cycle) {
        Grammars.eliminateReflectiveRules((IGrammar)g);
        T r = this.solveInvocationSymbol(g.getStartSymbol(), g, cycle);
        return r;
    }

    private SimpleGrammar normalizeInvocationRule(SimpleGrammar g) {
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)"-- before normalization:");
            SAUtil.println((Object)g);
        }
        SimpleGrammar ng = g.dup();
        DMap<IVariable, Collection<IProductionRule>> cyclicRules = new DMap<IVariable, Collection<IProductionRule>>(){

            protected Collection<IProductionRule> create(IVariable key) {
                return new HashSet<IProductionRule>();
            }
        };
        for (IProductionRule rule : g.getRules()) {
            ISymbol s;
            List right = rule.getRight();
            if (right.isEmpty() || !((s = (ISymbol)right.get(0)) instanceof InvocationSymbol)) continue;
            InvocationSymbol f = (InvocationSymbol)s;
            if (!rule.getLeft().equals(f.getReceiver()) && !f.getParameters().contains(rule.getLeft())) continue;
            ((Collection)cyclicRules.get(rule.getLeft())).add(rule);
        }
        for (IVariable k : cyclicRules.keySet()) {
            Collection cRules = (Collection)cyclicRules.get(k);
            if (cRules.size() <= 1) continue;
            HashSet<IProductionRule> bRules = new HashSet<IProductionRule>(g.getRules(k));
            bRules.removeAll(cRules);
            ng.getRules().removeAll(cRules);
            this.convertCyclicRules1(ng, k, cRules, bRules);
        }
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)"-- after normalizing invocation rules:");
            SAUtil.println((Object)ng);
        }
        return ng;
    }

    private void convertCyclicRules1(SimpleGrammar ng, IVariable k, Collection<IProductionRule> cRules, Collection<IProductionRule> bRules) {
        IVariable v = this.varFactory.createVariable(Grammars.variablePrefix);
        HashMap<IVariable, IVariable> m = new HashMap<IVariable, IVariable>();
        m.put(k, v);
        for (IProductionRule r : cRules) {
            IProductionRule rr = r.copy((IRuleCopier)new DeepRuleCopier((ISymbolCopier)new VariableReplacer(m)){

                public IVariable copyLeft(IVariable v) {
                    return v;
                }
            });
            ng.addRule(rr);
        }
        ng.addRule((IProductionRule)new ProductionRule(v, (ISymbol)k));
        for (IProductionRule r : bRules) {
            ng.addRule((IProductionRule)new ProductionRule(v, r.getRight()));
        }
    }

    private String findSignature(InvocationSymbol invoke) {
        return invoke.getFunction().getName();
    }

    private ITranslator<T> findAndInitTranslator(String signature) {
        if (SAUtil.DEBUG && !this.translators.hasSignature(signature)) {
            SAUtil.println((Object)("unknown translator for: " + signature));
        }
        ITranslator<T> translator = this.translators.getTranslator(signature);
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)("-- found the translator " + signature));
        }
        translator.init(this.varFactory, this.stateFactory, this.monitor);
        return translator;
    }

    protected T solveInvocation(SimpleGrammar targetGrammar, IProductionRule invokeRule, InvocationSymbol invoke, int cycle) {
        String signature = this.findSignature(invoke);
        ITranslator<T> translator = this.findAndInitTranslator(signature);
        T g3 = this.translateGrammar(translator, signature, invoke.getReceiver(), invoke.getParameters(), invokeRule, targetGrammar, cycle);
        return g3;
    }

    protected void init() {
        this.stack.clear();
    }

    @Override
    public Map<IVariable, T> solve(SimpleGrammar g, Collection<? extends IVariable> startSymbols) {
        this.init();
        g = g.dup();
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)"-- before eliminating useless rules:");
            SAUtil.println((Object)g);
        }
        Grammars.eliminateUselessRules((IGrammar)g, startSymbols);
        this.fixDanglingRules(g, startSymbols);
        Map<IVariable, T> result = this.solveInternal(g, startSymbols);
        return result;
    }

    protected Map<IVariable, T> solveInternal(SimpleGrammar g, Collection<? extends IVariable> startSymbols) {
        HashMap result = new HashMap();
        for (IVariable iVariable : startSymbols) {
            this.solveInternal(g, iVariable, result);
        }
        return result;
    }

    protected void solveInternal(SimpleGrammar g, IVariable startSymbol, Map<IVariable, T> result) {
        g = g.dup();
        g.setStartSymbol(startSymbol);
        Grammars.eliminateUselessRules((IGrammar)g);
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)("-- analyzing for " + startSymbol));
            SAUtil.println((Object)"-- ater eliminating useless rules:");
            SAUtil.println((Object)Grammars.toRuleChain((IGrammar)g));
        }
        Grammars.eliminateReflectiveRules((IGrammar)g);
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)"-- after eliminating reflective rules:");
            SAUtil.println((Object)Grammars.toRuleChain((IGrammar)g));
        }
        g = this.normalizeConstraintSymbols(g);
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)"-- after normalizing constraint symbols:");
            SAUtil.println((Object)Grammars.toRuleChain((IGrammar)g));
        }
        T r = this.solve(g);
        assert (r != null);
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)("-- done (analyzing for " + startSymbol + ")"));
        }
        result.put(startSymbol, r);
    }

    @Override
    public T solve(SimpleGrammar g, IVariable start) {
        g = g.dup();
        g.setStartSymbol(start);
        return this.solve(g);
    }

    @Override
    public T solve(SimpleGrammar g) {
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)"-- solving: g =");
            SAUtil.println((Object)g);
        }
        g = this.substituteGrammars(g);
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)"-- substitute grammars: g =");
            SAUtil.println((Object)g);
        }
        g = (SimpleGrammar)g.copy((IGrammarCopier)SimpleGrammarCopier.defaultCopier);
        Grammars.eliminateUselessRules((IGrammar)g);
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)"-- eliminate useless rules: g =");
            SAUtil.println((Object)g);
        }
        if (g.getRules().isEmpty()) {
            return this.createEmpty();
        }
        g = this.translateIntersections(g);
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)"-- translate intersections: g =");
            SAUtil.println((Object)g);
        }
        g = this.normalizeInvocationRule(g);
        g = this.solveByRewriting(g);
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)"-- after rewriting: g =");
            SAUtil.println((Object)g);
        }
        T r = this.solveInvocationSymbol(g, 0);
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)"-- solution --");
            SAUtil.println(r);
        }
        return r;
    }

    protected abstract T createEmpty();

    protected abstract T createAny();

    private SimpleGrammar solveAnyString(SimpleGrammar g) {
        SimpleGrammar g2 = new SimpleGrammar();
        g2.setStartSymbol(g.getStartSymbol());
        for (IVariable v : g.getNonterminals()) {
            Set rules = g.getRules(v);
            IProductionRule rec = null;
            IProductionRule emp = null;
            for (IProductionRule rule : rules) {
                List l = rule.getRight();
                if (l.size() == 0) {
                    emp = rule;
                    if (rec != null) break;
                }
                if (l.size() != 2) continue;
                ISymbol sym0 = (ISymbol)l.get(0);
                ISymbol sym1 = (ISymbol)l.get(1);
                if (sym1 instanceof RangeSymbol) {
                    sym0 = sym1;
                    sym1 = (ISymbol)l.get(0);
                }
                if (!sym0.equals(anyChar) || !sym1.equals(v)) continue;
                rec = rule;
                if (emp == null) continue;
                break;
            }
            if (rec != null && emp != null) {
                g2.addRule(rec);
                g2.addRule(emp);
                continue;
            }
            g2.addRules((Collection)rules);
        }
        return g2;
    }

    protected T translateGrammar(ITranslator<T> translator, String funcName, ISymbol recv, List<ISymbol> params, IProductionRule invokeRule, SimpleGrammar targetGrammar, int cycle) {
        SimpleGrammar pre = translator.prepare(this, funcName, recv, params, invokeRule, targetGrammar);
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)("-- prepared grammar for " + funcName + ":"));
            SAUtil.println((Object)(pre == null ? "null" : pre));
        }
        T target = pre == null ? this.createEmpty() : this.solveInvocationSymbol(pre, cycle);
        T translated = this.translate(translator, invokeRule, target, cycle);
        if (SAUtil.DEBUG) {
            SAUtil.println((Object)("-- translation target of " + funcName + ":"));
            SAUtil.println(target);
            SAUtil.println((Object)("-- grammar translated by " + funcName + ":"));
            SAUtil.println(translated);
        }
        return translated;
    }

    protected T translate(ITranslator<T> translator, IProductionRule invokeRule, T target, int cycle) {
        Object translatedGrammar = null;
        try {
            translatedGrammar = cycle > 0 ? (IFormalLanguage)translator.translateCyclic(target, cycle) : (IFormalLanguage)translator.translate(target);
        }
        catch (TranslationException e) {
            if (SAUtil.DEBUG) {
                SAUtil.println((Object)"use the ANY pattern due to translation exception");
            }
            translatedGrammar = this.createAny();
        }
        return (T)translatedGrammar;
    }

    public ISolverCache<T> getCache() {
        return this.cache;
    }

    public ISolverStack getStack() {
        return this.stack;
    }

    public int getMaxCycle() {
        return this.MAX_CYCLE;
    }

    public void setMaxCycle(int max_cycle) {
        this.MAX_CYCLE = max_cycle;
    }

    public int getWideningThreshold() {
        return this.WIDENING_THRESHOLD;
    }

    public void setWideningThreshold(int threshold) {
        this.WIDENING_THRESHOLD = threshold;
    }

    public int getCharsetApproximationThreshold() {
        return this.CHARSET_APPROXIMATION_THRESHOLD;
    }

    public void setCharsetApproximationThreshold(int threshold) {
        this.CHARSET_APPROXIMATION_THRESHOLD = threshold;
    }

    @Override
    public IRegexParser getRegexParser() {
        return this.translators.getRegexParser();
    }

    public static class SimpleSubstitutionForSolver
    extends SimpleSubstitution {
        public SimpleSubstitutionForSolver(IVariableFactory<IVariable> varFactory) {
            super(varFactory);
        }

        public ISymbol copy(ISymbol s) {
            if (s instanceof InvocationSymbol) {
                return s;
            }
            return super.copy(s);
        }
    }
}

