/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator;

import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.grammar.string.DeepGrammarCopier;
import com.ibm.wala.automaton.grammar.string.DeepRuleCopier;
import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammarCopier;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.IRuleCopier;
import com.ibm.wala.automaton.grammar.string.ISimplify;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.parser.AmtParser;
import com.ibm.wala.automaton.regex.string.IPattern;
import com.ibm.wala.automaton.regex.string.StringPatternCompiler;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.automaton.string.MatchContext;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.automaton.string.VariableReplacer;
import com.ibm.wala.stringAnalysis.translator.IRuleModifier;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import com.ibm.wala.util.debug.Assertions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VariableDefiner
implements IRuleModifier {
    private static StringPatternCompiler compiler = new StringPatternCompiler();
    private static AmtParser parser = new AmtParser(AUtil.nullProgressMonitor);
    private Map<IVariable, ?> defs;
    private IVariableFactory<IVariable> varFactory;

    public VariableDefiner(Map<IVariable, ?> defs, IVariableFactory<IVariable> vf) {
        this.defs = defs;
        this.varFactory = vf;
    }

    public VariableDefiner(IVariable v, String pat, IVariableFactory<IVariable> vf) {
        this(v, (IPattern)parser.getParsedResult("/" + pat.replaceAll("/", "\\/") + "/"), vf);
    }

    public VariableDefiner(IVariable v, IPattern pat, IVariableFactory<IVariable> vf) {
        this(new IVariable[]{v}, new IPattern[]{pat}, vf);
    }

    public VariableDefiner(IVariable[] v, IPattern[] pat, IVariableFactory<IVariable> vf) {
        this(SAUtil.map((Object[])v, (Object[])pat), vf);
    }

    public VariableDefiner(IVariable[] v, IVariableFactory<IVariable> vf) {
        this(v, new IPattern[v.length], vf);
    }

    public VariableDefiner(IVariable v, IVariableFactory<IVariable> vf) {
        this(new IVariable[]{v}, vf);
    }

    private static Set<IProductionRule> createRules(IGrammar g, Map<IVariable, ?> defs, IVariableFactory<IVariable> varFactory) {
        HashSet<IProductionRule> rules = new HashSet<IProductionRule>();
        for (IVariable v : defs.keySet()) {
            Object obj = defs.get(v);
            if (obj instanceof IPattern) {
                Grammars.collectVariables((IGrammar)g);
                IPattern pat = (IPattern)obj;
                if (pat != null) {
                    IAutomaton fst = (IAutomaton)compiler.compile(pat);
                    Automatons.eliminateEpsilonTransitions((IAutomaton)fst);
                    IContextFreeGrammar cfg = Grammars.toCFG((IAutomaton)fst);
                    HashMap m = new HashMap();
                    cfg = (IContextFreeGrammar)Grammars.useUniqueVariables((IGrammar)g, varFactory, m);
                    MatchContext ctx = new MatchContext();
                    ctx.put((ISymbol)cfg.getStartSymbol(), (ISymbol)v);
                    cfg = (IContextFreeGrammar)cfg.copy((IGrammarCopier)new DeepGrammarCopier((IRuleCopier)new DeepRuleCopier((ISymbolCopier)new VariableReplacer((IMatchContext)ctx))));
                    rules.addAll(cfg.getRules());
                    continue;
                }
                rules.add((IProductionRule)new ProductionRule(v, new ISymbol[0]));
                continue;
            }
            if (obj instanceof String) {
                String str = (String)obj;
                rules.add((IProductionRule)new ProductionRule(v, (ISymbol)new StringSymbol(str)));
                continue;
            }
            if (obj instanceof ISymbol) {
                ISymbol sym = (ISymbol)obj;
                rules.add((IProductionRule)new ProductionRule(v, sym));
                continue;
            }
            Assertions.UNREACHABLE();
        }
        return rules;
    }

    @Override
    public ISimplify update(ISimplify g) {
        SimpleGrammar cfg = g.toSimple();
        Set<IProductionRule> rules = VariableDefiner.createRules((IGrammar)cfg, this.defs, this.varFactory);
        cfg.getRules().addAll(rules);
        return cfg;
    }
}

