/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.cfg.repository;

import com.ibm.wala.automaton.string.Automaton;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.FilteredTransition;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.State;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.automaton.string.Variable;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.Transducer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class Addcslashes
extends Transducer {
    private int charlistVarIndex;
    private CharSymbol[] charSyms;
    private Collection<ISymbol> charSymSet;
    private final CharSymbol backslashe = new CharSymbol("\\");

    public Addcslashes(int target, int charlist) {
        super(target);
        this.charlistVarIndex = charlist;
    }

    public Addcslashes(int charlist) {
        this.charlistVarIndex = charlist;
    }

    @Override
    public void setupParameters() {
        this.charSyms = this.getCharSymbols();
        this.charSymSet.addAll(Arrays.asList(this.charSyms));
    }

    @Override
    public IAutomaton createTransducer() {
        Variable v = new Variable("v");
        HashSet<FilteredTransition> transitions = new HashSet<FilteredTransition>();
        State s0 = new State("s0");
        State s1 = new State("s1");
        State initState = s0;
        HashSet<State> finalStates = new HashSet<State>();
        finalStates.add(s0);
        finalStates.add(s1);
        FilteredTransition t0 = new FilteredTransition((IState)s0, (IState)s0, (ISymbol)v, new ISymbol[]{this.backslashe, v}, new FilteredTransition.IFilter(){

            public List<ISymbol> invoke(ISymbol symbol, List<ISymbol> outputs) {
                CharSymbol charSym = (CharSymbol)symbol;
                char charVal = charSym.charValue();
                if ('~' < charVal || charVal < ' ') {
                    DecimalFormat df = new DecimalFormat("000");
                    ArrayList<ISymbol> octalStringSym = new ArrayList<ISymbol>(new StringSymbol(df.format(Double.parseDouble(Integer.toOctalString(charVal)))).toCharSymbols());
                    octalStringSym.add(0, (ISymbol)Addcslashes.this.backslashe);
                    return octalStringSym;
                }
                return outputs;
            }
        }, new FilteredTransition.ICondition(){

            public boolean accept(ISymbol symbol, IMatchContext ctx) {
                boolean r = Addcslashes.this.containsCharSymbols(symbol, Addcslashes.this.charSyms);
                return r;
            }

            public Collection<ISymbol> getTerminals() {
                return Addcslashes.this.charSymSet;
            }
        });
        transitions.add(t0);
        FilteredTransition t1 = new FilteredTransition((IState)s0, (IState)s0, (ISymbol)v, new ISymbol[]{v}, null, new FilteredTransition.ICondition(){

            public boolean accept(ISymbol symbol, IMatchContext ctx) {
                boolean r = !Addcslashes.this.containsCharSymbols(symbol, Addcslashes.this.charSyms);
                return r;
            }

            public Collection<ISymbol> getTerminals() {
                return Addcslashes.this.charSymSet;
            }
        });
        transitions.add(t1);
        Automaton transducer = new Automaton((IState)initState, finalStates, transitions);
        return transducer;
    }

    protected boolean containsCharSymbols(ISymbol symbol, CharSymbol[] charSyms) {
        for (int i = 0; i < charSyms.length; ++i) {
            if (!symbol.matches((ISymbol)charSyms[i], IMatchContext.DummyContext)) continue;
            return true;
        }
        return false;
    }

    private CharSymbol[] getCharSymbols() {
        StringSymbol charListStr = (StringSymbol)this.solveParameter(this.charlistVarIndex);
        String str = charListStr.getName();
        List charlist = charListStr.toCharSymbols();
        int doubleDotIndex = str.indexOf("..");
        if (doubleDotIndex > 0) {
            ArrayList<CharSymbol> charlist2 = new ArrayList<CharSymbol>();
            do {
                char endChar;
                for (int i = 0; i < doubleDotIndex - 1; ++i) {
                    charlist2.add((CharSymbol)charlist.get(i));
                }
                char startChar = str.charAt(doubleDotIndex - 1);
                if (startChar > (endChar = str.charAt(doubleDotIndex + 2))) {
                    charlist2.add(new CharSymbol(startChar));
                    charlist2.add(new CharSymbol("."));
                } else {
                    int charSymsLen = endChar - startChar + 1;
                    for (int i = 0; i < charSymsLen; ++i) {
                        charlist2.add(new CharSymbol((char)(startChar + i)));
                    }
                    if (startChar <= 'Z' && endChar >= 'a') {
                        charlist2.add(new CharSymbol("\t"));
                        charlist2.add(new CharSymbol("\n"));
                        charlist2.add(new CharSymbol("\r"));
                    }
                }
                if (str.length() <= (doubleDotIndex += 3)) break;
                str = str.substring(doubleDotIndex);
                charlist = charlist.subList(doubleDotIndex, charlist.size());
            } while ((doubleDotIndex = str.indexOf("..")) > 0);
            charlist.addAll(charlist2);
        }
        CharSymbol[] charSyms = charlist.toArray(new CharSymbol[0]);
        return charSyms;
    }
}

