/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.cfg.repository;

import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IGrammar;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.IllegalGrammarException;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.string.Automaton;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.automaton.string.NumberSymbol;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.automaton.string.Transition;
import com.ibm.wala.stringAnalysis.condition.CaseCondition;
import com.ibm.wala.stringAnalysis.condition.IPrimitiveCondition;
import com.ibm.wala.stringAnalysis.condition.NotCaseCondition;
import com.ibm.wala.stringAnalysis.condition.RangeCondition;
import com.ibm.wala.stringAnalysis.grammar.ConditionedInvocationSymbol;
import com.ibm.wala.stringAnalysis.translator.IConstraintSolver;
import com.ibm.wala.stringAnalysis.translator.TranslationException;
import com.ibm.wala.stringAnalysis.translator.cfg.repository.StringConstraint;
import com.ibm.wala.types.TypeReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class StringIndexOf
extends StringConstraint {
    private final TypeReference type;

    public StringIndexOf(int target, int constraintTarget, TypeReference type) {
        super(target, constraintTarget);
        this.type = type;
    }

    public boolean acceptCyclic() {
        return true;
    }

    @Override
    public SimpleGrammar prepare(IConstraintSolver<IContextFreeGrammar> solver, String funcName, ISymbol recv, List<ISymbol> params, IProductionRule rule, SimpleGrammar grammar) {
        SimpleGrammar g;
        super.prepare(solver, funcName, recv, params, rule, grammar);
        if (rule.getRight(0) instanceof ConditionedInvocationSymbol) {
            IPrimitiveCondition c;
            ConditionedInvocationSymbol invoke = (ConditionedInvocationSymbol)rule.getRight(0);
            IPrimitiveCondition cond = invoke.getCondition();
            if (cond instanceof RangeCondition) {
                RangeCondition range = (RangeCondition)cond;
                switch (range.op) {
                    case LT: {
                        if (range.boundary <= 0L) {
                            return this.prepareForNegation(solver, funcName, recv, params, rule, grammar);
                        }
                    }
                    case LE: {
                        if (range.boundary >= 0L) break;
                        return this.prepareForNegation(solver, funcName, recv, params, rule, grammar);
                    }
                }
            } else if (cond instanceof CaseCondition) {
                c = (CaseCondition)cond;
                if (c.label < 0) {
                    return this.prepareForNegation(solver, funcName, recv, params, rule, grammar);
                }
            } else if (cond instanceof NotCaseCondition) {
                c = (NotCaseCondition)cond;
                if (((NotCaseCondition)c).label >= 0) {
                    return this.prepareForNegation(solver, funcName, recv, params, rule, grammar);
                }
            }
        }
        try {
            Collection<String> strs;
            if (this.type.equals((Object)TypeReference.Int)) {
                NumberSymbol num = this.solveNumberParameter(0);
                char c = (char)num.intValue();
                strs = Collections.singleton(Character.toString(c));
            } else {
                strs = this.solveStringConstantParameters(0);
            }
            HashSet<ProductionRule> rules = new HashSet<ProductionRule>();
            IVariable start = this.createVariable();
            IVariable any1 = this.createVariable();
            rules.add(new ProductionRule(any1, new ISymbol[]{new RangeSymbol('\u0000', '\uffff'), any1}));
            rules.add(new ProductionRule(any1, new ISymbol[0]));
            IVariable any2 = this.createVariable();
            rules.add(new ProductionRule(any2, new ISymbol[]{new RangeSymbol('\u0000', '\uffff'), any2}));
            rules.add(new ProductionRule(any2, new ISymbol[0]));
            for (String str : strs) {
                rules.add(new ProductionRule(start, new ISymbol[]{any1, new StringSymbol(str), any2}));
            }
            g = new SimpleGrammar(start, rules);
        }
        catch (IllegalGrammarException e) {
            g = StringIndexOf.createAny();
        }
        return (SimpleGrammar)Grammars.useUniqueVariables((IGrammar)g, (IVariableFactory)this.varFactory, new HashMap());
    }

    public SimpleGrammar prepareForNegation(IConstraintSolver<IContextFreeGrammar> solver, String funcName, ISymbol recv, List<ISymbol> params, IProductionRule rule, SimpleGrammar grammar) {
        super.prepare(solver, funcName, recv, params, rule, grammar);
        SimpleGrammar g = StringIndexOf.createAny();
        try {
            Collection<String> strs;
            if (this.type.equals((Object)TypeReference.Int)) {
                NumberSymbol num = this.solveNumberParameter(0);
                char c = (char)num.intValue();
                strs = Collections.singleton(Character.toString(c));
            } else {
                strs = this.solveStringConstantParameters(0);
            }
            if (strs.size() == 1) {
                String str = strs.iterator().next();
                RangeSymbol anyChar = new RangeSymbol('\u0000', '\uffff');
                List chars = StringSymbol.toCharSymbols((String)str);
                Automaton fst = Automatons.createAutomaton((List)chars);
                IState initState = fst.getInitialState();
                IState finState = (IState)fst.getFinalStates().iterator().next();
                fst.getTransitions().add(new Transition(initState, initState, (ISymbol)anyChar));
                fst.getTransitions().add(new Transition(finState, finState, (ISymbol)anyChar));
                IAutomaton inv = Automatons.createComplement((IAutomaton)fst);
                HashSet<RangeSymbol> symbols = new HashSet<RangeSymbol>();
                symbols.addAll(chars);
                symbols.add(anyChar);
                Collection terminals = RangeSymbol.splitSymbols(symbols);
                inv = Automatons.expand((IAutomaton)inv, (Collection)terminals);
                g = Grammars.toCFG((IAutomaton)inv).toSimple();
            }
        }
        catch (IllegalGrammarException illegalGrammarException) {
            // empty catch block
        }
        return (SimpleGrammar)Grammars.useUniqueVariables((IGrammar)g, (IVariableFactory)this.varFactory, new HashMap());
    }

    @Override
    public IContextFreeGrammar translate(IContextFreeGrammar g) throws TranslationException {
        return g;
    }
}

