/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.regular.repository;

import com.ibm.wala.automaton.parser.JavaRegexParser;
import com.ibm.wala.automaton.regex.string.IPattern;
import com.ibm.wala.automaton.regex.string.StringPatternCompiler;
import com.ibm.wala.automaton.string.Automaton;
import com.ibm.wala.automaton.string.AutomatonSymbol;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.DeepSTSCopier;
import com.ibm.wala.automaton.string.DeepTransitionCopier;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.ILanguageSymbol;
import com.ibm.wala.automaton.string.ISTSCopier;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.IStateCopier;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.ITransitionCopier;
import com.ibm.wala.automaton.string.IValueSymbol;
import com.ibm.wala.automaton.string.IntSymbol;
import com.ibm.wala.automaton.string.SimpleStateCopier;
import com.ibm.wala.automaton.string.SimpleSymbolCopier;
import com.ibm.wala.automaton.string.State;
import com.ibm.wala.automaton.string.Transition;
import com.ibm.wala.stringAnalysis.translator.BasicTranslator;
import com.ibm.wala.util.debug.UnimplementedError;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public abstract class StringTranslator
extends BasicTranslator<IAutomaton> {
    protected static final IAutomaton ANY_FST = Automatons.createAny((IState)new State("s"));
    protected static final IAutomaton EMPTY_FST = Automatons.createEmpty((IState)new State("s"));
    private static final JavaRegexParser regexParser = new JavaRegexParser();
    private static final StringPatternCompiler patternCompiler = new StringPatternCompiler();

    public boolean isFixpoint(IAutomaton target, IAutomaton translatedGrammar) {
        throw new UnimplementedError();
    }

    public StringTranslator() {
    }

    public StringTranslator(int target) {
        super(target);
    }

    public IAutomaton toComparable(IAutomaton target) {
        return target;
    }

    protected static IAutomaton createAnyFST() {
        return ANY_FST;
    }

    protected static IAutomaton createEmptyFST() {
        return EMPTY_FST;
    }

    @Override
    protected IAutomaton convertIntToChar(IAutomaton fst) {
        SimpleSymbolCopier scopy = new SimpleSymbolCopier(){

            public ISymbol copy(ISymbol symbol) {
                if (symbol instanceof IntSymbol) {
                    IntSymbol isym = (IntSymbol)symbol;
                    CharSymbol csym = new CharSymbol((char)isym.intValue());
                    return csym;
                }
                return super.copy(symbol);
            }
        };
        return (IAutomaton)fst.copy((ISTSCopier)new DeepSTSCopier((ITransitionCopier)new DeepTransitionCopier((ISymbolCopier)scopy, (IStateCopier)SimpleStateCopier.defaultCopier)));
    }

    public static IAutomaton compileRegexp(String regexp) {
        IPattern pat = regexParser.parse(regexp);
        IAutomaton fst = (IAutomaton)patternCompiler.compile(pat);
        return Automatons.minimize((IAutomaton)fst);
    }

    public static IAutomaton possibleStrings(IAutomaton fst, boolean allowEmpty) {
        return StringTranslator.possibleStringsAsFST(Automatons.collectTerminals((IAutomaton[])new IAutomaton[]{fst}), allowEmpty);
    }

    public static IAutomaton possibleStringsAsFST(Collection<? extends ISymbol> terminals, boolean allowEmpty) {
        State initState = new State("s0");
        HashSet<Transition> ts = new HashSet<Transition>();
        HashSet<State> finStates = new HashSet<State>();
        State s = initState;
        if (!allowEmpty) {
            s = new State("s1");
            for (ISymbol iSymbol : terminals) {
                ts.add(new Transition((IState)initState, (IState)s, iSymbol));
            }
        }
        for (ISymbol iSymbol : terminals) {
            ts.add(new Transition((IState)s, (IState)s, iSymbol));
        }
        finStates.add(s);
        Automaton fst = new Automaton((IState)initState, finStates, ts);
        return fst;
    }

    @Override
    public IAutomaton possibleGrammar(IAutomaton fst) {
        return StringTranslator.possibleStrings(fst, true);
    }

    protected IAutomaton unionStringsAsFST(Collection<? extends ISymbol> terminals) {
        IState s = this.stateFactory.createState("s");
        IState e = this.stateFactory.createState("s");
        HashSet<Transition> transitions = new HashSet<Transition>();
        for (ISymbol iSymbol : terminals) {
            Transition t = new Transition(s, e, iSymbol);
            transitions.add(t);
        }
        return new Automaton(s, Collections.singleton(e), transitions);
    }

    @Override
    protected Collection<String> stringValues(IAutomaton g, int sizeLimit) {
        return Automatons.stringValues((IAutomaton)g, (int)sizeLimit, (boolean)true);
    }

    @Override
    protected ILanguageSymbol<IAutomaton> createLanguageSymbol(IAutomaton g) {
        return new AutomatonSymbol(g);
    }

    @Override
    protected ILanguageSymbol<IAutomaton> createLanguageSymbol(IValueSymbol s) {
        return new AutomatonSymbol(s.getAutomaton());
    }
}

