/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.translator.regular.repository;

import com.ibm.wala.automaton.string.CharSymbol;
import com.ibm.wala.automaton.string.IEnumerableSymbol;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.RangeSymbol;
import com.ibm.wala.stringAnalysis.translator.regular.repository.CharTranslator;
import com.ibm.wala.stringAnalysis.translator.regular.repository.Homomorphism;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ToUpperCase
extends CharTranslator {
    private static Set<ISymbol> terminals = new HashSet<ISymbol>();

    public ToUpperCase(int target) {
        super(target);
    }

    public ToUpperCase() {
    }

    @Override
    protected Collection<ISymbol> getTerminals(Collection<Homomorphism.Rule> ruleSet) {
        return terminals;
    }

    @Override
    protected ISymbol translate(char c) {
        if ('a' <= c && c <= 'z') {
            return new CharSymbol(Character.toUpperCase(c));
        }
        return new CharSymbol(c);
    }

    @Override
    protected List<ISymbol> translate(RangeSymbol range) {
        IEnumerableSymbol min = range.getMin();
        IEnumerableSymbol max = range.getMax();
        if (min instanceof CharSymbol) {
            min = (IEnumerableSymbol)this.translate(((CharSymbol)min).charValue());
        }
        if (max instanceof CharSymbol) {
            max = (IEnumerableSymbol)this.translate(((CharSymbol)max).charValue());
        }
        return Arrays.asList(new RangeSymbol(min, max));
    }

    static {
        terminals.add((ISymbol)new RangeSymbol((IEnumerableSymbol)new CharSymbol('\u0000'), (IEnumerableSymbol)new CharSymbol('`')));
        terminals.add((ISymbol)new RangeSymbol((IEnumerableSymbol)new CharSymbol('a'), (IEnumerableSymbol)new CharSymbol('z')));
        terminals.add((ISymbol)new RangeSymbol((IEnumerableSymbol)new CharSymbol('{'), (IEnumerableSymbol)new CharSymbol('\uffff')));
    }
}

