/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.jstaint.util.scopes;

import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.ModuleEntry;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.jstaint.util.scopes.ScopeUtil;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.ConstantPoolParser;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.debug.Assertions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ScopePruner {
    private final ClassDependencyComputer depComputer;

    private ScopePruner(ClassDependencyComputer depComputer) {
        this.depComputer = depComputer;
    }

    public AnalysisScope pruneScope(AnalysisScope initialScope) {
        LinkedList<Module> appModules = new LinkedList<Module>();
        LinkedList<Module> allModules = new LinkedList<Module>();
        Collection loaders = initialScope.getLoaders();
        assert (((ClassLoaderReference)loaders.iterator().next()).equals((Object)initialScope.getPrimordialLoader()));
        for (ClassLoaderReference loader : loaders) {
            boolean isApp = loader.equals((Object)initialScope.getApplicationLoader());
            List modules = initialScope.getModules(loader);
            for (Module m : modules) {
                if (isApp) {
                    appModules.add(m);
                }
                allModules.add(m);
            }
        }
        HashMap class2Module = HashMapFactory.make();
        HashMap class2ModuleEntry = HashMapFactory.make();
        for (Module m : allModules) {
            Iterator entries = m.getEntries();
            this.handleEntriesForModule(class2Module, class2ModuleEntry, m, entries);
        }
        HashSet neededClasses = HashSetFactory.make();
        HashSet neededModules = HashSetFactory.make();
        for (Module appModule : appModules) {
            neededModules.add(appModule);
            Iterator appModuleEntries = appModule.getEntries();
            this.initializeNeededClasses(neededClasses, appModuleEntries);
        }
        LinkedList<String> worklist = new LinkedList<String>();
        worklist.addAll(neededClasses);
        while (!worklist.isEmpty()) {
            String nextClass = (String)worklist.removeFirst();
            if (!class2Module.containsKey(nextClass)) continue;
            neededModules.add(class2Module.get(nextClass));
            ModuleEntry e = (ModuleEntry)class2ModuleEntry.get(nextClass);
            ClassReader klass = this.getShrikeClass(e);
            if (klass == null) continue;
            Set<String> dependencies = this.depComputer.getDependencies(klass);
            for (String d : dependencies) {
                if (!neededClasses.add(d)) continue;
                worklist.add(d);
            }
        }
        if (neededClasses.isEmpty()) {
            return initialScope;
        }
        return this.createPrunedScope(neededModules, initialScope);
    }

    private AnalysisScope createPrunedScope(Set<Module> neededModules, AnalysisScope initialScope) {
        AnalysisScope result = AnalysisScope.createJavaAnalysisScope();
        for (ClassLoaderReference loader : initialScope.getLoaders()) {
            for (Module m : initialScope.getModules(loader)) {
                if (!neededModules.contains(m)) continue;
                result.addToScope(loader, m);
            }
        }
        return result;
    }

    private void initializeNeededClasses(Set<String> neededClasses, Iterator<? extends ModuleEntry> appModuleEntries) {
        for (ModuleEntry e : Iterator2Iterable.make(appModuleEntries)) {
            if (e.isClassFile()) {
                ClassReader klass = this.getShrikeClass(e);
                if (klass == null) continue;
                Set<String> dependencies = this.depComputer.getDependencies(klass);
                neededClasses.addAll(dependencies);
                continue;
            }
            if (!e.isModuleFile()) continue;
            this.initializeNeededClasses(neededClasses, e.asModule().getEntries());
        }
    }

    private void handleEntriesForModule(Map<String, Module> class2Module, Map<String, ModuleEntry> class2ModuleEntry, Module m, Iterator<? extends ModuleEntry> entries) {
        for (ModuleEntry e : Iterator2Iterable.make(entries)) {
            if (e.isClassFile()) {
                String className = e.getClassName();
                if (class2Module.containsKey(className)) continue;
                class2Module.put(className, m);
                assert (!class2ModuleEntry.containsKey(className));
                class2ModuleEntry.put(className, e);
                continue;
            }
            if (!e.isModuleFile()) continue;
            this.handleEntriesForModule(class2Module, class2ModuleEntry, m, e.asModule().getEntries());
        }
    }

    private ClassReader getShrikeClass(ModuleEntry entry) {
        ByteArrayOutputStream S = new ByteArrayOutputStream();
        try {
            InputStream s = entry.getInputStream();
            this.readBytes(s, S);
            s.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
        try {
            return new ClassReader(S.toByteArray());
        }
        catch (InvalidClassFileException e) {
            return null;
        }
    }

    private void readBytes(InputStream is, ByteArrayOutputStream bytes) throws IOException {
        int n = 0;
        byte[] buffer = new byte[1024];
        while (n > -1) {
            n = is.read(buffer, 0, 1024);
            if (n <= -1) continue;
            bytes.write(buffer, 0, n);
        }
    }

    public static void main(String[] args) throws IOException {
        String scopeFile = args[0];
        AnalysisScope scope = ScopeUtil.substituteAndCreateJavaAnalysisScope(scopeFile, null, ScopePruner.class.getClassLoader());
        long start = System.currentTimeMillis();
        AnalysisScope pruned = ScopePruner.makeWithDefaultDepComputer().pruneScope(scope);
        long end = System.currentTimeMillis();
        System.out.println(end - start + "ms");
        System.out.println(pruned);
    }

    public static ScopePruner make(ClassDependencyComputer depComputer) {
        return new ScopePruner(depComputer);
    }

    public static ScopePruner makeWithDefaultDepComputer() {
        return ScopePruner.make(new DefaultDependencyComputer());
    }

    public static class DefaultDependencyComputer
    implements ClassDependencyComputer {
        @Override
        public Set<String> getDependencies(ClassReader klass) {
            try {
                HashSet result = HashSetFactory.make();
                result.add(klass.getSuperName());
                for (int i = 0; i < klass.getInterfaceCount(); ++i) {
                    result.add(klass.getInterfaceName(i));
                }
                ConstantPoolParser cp = klass.getCP();
                for (int i = 1; i < cp.getItemCount(); ++i) {
                    byte itemType = cp.getItemType(i);
                    if (!ConstantPoolParser.isRef((byte)itemType)) continue;
                    result.add(cp.getCPRefClass(i));
                }
                return result;
            }
            catch (InvalidClassFileException e) {
                return Collections.emptySet();
            }
        }
    }

    public static interface ClassDependencyComputer {
        public Set<String> getDependencies(ClassReader var1);
    }
}

