/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.specinfo;

import com.ibm.appscan.frameworks.specinfo.Property;
import com.ibm.appscan.frameworks.util.VDBChecks;
import java.util.Collection;
import java.util.Collections;

public class BeanDecl {
    private final String id;
    private final String concreteTypeName;
    private final String dynaBeanSupertypeName;
    private final BeanLifespan lifespan;
    private final Collection<Property> properties;

    private BeanDecl(String id, String typeName, BeanLifespan lifespan, Collection<Property> properties, String dynaBeanSupertypeName) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        if (lifespan == null) {
            throw new IllegalArgumentException("lifespan cannot be null");
        }
        if (properties == null) {
            throw new IllegalArgumentException("properties cannot be null");
        }
        if (typeName != null && !properties.isEmpty()) {
            throw new IllegalArgumentException("can't have both type and properties");
        }
        this.id = id;
        this.concreteTypeName = typeName;
        this.lifespan = lifespan;
        this.properties = properties;
        this.dynaBeanSupertypeName = dynaBeanSupertypeName;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.concreteTypeName;
    }

    public BeanLifespan getLifespan() {
        return this.lifespan;
    }

    public Collection<Property> getProperties() {
        return this.properties;
    }

    public static BeanDecl makeWithConcreteType(String id, String typeName, BeanLifespan lifespan) {
        assert (typeName == null || VDBChecks.isValidVDBType(typeName));
        return new BeanDecl(id, typeName, lifespan, Collections.emptySet(), null);
    }

    public static BeanDecl makeWithProperties(String id, BeanLifespan lifespan, Collection<Property> properties, String dynaBeanSupertypeName) {
        assert (dynaBeanSupertypeName == null || VDBChecks.isValidVDBType(dynaBeanSupertypeName));
        return new BeanDecl(id, null, lifespan, properties, dynaBeanSupertypeName);
    }

    public String getDynaBeanSupertypeName() {
        return this.dynaBeanSupertypeName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.concreteTypeName == null ? 0 : this.concreteTypeName.hashCode());
        result = 31 * result + (this.dynaBeanSupertypeName == null ? 0 : this.dynaBeanSupertypeName.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.lifespan == null ? 0 : this.lifespan.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BeanDecl other = (BeanDecl)obj;
        if (this.concreteTypeName == null ? other.concreteTypeName != null : !this.concreteTypeName.equals(other.concreteTypeName)) {
            return false;
        }
        if (this.dynaBeanSupertypeName == null ? other.dynaBeanSupertypeName != null : !this.dynaBeanSupertypeName.equals(other.dynaBeanSupertypeName)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.lifespan != other.lifespan) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public String toString() {
        return "BeanDecl [id=" + this.id + ", concreteTypeName=" + this.concreteTypeName + ", dynaBeanSupertypeName=" + this.dynaBeanSupertypeName + ", lifespan=" + (Object)((Object)this.lifespan) + ", properties=" + this.properties + "]";
    }

    public static enum BeanLifespan {
        GLOBAL,
        ENTRYPOINT,
        LOCAL;

    }
}

