/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.util;

import java.io.IOException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SchemaUtils {
    public static void validateDocumentAgainstSchema(String docFilename, URL schemaURL) throws SAXException, IOException {
        StreamSource source = new StreamSource(docFilename);
        SchemaUtils.validateSource(schemaURL, source);
    }

    private static void validateSource(URL schemaURL, Source source) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(schemaURL);
        Validator validator = schema.newValidator();
        validator.validate(source);
    }

    public static void validateDocumentAgainstSchema(Document doc, URL schemaURL) throws SAXException, IOException {
        SchemaUtils.validateSource(schemaURL, new DOMSource(doc));
    }
}

