/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.shrikeCT.tools;

import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.ConstantPoolReader;
import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.InvokeDynamicInstruction;
import com.ibm.wala.shrikeBT.InvokeInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.shrikeCT.CTDecoder;
import com.ibm.wala.shrikeBT.shrikeCT.CTUtils;
import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrikeCT.BootstrapMethodsReader;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.ClassWriter;
import com.ibm.wala.shrikeCT.CodeReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.util.collections.HashSetFactory;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;

public class BootstrapInstrumentor {
    private final PrintWriter w;
    private int idx;

    public BootstrapInstrumentor(PrintWriter w) {
        this.w = w;
    }

    public static void main(String[] args) throws Exception {
        PrintWriter w = new PrintWriter(new BufferedWriter(new OutputStreamWriter(System.out)));
        BootstrapInstrumentor p = new BootstrapInstrumentor(w);
        p.doit(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doit(String[] args) throws Exception {
        ClassInstrumenter ci;
        OfflineInstrumenter oi = new OfflineInstrumenter(true);
        oi.parseStandardArgs(args);
        oi.setPassUnmodifiedClasses(true);
        oi.beginTraversal();
        while ((ci = oi.nextClass()) != null) {
            try {
                this.idx = 0;
                Set<MethodData> bss = this.doClass(ci);
                ClassWriter cw = ci.emitClass();
                for (MethodData md : bss) {
                    CTUtils.compileAndAddMethodToClassWriter(md, cw, null);
                }
                oi.outputModifiedClass(ci, cw);
            }
            finally {
                this.w.flush();
            }
        }
        oi.close();
    }

    private Set<MethodData> dumpAttributes(ClassInstrumenter ci, int i, ClassReader.AttrIterator attrs) throws InvalidClassFileException, Decoder.InvalidBytecodeException, IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException {
        HashSet result = HashSetFactory.make();
        ClassReader cr = ci.getReader();
        while (attrs.isValid()) {
            String name = attrs.getName();
            if (name.equals("Code")) {
                IInstruction[] origInsts;
                CodeReader code = new CodeReader(attrs);
                CTDecoder decoder = new CTDecoder(code);
                decoder.decode();
                ConstantPoolReader cpr = decoder.getConstantPool();
                for (IInstruction inst : origInsts = decoder.getInstructions()) {
                    if (!(inst instanceof InvokeDynamicInstruction)) continue;
                    InvokeDynamicInstruction x = (InvokeDynamicInstruction)inst;
                    BootstrapMethodsReader.BootstrapMethod m = x.getBootstrap();
                    IInstruction[] insts = new IInstruction[m.callArgumentCount() + 8];
                    int arg = 0;
                    insts[arg++] = InvokeInstruction.make("()Ljava/lang/invoke/MethodHandles$Lookup;", "java/lang/invoke/MethodHandles", "lookup", IInvokeInstruction.Dispatch.STATIC);
                    insts[arg++] = ConstantInstruction.makeString(x.getMethodName());
                    insts[arg++] = ConstantInstruction.makeString(x.getMethodSignature());
                    insts[arg++] = ConstantInstruction.makeClass(cr.getName());
                    insts[arg++] = InvokeInstruction.make("()Ljava/lang/ClassLoader;", "java/lang/Class", "getClassLoader", IInvokeInstruction.Dispatch.VIRTUAL);
                    insts[arg++] = InvokeInstruction.make("(Ljava/lang/String;Ljava/lang/ClassLoader;)Ljava/lang/invoke/MethodType;", "java/lang/invoke/MethodType", "fromMethodDescriptorString", IInvokeInstruction.Dispatch.STATIC);
                    for (int an = 0; an < m.callArgumentCount(); ++an) {
                        insts[arg++] = ConstantInstruction.make(cpr, m.callArgumentIndex(an));
                    }
                    insts[arg++] = InvokeInstruction.make(m.methodType(), m.methodClass(), m.methodName(), ((InvokeDynamicInstruction)inst).getInvocationCode());
                    insts[arg++] = ReturnInstruction.make("Ljava/lang/invoke/CallSite;");
                    result.add(MethodData.makeWithDefaultHandlersAndInstToBytecodes(9, cr.getName(), "bs" + this.idx++, "()Ljava/lang/invoke/CallSite;", insts));
                }
            }
            attrs.advance();
        }
        return result;
    }

    public Set<MethodData> doClass(ClassInstrumenter ci) throws InvalidClassFileException, Decoder.InvalidBytecodeException, IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException {
        ClassReader cr = ci.getReader();
        ClassReader.AttrIterator attrs = new ClassReader.AttrIterator();
        cr.initClassAttributeIterator(attrs);
        int methodCount = cr.getMethodCount();
        HashSet result = HashSetFactory.make();
        for (int i = 0; i < methodCount; ++i) {
            cr.initMethodAttributeIterator(i, attrs);
            result.addAll(this.dumpAttributes(ci, i, attrs));
        }
        return result;
    }
}

