/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.sa.prefix.constants;

import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Pair;
import java.util.Map;

public class StringConstants {
    private static final Map<Pair<BasicBlockInContext<IExplodedBasicBlock>, Integer>, String> strConstants = HashMapFactory.make();

    public static boolean isStringConstant(BasicBlockInContext<IExplodedBasicBlock> bb, int valueNumber) {
        CGNode n = bb.getNode();
        IR ir = n.getIR();
        SymbolTable sb = ir.getSymbolTable();
        if (sb.isStringConstant(valueNumber)) {
            return true;
        }
        Pair p = Pair.make(bb, (Object)valueNumber);
        return strConstants.containsKey(p);
    }

    public static String getStringValue(BasicBlockInContext<IExplodedBasicBlock> bb, int valueNumber) {
        assert (StringConstants.isStringConstant(bb, valueNumber));
        Pair p = Pair.make(bb, (Object)valueNumber);
        String result = strConstants.get(p);
        if (result == null) {
            CGNode n = bb.getNode();
            IR ir = n.getIR();
            SymbolTable sb = ir.getSymbolTable();
            return sb.getStringValue(valueNumber);
        }
        return result;
    }

    public static void setStringConstant(BasicBlockInContext<IExplodedBasicBlock> bb, int valueNumber, String value) {
        Pair p = Pair.make(bb, (Object)valueNumber);
        strConstants.put((Pair<BasicBlockInContext<IExplodedBasicBlock>, Integer>)p, value);
    }

    public static boolean hasConstantPrefix(BasicBlockInContext<IExplodedBasicBlock> bb, int valueNumber) {
        SSABinaryOpInstruction binaryOp;
        if (StringConstants.isStringConstant(bb, valueNumber)) {
            return true;
        }
        CGNode n = bb.getNode();
        IR ir = n.getIR();
        DefUse du = new DefUse(ir);
        SSAInstruction defStmt = du.getDef(valueNumber);
        if (defStmt instanceof SSABinaryOpInstruction && (binaryOp = (SSABinaryOpInstruction)defStmt).getOperator() == IBinaryOpInstruction.Operator.ADD) {
            int lhs = binaryOp.getUse(0);
            return StringConstants.hasConstantPrefix(bb, lhs);
        }
        return false;
    }

    public static String getConstantPrefix(BasicBlockInContext<IExplodedBasicBlock> bb, int valueNumber) {
        assert (StringConstants.hasConstantPrefix(bb, valueNumber));
        if (StringConstants.isStringConstant(bb, valueNumber)) {
            return StringConstants.getStringValue(bb, valueNumber);
        }
        CGNode n = bb.getNode();
        IR ir = n.getIR();
        DefUse du = new DefUse(ir);
        SSAInstruction defStmt = du.getDef(valueNumber);
        assert (defStmt instanceof SSABinaryOpInstruction);
        return StringConstants.getConstantPrefix(bb, defStmt.getUse(0));
    }
}

