/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.sa.prefix.flow;

import com.ibm.appscan.sa.prefix.constants.StringConstants;
import com.ibm.appscan.sa.prefix.flow.AbstractFlow;
import com.ibm.appscan.sa.prefix.main.StringPrefix;
import com.ibm.appscan.sa.prefix.main.StringPrefixDomain;
import com.ibm.wala.cast.ir.ssa.AstAssertInstruction;
import com.ibm.wala.cast.ir.ssa.AstEchoInstruction;
import com.ibm.wala.cast.ir.ssa.AstGlobalRead;
import com.ibm.wala.cast.ir.ssa.AstGlobalWrite;
import com.ibm.wala.cast.ir.ssa.AstIsDefinedInstruction;
import com.ibm.wala.cast.ir.ssa.AstLexicalRead;
import com.ibm.wala.cast.ir.ssa.AstLexicalWrite;
import com.ibm.wala.cast.ir.ssa.EachElementGetInstruction;
import com.ibm.wala.cast.ir.ssa.EachElementHasNextInstruction;
import com.ibm.wala.cast.js.ssa.JSInstructionVisitor;
import com.ibm.wala.cast.js.ssa.JavaScriptCheckReference;
import com.ibm.wala.cast.js.ssa.JavaScriptInstanceOf;
import com.ibm.wala.cast.js.ssa.JavaScriptInvoke;
import com.ibm.wala.cast.js.ssa.JavaScriptPropertyRead;
import com.ibm.wala.cast.js.ssa.JavaScriptPropertyWrite;
import com.ibm.wala.cast.js.ssa.JavaScriptTypeOfInstruction;
import com.ibm.wala.cast.js.ssa.JavaScriptWithRegion;
import com.ibm.wala.cast.js.ssa.PrototypeLookup;
import com.ibm.wala.cast.js.ssa.SetPrototype;
import com.ibm.wala.dataflow.IFDS.ICFGSupergraph;
import com.ibm.wala.dataflow.IFDS.IUnaryFlowFunction;
import com.ibm.wala.dataflow.IFDS.IdentityFlowFunction;
import com.ibm.wala.ipa.cfg.BasicBlockInContext;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.ssa.IVisitorWithAddresses;
import com.ibm.wala.ssa.SSAAddressOfInstruction;
import com.ibm.wala.ssa.SSAArrayLengthInstruction;
import com.ibm.wala.ssa.SSAArrayLoadInstruction;
import com.ibm.wala.ssa.SSAArrayStoreInstruction;
import com.ibm.wala.ssa.SSABinaryOpInstruction;
import com.ibm.wala.ssa.SSACheckCastInstruction;
import com.ibm.wala.ssa.SSAComparisonInstruction;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAConversionInstruction;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAGetInstruction;
import com.ibm.wala.ssa.SSAGotoInstruction;
import com.ibm.wala.ssa.SSAInstanceofInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.ssa.SSALoadIndirectInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSAMonitorInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.ssa.SSAPutInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SSAStoreIndirectInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.ssa.SSAThrowInstruction;
import com.ibm.wala.ssa.SSAUnaryOpInstruction;
import com.ibm.wala.ssa.analysis.IExplodedBasicBlock;
import com.ibm.wala.util.collections.ArraySet;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class NormalFlow
extends AbstractFlow
implements IUnaryFlowFunction {
    private NormalFlow(StringPrefixDomain domain, ICFGSupergraph supergraph, BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        super(domain, supergraph, src, dest);
    }

    public static IUnaryFlowFunction create(StringPrefixDomain domain, ICFGSupergraph supergraph, BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        if (src.isExitBlock()) {
            throw new IllegalArgumentException("Illegal to have normal flow from an exit block " + src + " " + dest);
        }
        if (NormalFlow.isIdentityFlow(src, dest)) {
            return IdentityFlowFunction.identity();
        }
        return new NormalFlow(domain, supergraph, src, dest);
    }

    private static boolean isIdentityFlow(BasicBlockInContext<IExplodedBasicBlock> src, BasicBlockInContext<IExplodedBasicBlock> dest) {
        SSAInstruction s = ((IExplodedBasicBlock)src.getDelegate()).getInstruction();
        return s == null && !((IExplodedBasicBlock)dest.getDelegate()).iteratePhis().hasNext();
    }

    @Override
    public IntSet getTargetsImpl(int d1) {
        StringPrefix strPref = (StringPrefix)this.getDomain().getMappedObject(d1);
        SSAInstruction s = ((IExplodedBasicBlock)this.getSrc().getDelegate()).getInstruction();
        if (s == null) {
            Set<StringPrefix> phiOut = this.phiOut(Collections.singleton(strPref), this.getSrc(), this.getDest());
            return this.toIntSet(phiOut.toArray(new StringPrefix[0]));
        }
        Visitor v = new Visitor(strPref);
        s.visit((SSAInstruction.IVisitor)v);
        assert (v.out != null);
        Set<StringPrefix> result = this.phiOut(v.out, this.getSrc(), this.getDest());
        return this.toIntSet(result.toArray(new StringPrefix[0]));
    }

    class Visitor
    implements IVisitorWithAddresses,
    JSInstructionVisitor {
        private final StringPrefix in;
        private Set<StringPrefix> out;

        public Visitor(StringPrefix in) {
            this.in = in;
        }

        public void visitAddressOf(SSAAddressOfInstruction instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitLoadIndirect(SSALoadIndirectInstruction instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitStoreIndirect(SSAStoreIndirectInstruction instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitArrayLength(SSAArrayLengthInstruction instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitArrayLoad(SSAArrayLoadInstruction instruction) {
            this.arrayLoad(instruction.getUse(0), instruction.getDef());
        }

        private void arrayLoad(int arr, int def) {
            if (this.in.getArrPtrs().contains(arr)) {
                HashSet envPtrs = HashSetFactory.make(this.in.getEnvPtrs());
                envPtrs.add(def);
                this.out = HashSetFactory.make((int)2);
                this.out.add(new StringPrefix(this.in.getPrefix(), envPtrs, this.in.getArrPtrs(), this.in.getBodyPtrs(), this.in.hasSuffix()));
                this.out.add(this.in);
            } else {
                this.out = Collections.singleton(this.in);
            }
        }

        public void visitArrayStore(SSAArrayStoreInstruction instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitBinaryOp(SSABinaryOpInstruction instruction) {
            if (instruction.getOperator() == IBinaryOpInstruction.Operator.ADD && this.in.getEnvPtrs().contains(instruction.getUse(0))) {
                StringPrefix newSP;
                int appendedStrValueNumber = instruction.getUse(1);
                this.out = HashSetFactory.make((int)2);
                this.out.add(this.in);
                if (this.in.hasSuffix()) {
                    newSP = new StringPrefix(this.in.getPrefix(), Collections.singleton(instruction.getDef()), Collections.emptyMap(), true);
                } else if (StringConstants.isStringConstant(NormalFlow.this.getSrc(), appendedStrValueNumber)) {
                    String str = StringConstants.getStringValue(NormalFlow.this.getSrc(), appendedStrValueNumber);
                    newSP = new StringPrefix(this.in.getPrefix().concat(str), Collections.singleton(instruction.getDef()), Collections.emptyMap(), false);
                } else {
                    newSP = new StringPrefix(this.in.getPrefix(), Collections.singleton(instruction.getDef()), Collections.emptyMap(), true);
                }
                this.out.add(newSP);
            } else if (instruction.getOperator() == IBinaryOpInstruction.Operator.ADD && this.in.getEnvPtrs().contains(instruction.getUse(1)) && StringConstants.isStringConstant(NormalFlow.this.getSrc(), instruction.getUse(0))) {
                this.out = HashSetFactory.make((int)2);
                this.out.add(this.in);
                String pref = StringConstants.getStringValue(NormalFlow.this.getSrc(), instruction.getUse(0));
                StringPrefix newSP = new StringPrefix(pref.concat(this.in.getPrefix()), Collections.singleton(instruction.getDef()), Collections.emptyMap(), this.in.hasSuffix());
                this.out.add(newSP);
            } else if (instruction.getOperator() == IBinaryOpInstruction.Operator.ADD && this.in.getEnvPtrs().contains(instruction.getUse(1)) && StringConstants.hasConstantPrefix(NormalFlow.this.getSrc(), instruction.getUse(0))) {
                String constPrefix = StringConstants.getConstantPrefix(NormalFlow.this.getSrc(), instruction.getUse(0));
                StringPrefix newSP = new StringPrefix(constPrefix, Collections.singleton(instruction.getDef()), Collections.emptyMap(), true);
                this.out = HashSetFactory.make((int)2);
                this.out.add(this.in);
                this.out.add(newSP);
            } else {
                this.out = Collections.singleton(this.in);
            }
        }

        public void visitCheckCast(SSACheckCastInstruction instruction) {
            int use = instruction.getUse(0);
            if (this.in.getEnvPtrs().contains(use) || this.in.getArrPtrs().contains(use)) {
                boolean isEnvPtrs = this.in.getEnvPtrs().contains(use);
                ArraySet newPtrs = new ArraySet();
                newPtrs.addAll(isEnvPtrs ? this.in.getEnvPtrs() : this.in.getArrPtrs());
                newPtrs.add(instruction.getDef());
                this.out = Collections.singleton(new StringPrefix(this.in.getPrefix(), (Set<Integer>)(isEnvPtrs ? newPtrs : this.in.getEnvPtrs()), isEnvPtrs ? this.in.getArrPtrs() : newPtrs, this.in.getBodyPtrs(), this.in.hasSuffix()));
            } else {
                this.out = Collections.singleton(this.in);
            }
        }

        public void visitComparison(SSAComparisonInstruction instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitConditionalBranch(SSAConditionalBranchInstruction instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitConversion(SSAConversionInstruction instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitGet(SSAGetInstruction instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitGetCaughtException(SSAGetCaughtExceptionInstruction instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitGoto(SSAGotoInstruction instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitInstanceof(SSAInstanceofInstruction instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitInvoke(SSAInvokeInstruction instruction) {
            Assertions.UNREACHABLE();
        }

        public void visitLoadMetadata(SSALoadMetadataInstruction instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitMonitor(SSAMonitorInstruction instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitNew(SSANewInstruction instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitPhi(SSAPhiInstruction instruction) {
            Assertions.UNREACHABLE();
        }

        public void visitPi(SSAPiInstruction instruction) {
            Assertions.UNREACHABLE();
        }

        public void visitPut(SSAPutInstruction instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitReturn(SSAReturnInstruction instruction) {
            if (!instruction.returnsVoid()) {
                int use = instruction.getResult();
                if (this.in.getEnvPtrs().contains(use)) {
                    ArraySet envPtrs = new ArraySet();
                    envPtrs.addAll(this.in.getEnvPtrs());
                    envPtrs.add(StringPrefix.RET);
                    this.out = Collections.singleton(new StringPrefix(this.in.getPrefix(), (Set<Integer>)envPtrs, this.in.getArrPtrs(), this.in.getBodyPtrs(), this.in.hasSuffix()));
                } else if (this.in.getArrPtrs().contains(use)) {
                    ArraySet arrPtrs = new ArraySet();
                    arrPtrs.addAll(this.in.getArrPtrs());
                    arrPtrs.add(StringPrefix.RET);
                    this.out = Collections.singleton(new StringPrefix(this.in.getPrefix(), this.in.getEnvPtrs(), (Set<Integer>)arrPtrs, this.in.getBodyPtrs(), this.in.hasSuffix()));
                } else {
                    this.out = Collections.singleton(this.in);
                }
            } else {
                this.out = Collections.singleton(this.in);
            }
        }

        public void visitSwitch(SSASwitchInstruction instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitThrow(SSAThrowInstruction instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitUnaryOp(SSAUnaryOpInstruction instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitCheckRef(JavaScriptCheckReference instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitJavaScriptInstanceOf(JavaScriptInstanceOf instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitJavaScriptInvoke(JavaScriptInvoke instruction) {
            Assertions.UNREACHABLE();
        }

        public void visitJavaScriptPropertyRead(JavaScriptPropertyRead instruction) {
            if (this.in.getArrPtrs().contains(instruction.getUse(0))) {
                this.arrayLoad(instruction.getUse(0), instruction.getDef());
            } else {
                this.out = Collections.singleton(this.in);
            }
        }

        public void visitJavaScriptPropertyWrite(JavaScriptPropertyWrite instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitTypeOf(JavaScriptTypeOfInstruction instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitWithRegion(JavaScriptWithRegion instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitAssert(AstAssertInstruction instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitAstGlobalRead(AstGlobalRead instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitAstGlobalWrite(AstGlobalWrite instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitAstLexicalRead(AstLexicalRead instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitAstLexicalWrite(AstLexicalWrite instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitEachElementGet(EachElementGetInstruction inst) {
            this.out = Collections.singleton(this.in);
        }

        public void visitEachElementHasNext(EachElementHasNextInstruction inst) {
            this.out = Collections.singleton(this.in);
        }

        public void visitEcho(AstEchoInstruction inst) {
            this.out = Collections.singleton(this.in);
        }

        public void visitIsDefined(AstIsDefinedInstruction inst) {
            this.out = Collections.singleton(this.in);
        }

        public void visitSetPrototype(SetPrototype instruction) {
            this.out = Collections.singleton(this.in);
        }

        public void visitPrototypeLookup(PrototypeLookup instruction) {
            this.out = Collections.singleton(this.in);
        }
    }
}

