/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.discovery.jetbrains.utils;

import com.ibm.appscan.common.CommonCore;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Module {
    public static final String FILE_PROJECT_DIR = "file://$PROJECT_DIR$";
    public static final String FILE_MODULE_DIR = "file://$MODULE_DIR$";
    public static final String DOT_IDEA_PATH = ".idea";
    public static final String MISC_XML_PATH = "/misc.xml";
    private String m_name;
    private File m_directory;
    private File m_imlFile;
    private String m_type;
    private List<String> m_outputDirectories = new ArrayList<String>();
    private List<String> m_sourceDirectories = new ArrayList<String>();
    private List<String> m_classpath = new ArrayList<String>();

    public Module() {
    }

    public Module(String moduleUrl, String projectPath) {
        this.init(moduleUrl, projectPath);
    }

    private void init(String moduleUrl, String projectPath) {
        this.m_name = moduleUrl.substring(moduleUrl.lastIndexOf("/") + 1, moduleUrl.length() - 4);
        this.m_directory = new File(moduleUrl.replace(FILE_PROJECT_DIR, projectPath)).getParentFile();
        this.m_imlFile = new File(moduleUrl.replace(FILE_PROJECT_DIR, projectPath));
        try {
            String url;
            int i;
            String iml_path = this.m_imlFile.getCanonicalPath();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
            Document document = documentBuilder.parse(iml_path);
            NodeList nodeList = document.getElementsByTagName("module");
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Element module_Element = (Element)nodeList.item(i2);
                this.m_type = module_Element.getAttribute("type");
            }
            nodeList = document.getElementsByTagName("sourceFolder");
            File moduleDir = new File(iml_path).getParentFile();
            for (i = 0; i < nodeList.getLength(); ++i) {
                Element sourceFolder_Element = (Element)nodeList.item(i);
                url = sourceFolder_Element.getAttribute("url");
                String isTestSource = sourceFolder_Element.getAttribute("isTestSource");
                if (!"false".equalsIgnoreCase(isTestSource)) continue;
                this.m_sourceDirectories.add(new File(url.replace(FILE_MODULE_DIR, moduleDir.getPath())).getPath());
            }
            nodeList = document.getElementsByTagName("orderEntry");
            for (i = 0; i < nodeList.getLength(); ++i) {
                Element orderEntry_Element = (Element)nodeList.item(i);
                String type = orderEntry_Element.getAttribute("type");
                String scope = orderEntry_Element.getAttribute("scope");
                if ("module-library".equalsIgnoreCase(type) && !"TEST".equalsIgnoreCase(scope)) {
                    NodeList nl = orderEntry_Element.getElementsByTagName("root");
                    for (int j = 0; j < nl.getLength(); ++j) {
                        Element root_Element = (Element)nl.item(j);
                        String url2 = root_Element.getAttribute("url");
                        if ("".equalsIgnoreCase(this.convertUrlToClasspath(url2, moduleDir.getPath()))) continue;
                        this.m_classpath.add(this.convertUrlToClasspath(url2, moduleDir.getPath()));
                    }
                    continue;
                }
                if (!"library".equalsIgnoreCase(type) || !"project".equalsIgnoreCase(orderEntry_Element.getAttribute("level"))) continue;
                String projectLibraryName = orderEntry_Element.getAttribute("name");
                File projectLibraryXML = new File(projectPath, ".idea/libraries/" + projectLibraryName + ".xml");
                Document projectLibraryDoc = documentBuilder.parse(projectLibraryXML);
                NodeList nl = projectLibraryDoc.getElementsByTagName("root");
                for (int j = 0; j < nl.getLength(); ++j) {
                    Element root_Element = (Element)nl.item(j);
                    String url3 = root_Element.getAttribute("url");
                    if ("".equalsIgnoreCase(this.convertUrlToClasspath(url3, projectPath))) continue;
                    this.m_classpath.add(this.convertUrlToClasspath(url3, projectPath));
                }
            }
            nodeList = document.getElementsByTagName("output");
            for (i = 0; i < nodeList.getLength(); ++i) {
                Element outputFolder_Element = (Element)nodeList.item(i);
                url = outputFolder_Element.getAttribute("url");
                this.m_outputDirectories.add(new File(url.replace(FILE_MODULE_DIR, moduleDir.getPath())).getPath());
            }
            File projectRootDir = new File(projectPath);
            File misc_xml_file = new File(projectRootDir, ".idea/misc.xml");
            if (this.m_outputDirectories.size() == 0) {
                String projectOutputDirectory = "";
                document = documentBuilder.parse(misc_xml_file.getPath());
                nodeList = document.getElementsByTagName("output");
                for (int i3 = 0; i3 < nodeList.getLength(); ++i3) {
                    Element output_Element = (Element)nodeList.item(i3);
                    String outputurl = output_Element.getAttribute("url");
                    projectOutputDirectory = new File(outputurl.replace(FILE_PROJECT_DIR, projectPath) + "/production").getPath();
                    this.m_outputDirectories.add(new File(projectOutputDirectory, this.m_name).getPath());
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            CommonCore.getLogManager().log(e);
        }
    }

    private String convertUrlToClasspath(String url, String rootDir) {
        String classpath = "";
        String realUrl = "";
        if (url.startsWith("file://$MODULE_DIR$/") || url.startsWith("jar://$MODULE_DIR$/") || url.startsWith("file://$PROJECT_DIR$/") || url.startsWith("jar://$PROJECT_DIR$/")) {
            realUrl = url.replaceAll("(file|jar)://(\\$MODULE_DIR\\$|\\$PROJECT_DIR\\$)/", "").replace("!/", "");
        }
        if (!realUrl.isEmpty()) {
            File file = new File(rootDir, realUrl);
            classpath = Paths.get(file.getPath(), new String[0]).normalize().toString();
        }
        return classpath;
    }

    public String getName() {
        return this.m_name;
    }

    public String getType() {
        return this.m_type;
    }

    public List<String> getClasspath() {
        return this.m_classpath;
    }

    public File getDirectory() {
        return this.m_directory;
    }

    public List<String> getSourceDirectories() {
        return this.m_sourceDirectories;
    }

    public List<String> getOutputDirectories() {
        return this.m_outputDirectories;
    }
}

