/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.irx.slice.wafl;

import com.hcl.irx.stage.Stager;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.utils.IOUtil;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;

public class WalaScope {
    private File m_scope_file;
    IScanTargetMinProxy m_proxy;
    Stager m_stager;

    public WalaScope(Stager stager, IScanTargetMinProxy proxy) {
        this.m_stager = stager;
        this.m_proxy = proxy;
        this.m_scope_file = new File(stager.getWaflGenPath(), this.getFileName());
    }

    public File getOutputFile() {
        return this.m_scope_file;
    }

    protected String getFileName() {
        return "wafl.scope";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeScope() throws ParserConfigurationException, TransformerFactoryConfigurationError, IOException, TransformerException {
        BufferedWriter writer = null;
        try {
            if (!this.m_scope_file.exists()) {
                this.m_scope_file.createNewFile();
            }
            FileWriter fw = new FileWriter(this.m_scope_file);
            writer = new BufferedWriter(fw);
            String SCOPE_TYPE_PRIMORDIAL = "Primordial";
            String[] bootstrapPrimordials = this.m_proxy.getBuildInfo().getProperty("bootstrap_classpath").split(File.pathSeparator);
            for (int i = 0; i < bootstrapPrimordials.length; ++i) {
                String _path = bootstrapPrimordials[i];
                if (_path.length() <= 0) continue;
                File _file = new File(_path);
                if (_file.isFile()) {
                    if (_path.endsWith(".jmod")) {
                        writer.write(SCOPE_TYPE_PRIMORDIAL + ",Java,jmodFile," + _path + System.getProperty("line.separator"));
                        continue;
                    }
                    writer.write(SCOPE_TYPE_PRIMORDIAL + ",Java,jarFile," + _path + System.getProperty("line.separator"));
                    continue;
                }
                if (!_file.isDirectory()) continue;
                writer.write(SCOPE_TYPE_PRIMORDIAL + ",Java,binaryDir," + _path + System.getProperty("line.separator"));
            }
            String[] extensionPrimordials = this.m_proxy.getBuildInfo().getProperty("extension_jars").split(File.pathSeparator);
            for (int i = 0; i < extensionPrimordials.length; ++i) {
                File _file;
                String _path = extensionPrimordials[i];
                if (_path.length() <= 0 || !(_file = new File(_path)).exists()) continue;
                if (_file.isDirectory()) {
                    writer.write(SCOPE_TYPE_PRIMORDIAL + ",Java,binaryDir," + (String)_path + System.getProperty("line.separator"));
                    continue;
                }
                writer.write(SCOPE_TYPE_PRIMORDIAL + ",Java,jarFile," + (String)_path + System.getProperty("line.separator"));
            }
            String SCOPE_TYPE_EXTENSION = "Extension";
            for (File jar : this.m_stager.getDependencies()) {
                if (jar.getAbsolutePath().endsWith("user.code.staged.jar")) continue;
                writer.write(SCOPE_TYPE_EXTENSION + ",Java,jarFile," + jar + System.getProperty("line.separator"));
            }
            String SCOPE_TYPE_APPLICATION = "Application";
            for (File ci : this.m_stager.getUserCodeFiles()) {
                writer.write(SCOPE_TYPE_APPLICATION + ",Java,classFile," + ci.getCanonicalPath() + System.getProperty("line.separator"));
            }
            IOUtil.close((Closeable)writer);
        }
        catch (IOException e) {
            CommonCore.getLogManager().log((Exception)e);
        }
        finally {
            IOUtil.close(writer);
        }
    }
}

