/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.config;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.SaveLocation;
import com.ibm.appscan.common.utils.ProcessRunner;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.config.DefaultProgressAdapter;
import com.ibm.appscan.config.Messages;
import java.io.File;
import java.io.IOException;

public class IRGenerator {
    private ProcessRunner m_runner;
    private SaveLocation m_save_location;
    private File m_config_dir;

    public IRGenerator(SaveLocation location, File configDir) {
        this.m_save_location = location;
        this.m_config_dir = configDir;
    }

    protected String getWorkLocation() {
        return this.getSaveLocation().getWorkLocation().getAbsolutePath();
    }

    protected boolean skipMetrics() {
        return false;
    }

    protected SaveLocation getSaveLocation() {
        return this.m_save_location;
    }

    private ProcessRunner getProcessRunner() {
        if (this.m_runner == null) {
            String cDir = this.m_config_dir == null ? System.getProperty("user.dir") : this.m_config_dir.getAbsolutePath();
            String[] args = new String[]{CommonCore.getDirectoryLocator().getBin() + "StaticAnalyzer", "--gen-ir", "-d", this.getWorkLocation(), "-c", cDir, this.skipMetrics() ? "--metrics-off" : "", SystemUtil.isDebug() ? "--debug" : "", SystemUtil.isThirdParty() ? "--thirdParty" : "", SystemUtil.shouldShowProgress() ? "--show-progress" : "", "", ""};
            String formatType = SystemUtil.getIPVAFormat();
            if (formatType != null) {
                args[args.length - 2] = "-f";
                args[args.length - 1] = formatType;
            }
            this.m_runner = new ProcessRunner(args);
            this.addEnvironmentVariable("JAVA_HOME", this.getJavaHome());
            if (SystemUtil.isSourceCodeOnly()) {
                this.addEnvironmentVariable("APPSCAN_SCO", "true");
            }
            if (!SystemUtil.isWindows()) {
                String variable = SystemUtil.isMac() ? "DYLD_LIBRARY_PATH" : "LD_LIBRARY_PATH";
                String curr = System.getenv(variable);
                String binDir = CommonCore.getDirectoryLocator().getBin();
                boolean ldFound = false;
                if (curr != null) {
                    for (String s : curr.split(":")) {
                        if (!binDir.equals(s)) continue;
                        ldFound = true;
                        break;
                    }
                }
                if (!ldFound) {
                    this.addEnvironmentVariable(variable, CommonCore.getDirectoryLocator().getBin() + ":" + curr);
                } else {
                    this.addEnvironmentVariable(variable, curr);
                }
            }
        }
        return this.m_runner;
    }

    public void addEnvironmentVariable(String key, String value) {
        this.getProcessRunner().environment().put(key, value);
    }

    public void run() throws IOException, AppScanException {
        this.run(new DefaultProgressAdapter());
    }

    public int run(final IProgress progress) throws IOException, AppScanException {
        ProcessRunner.StreamHandler outputHandler = new ProcessRunner.StreamHandler(){
            String tempChars = ">>";

            protected void handle(String line) {
                if (!SystemUtil.IRGenClient.AppScanGo.name().equalsIgnoreCase(System.getenv("APPSCAN_IRGEN_CLIENT")) && line.contains(this.tempChars)) {
                    line = line.replace(this.tempChars, "");
                }
                progress.setStatus(new Message(1, line));
            }
        };
        ProcessRunner.StreamHandler errorHandler = new ProcessRunner.StreamHandler(){

            protected void handle(String line) {
                CommonCore.getLogManager().log(new Message(4, line));
            }
        };
        int rc = this.getProcessRunner().run(outputHandler, errorHandler);
        if (rc == 1) {
            throw new AppScanException(Messages.getMessage("err.ir.gen.incomplete.path", this.getWorkLocation()), rc);
        }
        if (rc == 2) {
            throw new AppScanException(Messages.getMessage("err.ir.gen.excluded.all", new Object[0]), rc);
        }
        if (rc == 3) {
            throw new AppScanException(Messages.getMessage("err.ir.gen.no.scan.units", new Object[0]), rc);
        }
        if (rc == 4) {
            rc = -1;
        } else {
            if (ProcessRunner.getRCSignal((int)rc) > 0) {
                throw new AppScanException(Messages.getMessage("err.ir.gen.signal", ProcessRunner.getRCSignal((int)rc)), rc);
            }
            if (rc != 0) {
                throw new AppScanException(Messages.getMessage("err.ir.gen", rc), rc);
            }
        }
        return rc;
    }

    private String getJavaHome() {
        File javaHome = new File(System.getProperty("java.home"));
        if (javaHome.getName().equalsIgnoreCase("jre")) {
            javaHome = javaHome.getParentFile();
        }
        return javaHome.getAbsolutePath();
    }
}

