/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.thirdpartylib;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.ScanModelFactory;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.dir.ICustomCollector;
import com.ibm.appscan.discovery.thirdpartylib.utils.ThirdPartyLibUtils;
import com.ibm.appscan.internal.discovery.thirdpartylib.ThirdPartyLibScanTarget;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashSet;
import java.util.Set;

public class ThirdPartyLibCollector
implements ICustomCollector {
    private File m_crawlRoot;
    private IScanTargetProxy m_proxy;
    private Set<IScanFile> m_files = new LinkedHashSet<IScanFile>();

    ThirdPartyLibCollector(File crawlRoot, IScanTargetProxy proxy) {
        this.m_crawlRoot = crawlRoot;
        this.m_proxy = proxy;
    }

    public void process(File file, String path, IProgress progress) {
        String name = file.getName().toLowerCase();
        if (ThirdPartyLibUtils.isSupportedExtension(name)) {
            try {
                String checksum = SystemUtil.calculateSHA1((File)file);
                this.m_files.add(ScanModelFactory.newScanFile((File)file, (String)checksum));
            }
            catch (IOException | NoSuchAlgorithmException e) {
                Message message = new Message(2, e.getMessage());
                this.m_proxy.getLogManager().log(message);
            }
        }
        if (ThirdPartyLibUtils.isSupportedConfigFile(file) && !ThirdPartyLibScanTarget.instance.isWorkingDirectoryPath(file)) {
            ThirdPartyLibScanTarget.instance.addConfigFile(file);
        }
    }

    public Set<IScanFile> getScanFiles() {
        return this.m_files;
    }

    public boolean createScanTarget(IScanTargetProxy proxy, ScanTargetStrategy parentStrategy) {
        boolean addedSca = false;
        addedSca = this.m_files == null ? ThirdPartyLibScanTarget.instance.add(this.m_crawlRoot.getAbsolutePath()) : ThirdPartyLibScanTarget.instance.add(this.m_files);
        return addedSca;
    }

    public String getType() {
        return "ThirdPartyLibCollector";
    }

    public void validateScanFiles(IScanTargetMinProxy proxy, IProgress progress, Set<IScanFile> files) {
    }
}

