/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.thirdpartylib;

import com.ibm.appscan.common.model.IScanTarget;
import com.ibm.appscan.common.model.event.IScanChangedListener;
import com.ibm.appscan.common.model.event.ScanChangedEvent;
import com.ibm.appscan.discovery.IDependencyProvider;
import com.ibm.appscan.internal.discovery.thirdpartylib.ThirdPartyLibScanTarget;
import java.io.File;
import java.util.ServiceLoader;

public class ThirdPartyLibScanChangedListener
implements IScanChangedListener {
    private static final ServiceLoader<IDependencyProvider> LOADER = ServiceLoader.load(IDependencyProvider.class);

    public void scanTargetAdded(ScanChangedEvent event) {
        this.analyzeDependencies(event.getScanTarget());
    }

    public void scanTargetRemoved(ScanChangedEvent event) {
    }

    public void scanTargetModified(ScanChangedEvent event) {
        this.analyzeDependencies(event.getScanTarget());
    }

    public void scanStateChanged(ScanChangedEvent event) {
    }

    private void analyzeDependencies(IScanTarget target) {
        if (ThirdPartyLibScanTarget.instance == target) {
            return;
        }
        for (IDependencyProvider provider : LOADER) {
            for (String dependency : provider.getDependencies(target)) {
                if (!new File(dependency).exists()) continue;
                ThirdPartyLibScanTarget.instance.add(dependency);
            }
        }
    }
}

