/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.sanitizerDetection.util;

import com.ibm.wala.stringAnalysis.sanitizerDetection.util.ApplicationResult;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SASpec;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SanitizerKind;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.StringAnalysisStatus;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.TimingData;
import com.ibm.wala.util.collections.HashMapFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class StringAnalysisResult {
    public static final Collection<SASpec> defaultIllegalPatterns = Arrays.asList(new SASpec(".*(\\r|\\n|\\x08).*", "LOG_FORGING"), new SASpec(".*(\\r|\\n).*", "HTTPRS"), new SASpec(".*(\\x22|\\x3c|\\x3e).*", "XSS"), new SASpec(".*(%).*", "FRMT_STR_OVERFLW"), new SASpec(".*(;).*", "DBCONN_STR_INJ"), new SASpec(".*(/|\\).*", "ABS_PATH_TRAVERSAL"), new SASpec(".*(\\.\\.|/|\\).*", "REL_PATH_TRAVERSAL"), new SASpec(".*(%|\\*|_|\\?).*", "DOS_WILDCARDS"), new SASpec(".*(<|>|'|\\x22|/).*", "XML_INJ"), new SASpec(".*(\\(|\\)|=|\\*|\\x7C).*", "LDAP_INJ"), new SASpec(".*(\\x22|&|-|/|\\|<|>|\\x7C|;).*", "CMD_INJ"), new SASpec(".*(<!--\\#|\\.|=|\\x22|-->).*", "SSI_INJ"), new SASpec(".*('|\\x22|\\*|\\?|<|>|=|/|\\(|\\)|\\x7C|\\x5B|\\x5D|%).*", "XPATH_INJ"), new SASpec(".*('|\\x22|\\#|%|=|;|\\+|[cC][hH][aA][rR]\\s*\\(\\s*\\d+\\s*\\)).*", "SQLI_POUND_COMMENT"), new SASpec(".*('|\\x22|--||%|=|;|\\+|[cC][hH][aA][rR]\\s*\\(\\s*\\d+\\s*\\)).*", "SQLI_DASH_COMMENT"), new SASpec(".*('|\\x22|/\\*|\\*/|%|=|;|\\+|[cC][hH][aA][rR]\\s*\\(\\s*\\d+\\s*\\)).*", "SQLI_MULTILINE_COMMENT"));
    private final Map<String, ApplicationResult> data;
    private final Map<String, TimingData> timingData;
    private final Collection<SASpec> illegalPatterns;

    public StringAnalysisResult(Map<String, ApplicationResult> data, Map<String, TimingData> timingData, Collection<SASpec> illegalPatterns) {
        this.data = data;
        this.timingData = timingData;
        this.illegalPatterns = illegalPatterns;
    }

    public Set<String> getApplications() {
        return this.data.keySet();
    }

    public static StringAnalysisResult loadFromInputStream(InputStream is, Collection<SASpec> illegalPatterns) throws IOException {
        String line;
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        HashMap data = HashMapFactory.make();
        br.readLine();
        br.readLine();
        while (null != (line = br.readLine())) {
            String application;
            ApplicationResult ats;
            if (line.trim().length() == 0) continue;
            line = line + ",,,,XXX";
            String[] tokens = line.split(",");
            int i = 0;
            if ((ats = (ApplicationResult)data.get(application = tokens[i++])) == null) {
                ats = new ApplicationResult(application, illegalPatterns);
                data.put(application, ats);
            }
            String method = tokens[i++];
            HashMap patternToSanitizerKind = HashMapFactory.make();
            for (SASpec p : illegalPatterns) {
                SanitizerKind kind = SanitizerKind.NONE;
                if (tokens[i].equals("V")) {
                    kind = SanitizerKind.SANITIZER;
                } else if (tokens[i].equals("PV")) {
                    kind = SanitizerKind.POSITIVE_VALIDATOR;
                } else if (tokens[i].equals("NV")) {
                    kind = SanitizerKind.NEGATIVE_VALIDATOR;
                }
                patternToSanitizerKind.put(p, kind);
            }
            String testCase = i < tokens.length ? tokens[i++] : "";
            String comment = i < tokens.length ? tokens[i++] : "";
            ats.add(method, patternToSanitizerKind, testCase, comment);
        }
        br.close();
        isr.close();
        return new StringAnalysisResult(data, Collections.emptyMap(), illegalPatterns);
    }

    public static String getTitle1() {
        return ",,Expected";
    }

    public static String getTitle2(Collection<SASpec> illegalPatterns) {
        String title2 = "Application,Method";
        for (SASpec p : illegalPatterns) {
            title2 = title2 + "," + p;
        }
        title2 = title2 + ",Test case, Comment";
        return title2;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(StringAnalysisResult.getTitle1());
        sb.append("\n");
        sb.append(StringAnalysisResult.getTitle2(this.illegalPatterns));
        sb.append("\n");
        for (String application : this.data.keySet()) {
            ApplicationResult ats = this.data.get(application);
            sb.append(ats.toString());
        }
        return sb.toString();
    }

    public ApplicationResult getResults(String application) {
        ApplicationResult applicationResult = this.data.get(application);
        if (applicationResult == null) {
            applicationResult = new ApplicationResult(application, this.illegalPatterns);
            this.data.put(application, applicationResult);
        }
        return applicationResult;
    }

    public void printReport(String fileName) {
        try {
            PrintWriter pw = new PrintWriter(fileName);
            pw.write(this.toString());
            pw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static StringAnalysisResult loadResultsFromFolder(String resultFolderStr, Collection<SASpec> illegalPatterns) throws FileNotFoundException, IOException {
        HashMap saData = HashMapFactory.make();
        HashMap timingData = HashMapFactory.make();
        File resultFolder = new File(resultFolderStr);
        assert (resultFolder.isDirectory());
        for (File f : resultFolder.listFiles()) {
            if (f.isFile() && StringAnalysisStatus.isSaResultFile(f.getName())) {
                StringAnalysisResult.processFile(f, saData, illegalPatterns);
            }
            if (!f.isFile() || !TimingData.isTimingResultFile(f.getName())) continue;
            StringAnalysisResult.processTimingFile(f, timingData);
        }
        return new StringAnalysisResult(saData, timingData, illegalPatterns);
    }

    public static StringAnalysisResult loadResultsFromFolder(String resultFolderStr) throws FileNotFoundException, IOException {
        return StringAnalysisResult.loadResultsFromFolder(resultFolderStr, defaultIllegalPatterns);
    }

    private static void processTimingFile(File f, Map<String, TimingData> timingData) {
        try {
            String application = TimingData.fileNameToAppName(f.getName());
            timingData.put(application, TimingData.readFromFile(f));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void processFile(File f, Map<String, ApplicationResult> data, Collection<SASpec> illegalPatterns) throws FileNotFoundException, IOException {
        StringAnalysisResult saResult = StringAnalysisResult.loadFromInputStream(new FileInputStream(f), illegalPatterns);
        String application = StringAnalysisStatus.fileNameToAppName(f.getName());
        data.put(application, saResult.getResults(application));
    }

    public TimingData getTimingData(String application) {
        return this.timingData.get(application);
    }

    public static StringAnalysisResult getExpected() throws IOException {
        InputStream expectedIS = StringAnalysisResult.class.getClassLoader().getResourceAsStream("saExpected.csv");
        StringAnalysisResult saTS = StringAnalysisResult.loadFromInputStream(expectedIS, defaultIllegalPatterns);
        expectedIS.close();
        return saTS;
    }

    public static StringAnalysisResult getTrueSet() throws IOException {
        InputStream trueSetIS = StringAnalysisResult.class.getClassLoader().getResourceAsStream("saTrueSet.csv");
        StringAnalysisResult saTS = StringAnalysisResult.loadFromInputStream(trueSetIS, defaultIllegalPatterns);
        trueSetIS.close();
        return saTS;
    }
}

