/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.config.commands;

import com.ibm.appscan.cli.common.components.Command;
import com.ibm.appscan.cli.config.Messages;
import com.ibm.appscan.cli.config.handlers.PackageHandler;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class PackageCommand
extends Command {
    private PackageHandler m_handler;

    public PackageCommand() {
    }

    public PackageCommand(String[] args) {
        super(args);
    }

    public void configure() {
        this.setNamespace(Messages.NAMESPACE_CONFIGURATION);
        this.setName("package");
        this.setDescription(Messages.PACKAGE_COMMAND_DESCRIPTION);
        this.setOptions(this.buildOptions(), false);
    }

    public Command createCommand(String[] args) {
        return new PackageCommand(args);
    }

    public void execute() {
        CommandLine cmd = this.getCommandLine();
        if (cmd == null) {
            return;
        }
        if (this.m_handler == null) {
            this.m_handler = new PackageHandler();
        }
        String assessment = null;
        String saveLocation = null;
        String name = null;
        if (cmd.hasOption("f")) {
            assessment = cmd.getOptionValue("f");
        }
        if (cmd.hasOption("d")) {
            saveLocation = cmd.getOptionValue("d");
        }
        if (cmd.hasOption("n")) {
            name = cmd.getOptionValue("n");
        }
        if (cmd.hasOption("ne")) {
            System.setProperty("NO_ENCRYPT", "");
        }
        this.m_handler.packFile(name, saveLocation, ".ozasmt", assessment);
    }

    protected Options getVisibleOptions(Options options) {
        Options visibleOptions = new Options();
        for (Object obj : options.getOptions()) {
            Option opt = (Option)obj;
            if ("ne".equals(opt.getOpt())) continue;
            visibleOptions.addOption(opt);
        }
        return visibleOptions;
    }

    protected Options buildOptions() {
        Options options = new Options();
        OptionBuilder.withArgName((String)Messages.FILE_OPTION_ARGUMENT);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)Messages.FILE_OPTION_DESCRIPTION);
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.withArgName((String)Messages.SAVELOCATION_OPTION_ARGUMENT);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)Messages.SAVELOCATION_OPTION_DESCRIPTION_IRX);
        options.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withArgName((String)Messages.ARTIFACTNAME_OPTION_ARGUMENT);
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)Messages.ARTIFACTNAME_OPTION_DESCRIPTION);
        options.addOption(OptionBuilder.create((String)"n"));
        options.addOption(OptionBuilder.create((String)"ne"));
        return options;
    }
}

