/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.visualstudio.plugin.targets;

import com.hcl.appscan.sdk.scan.ITarget;
import com.hcl.appscan.sdk.scanners.sast.targets.ISASTTarget;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.discovery.vs.utils.VSAdapterFactory;
import com.ibm.appscan.visualstudio.plugin.Messages;
import com.ibm.appscan.visualstudio.plugin.util.StdOutProgress;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class TargetFactory {
    private IProgress m_progress = new StdOutProgress();
    private List<ITarget> m_targets = new ArrayList<ITarget>();

    public List<ITarget> getTargets() {
        return this.m_targets;
    }

    public void createTargets() {
        Map<String, Properties> targets = this.readData();
        if (targets != null) {
            for (String target : targets.keySet()) {
                try {
                    Properties targetProps = targets.get(target);
                    Collection targetObjects = VSAdapterFactory.createTarget((Properties)targetProps, (IProgress)this.m_progress).toTargets();
                    if (targetObjects == null) continue;
                    for (ISASTTarget targetObject : targetObjects) {
                        File targetFile = targetObject.getTargetFile();
                        this.m_progress.setStatus(new Message(1, Messages.getMessage("adding.target", targetFile.getName())));
                        this.m_targets.add((ITarget)targetObject);
                    }
                }
                catch (AppScanException e) {
                    this.m_progress.setStatus(new Message(2, e.getMessage()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Properties> readData() {
        HashMap<String, Properties> targets = new HashMap<String, Properties>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line;
            String target = null;
            Properties properties = null;
            while (!(line = reader.readLine()).equalsIgnoreCase("EOF")) {
                String value;
                String[] prop = line.split("=");
                String key = prop[0];
                String string = value = prop.length == 2 ? prop[1] : "";
                if (key.equalsIgnoreCase("target")) {
                    if (target != null && properties != null) {
                        targets.put(target, properties);
                    }
                    target = value;
                    properties = new Properties();
                    continue;
                }
                if (key.equalsIgnoreCase("macros")) {
                    value = value.replace("|", "=");
                }
                properties.setProperty(key, value);
            }
            if (target != null && properties != null) {
                targets.put(target, properties);
            }
        }
        catch (Exception e) {
            this.m_progress.setStatus(new Message(4, Messages.getMessage("error.vs.comm", e.getLocalizedMessage())));
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return targets;
    }
}

