/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph;

import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.graph.EdgeFilteredNumberedGraph;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.Path;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntIterator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;

public class Acyclic {
    public static final int THRESHOLD_FOR_NONRECURSIVE_DFS = 1000;

    private Acyclic() {
    }

    public static <T> boolean isAcyclic(NumberedGraph<T> G, T root) {
        IBinaryNaturalRelation r = Acyclic.computeBackEdges(G, root);
        Iterator it = r.iterator();
        return !it.hasNext();
    }

    public static <T> IBinaryNaturalRelation computeBackEdges(NumberedGraph<T> G, T root) {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        BasicNaturalRelation result = new BasicNaturalRelation();
        if (G.getNumberOfNodes() <= 1000) {
            HashSet visited = HashSetFactory.make();
            HashSet onstack = HashSetFactory.make();
            Acyclic.dfs(result, root, G, visited, onstack);
        } else {
            Acyclic.dfsNonRecursive(result, root, G);
        }
        return result;
    }

    private static <T> void dfs(BasicNaturalRelation result, T root, NumberedGraph<T> G, Set<T> visited, Set<T> onstack) {
        visited.add(root);
        onstack.add(root);
        Iterator<T> it = G.getSuccNodes(root);
        while (it.hasNext()) {
            T dstNode = it.next();
            if (onstack.contains(dstNode)) {
                int src = G.getNumber(root);
                int dst = G.getNumber(dstNode);
                result.add(src, dst);
            }
            if (visited.contains(dstNode)) continue;
            Acyclic.dfs(result, dstNode, G, visited, onstack);
        }
        onstack.remove(root);
    }

    private static <T> void dfsNonRecursive(BasicNaturalRelation result, T root, NumberedGraph<T> G) {
        Stack<Object> stack = new Stack<Object>();
        HashSet<Object> stackSet = new HashSet<Object>();
        Stack stackIt = new Stack();
        HashSet finished = new HashSet();
        stack.push(root);
        stackSet.add(root);
        stackIt.push(G.getSuccNodes(root));
        while (!stack.isEmpty()) {
            Object current = stack.pop();
            stackSet.remove(current);
            Iterator currentIt = (Iterator)stackIt.pop();
            if (finished.contains(current)) continue;
            boolean isFinished = true;
            while (isFinished && currentIt.hasNext()) {
                Object succ = currentIt.next();
                if (finished.contains(succ)) continue;
                if (succ == current || stackSet.contains(succ)) {
                    int src = G.getNumber(current);
                    int dst = G.getNumber(succ);
                    result.add(src, dst);
                    continue;
                }
                stack.push(current);
                stackSet.add(current);
                stackIt.push(currentIt);
                stack.push(succ);
                stackSet.add(succ);
                stackIt.push(G.getSuccNodes(succ));
                isFinished = false;
            }
            if (!isFinished) continue;
            finished.add(current);
        }
    }

    public static <T> boolean hasIncomingBackEdges(Path p, NumberedGraph<T> G, T root) {
        IBinaryNaturalRelation backedges = Acyclic.computeBackEdges(G, root);
        for (int index = 0; index < p.size(); ++index) {
            int gn = p.get(index);
            Iterator predIter = G.getPredNodes(G.getNode(gn));
            while (predIter.hasNext()) {
                if (!backedges.contains(G.getNumber(predIter.next()), gn)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> Collection<Path> computeAcyclicPaths(NumberedGraph<T> G, T root, T src, T sink, int max) {
        HashSet<Path> result = HashSetFactory.make();
        EdgeFilteredNumberedGraph acyclic = new EdgeFilteredNumberedGraph(G, Acyclic.computeBackEdges(G, root));
        HashSet worklist = HashSetFactory.make();
        Path sinkPath = Path.make(G.getNumber(sink));
        worklist.add(sinkPath);
        while (!worklist.isEmpty() && result.size() <= max) {
            Path p = (Path)worklist.iterator().next();
            worklist.remove(p);
            int first = p.get(0);
            if (first == G.getNumber(src)) {
                result.add(p);
                continue;
            }
            IntIterator it = acyclic.getPredNodeNumbers(acyclic.getNode(first)).intIterator();
            while (it.hasNext()) {
                worklist.add(Path.prepend(it.next(), p));
            }
        }
        return result;
    }
}

