/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.impl;

import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.graph.NumberedEdgeManager;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.intset.BasicNaturalRelation;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.IBinaryNaturalRelation;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;

public final class SparseNumberedEdgeManager<T>
implements NumberedEdgeManager<T>,
Serializable {
    private final NumberedNodeManager<T> nodeManager;
    private final BitVector hasSuccessor = new BitVector();
    private static final byte[] defaultImpl = new byte[]{1};
    private final IBinaryNaturalRelation successors;
    private final IBinaryNaturalRelation predecessors;

    public SparseNumberedEdgeManager(NumberedNodeManager<T> nodeManager) {
        this(nodeManager, 0, 1);
    }

    public SparseNumberedEdgeManager(NumberedNodeManager<T> nodeManager, int normalCase, byte delegateImpl) throws IllegalArgumentException {
        if (nodeManager == null) {
            throw new IllegalArgumentException("null nodeManager");
        }
        if (normalCase < 0) {
            throw new IllegalArgumentException("normalCase < 0");
        }
        this.nodeManager = nodeManager;
        if (normalCase == 0) {
            this.successors = new BasicNaturalRelation(defaultImpl, delegateImpl);
            this.predecessors = new BasicNaturalRelation(defaultImpl, delegateImpl);
        } else {
            byte[] impl = new byte[normalCase];
            Arrays.fill(impl, (byte)0);
            this.successors = new BasicNaturalRelation(impl, delegateImpl);
            this.predecessors = new BasicNaturalRelation(impl, delegateImpl);
        }
    }

    @Override
    public Iterator<T> getPredNodes(T N) throws IllegalArgumentException {
        int number = this.nodeManager.getNumber(N);
        if (number < 0) {
            throw new IllegalArgumentException(N + " is not in graph");
        }
        IntSet s = this.predecessors.getRelated(number);
        EmptyIterator empty = EmptyIterator.instance();
        return s == null ? empty : this.nodeManager.iterateNodes(s);
    }

    @Override
    public int getPredNodeCount(T N) throws IllegalArgumentException {
        int number = this.nodeManager.getNumber(N);
        if (number < 0) {
            throw new IllegalArgumentException(N + "  is not in graph");
        }
        return this.predecessors.getRelatedCount(number);
    }

    @Override
    public Iterator<T> getSuccNodes(T N) throws IllegalArgumentException {
        int number = this.nodeManager.getNumber(N);
        if (number == -1) {
            throw new IllegalArgumentException(N + "  is not in graph");
        }
        IntSet s = this.successors.getRelated(number);
        EmptyIterator empty = EmptyIterator.instance();
        return s == null ? empty : this.nodeManager.iterateNodes(s);
    }

    @Override
    public Iterator<T> getSuccNodes(int number) {
        IntSet s = this.successors.getRelated(number);
        EmptyIterator empty = EmptyIterator.instance();
        return s == null ? empty : this.nodeManager.iterateNodes(s);
    }

    @Override
    public IntSet getSuccNodeNumbers(T node) throws IllegalArgumentException {
        if (this.nodeManager.getNumber(node) < 0) {
            throw new IllegalArgumentException("Node not in graph " + node);
        }
        return this.successors.getRelated(this.nodeManager.getNumber(node));
    }

    @Override
    public IntSet getPredNodeNumbers(T node) throws IllegalArgumentException {
        if (this.nodeManager.getNumber(node) < 0) {
            throw new IllegalArgumentException("Node not in graph " + node);
        }
        return this.predecessors.getRelated(this.nodeManager.getNumber(node));
    }

    @Override
    public int getSuccNodeCount(T N) throws IllegalArgumentException {
        return this.getSuccNodeCount(this.nodeManager.getNumber(N));
    }

    @Override
    public int getSuccNodeCount(int number) {
        return this.successors.getRelatedCount(number);
    }

    @Override
    public void addEdge(T src, T dst) throws IllegalArgumentException {
        int x = this.nodeManager.getNumber(src);
        int y = this.nodeManager.getNumber(dst);
        if (x < 0) {
            throw new IllegalArgumentException("src " + src + " is not in graph");
        }
        if (y < 0) {
            throw new IllegalArgumentException("dst " + dst + " is not in graph");
        }
        this.predecessors.add(y, x);
        this.successors.add(x, y);
        this.hasSuccessor.set(x);
    }

    @Override
    public boolean hasEdge(T src, T dst) {
        int x = this.nodeManager.getNumber(src);
        int y = this.nodeManager.getNumber(dst);
        if (x < 0 || y < 0) {
            return false;
        }
        return this.successors.contains(x, y);
    }

    @Override
    public void removeAllIncidentEdges(T node) throws IllegalArgumentException {
        IntSet pred;
        final int number = this.nodeManager.getNumber(node);
        if (number < 0) {
            throw new IllegalArgumentException("node not in graph: " + node);
        }
        IntSet succ = this.successors.getRelated(number);
        if (succ != null) {
            succ.foreach(new IntSetAction(){

                @Override
                public void act(int x) {
                    SparseNumberedEdgeManager.this.predecessors.remove(x, number);
                }
            });
        }
        if ((pred = this.predecessors.getRelated(number)) != null) {
            pred.foreach(new IntSetAction(){

                @Override
                public void act(int x) {
                    SparseNumberedEdgeManager.this.successors.remove(x, number);
                    if (SparseNumberedEdgeManager.this.successors.getRelatedCount(x) == 0) {
                        SparseNumberedEdgeManager.this.hasSuccessor.clear(x);
                    }
                }
            });
        }
        this.successors.removeAll(number);
        this.hasSuccessor.clear(number);
        this.predecessors.removeAll(number);
    }

    @Override
    public void removeIncomingEdges(T node) throws IllegalArgumentException {
        final int number = this.nodeManager.getNumber(node);
        if (number < 0) {
            throw new IllegalArgumentException("node not in graph: " + node);
        }
        IntSet pred = this.predecessors.getRelated(number);
        if (pred != null) {
            pred.foreach(new IntSetAction(){

                @Override
                public void act(int x) {
                    SparseNumberedEdgeManager.this.successors.remove(x, number);
                    if (SparseNumberedEdgeManager.this.successors.getRelatedCount(x) == 0) {
                        SparseNumberedEdgeManager.this.hasSuccessor.clear(x);
                    }
                }
            });
        }
        this.predecessors.removeAll(number);
    }

    @Override
    public void removeEdge(T src, T dst) throws IllegalArgumentException {
        int srcNumber = this.nodeManager.getNumber(src);
        int dstNumber = this.nodeManager.getNumber(dst);
        if (srcNumber < 0) {
            throw new IllegalArgumentException("src not in graph: " + src);
        }
        if (dstNumber < 0) {
            throw new IllegalArgumentException("dst not in graph: " + dst);
        }
        this.successors.remove(srcNumber, dstNumber);
        if (this.successors.getRelatedCount(srcNumber) == 0) {
            this.hasSuccessor.clear(srcNumber);
        }
        this.predecessors.remove(dstNumber, srcNumber);
    }

    @Override
    public void removeOutgoingEdges(T node) throws IllegalArgumentException {
        final int number = this.nodeManager.getNumber(node);
        if (number < 0) {
            throw new IllegalArgumentException("node not in graph: " + node);
        }
        IntSet succ = this.successors.getRelated(number);
        if (succ != null) {
            succ.foreach(new IntSetAction(){

                @Override
                public void act(int x) {
                    SparseNumberedEdgeManager.this.predecessors.remove(x, number);
                }
            });
        }
        this.successors.removeAll(number);
        this.hasSuccessor.clear(number);
    }

    public boolean hasAnySuccessor(int node) {
        return this.hasSuccessor.get(node);
    }

    public String toString() {
        return "Successors relation:\n" + this.successors;
    }
}

