/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.intset.OrdinalSet;
import com.ibm.wala.util.intset.OrdinalSetMapping;
import com.ibm.wala.util.intset.SparseIntSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class MutableMapping<T>
implements OrdinalSetMapping<T>,
Serializable {
    private static final int INITIAL_CAPACITY = 20;
    private static final int MAX_SIZE = 0x1FFFFFFF;
    private Object[] array;
    private int nextIndex = 0;
    final HashMap<T, Integer> map = HashMapFactory.make();

    public static <T> MutableMapping<T> make() {
        return new MutableMapping<T>();
    }

    public MutableMapping(Object[] array) {
        if (array == null) {
            throw new IllegalArgumentException("array is null");
        }
        this.array = new Object[2 * array.length];
        for (int i = 0; i < array.length; ++i) {
            this.array[i] = array[i];
            this.map.put(array[i], i);
        }
        this.nextIndex = array.length;
    }

    protected MutableMapping() {
        this.array = new Object[20];
        this.nextIndex = 0;
    }

    @Override
    public T getMappedObject(int n) {
        try {
            return (T)this.array[n];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("n out of range " + n);
        }
    }

    @Override
    public int getMappedIndex(Object o) {
        Integer I = this.map.get(o);
        if (I == null) {
            return -1;
        }
        return I;
    }

    @Override
    public boolean hasMappedIndex(T o) {
        return this.map.get(o) != null;
    }

    @Override
    public int add(T o) {
        Integer I = this.map.get(o);
        if (I != null) {
            return I;
        }
        this.map.put(o, new Integer(this.nextIndex));
        if (this.nextIndex >= this.array.length) {
            Object[] old = this.array;
            this.array = new Object[2 * this.array.length];
            System.arraycopy(old, 0, this.array, 0, old.length);
        }
        int result = this.nextIndex++;
        this.array[result] = o;
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.nextIndex; ++i) {
            result.append(i).append("  ").append(this.array[i]).append("\n");
        }
        return result.toString();
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    public OrdinalSet<T> makeSingleton(int i) {
        return new OrdinalSet(SparseIntSet.singleton(i), this);
    }

    public void deleteMappedObject(T n) {
        int index = this.getMappedIndex(n);
        if (index != -1) {
            this.array[index] = null;
            this.map.remove(n);
        }
    }

    public Collection<T> getObjects() {
        return Collections.unmodifiableCollection(this.map.keySet());
    }

    public void replace(T a, T b) throws IllegalArgumentException {
        int i = this.getMappedIndex(a);
        if (i == -1) {
            throw new IllegalArgumentException("first element does not exist in map");
        }
        this.map.remove(a);
        this.map.put(b, new Integer(i));
        this.array[i] = b;
    }

    public void put(int i, T o) {
        if (i < 0 || i > 0x1FFFFFFF) {
            throw new IllegalArgumentException("invalid i: " + i);
        }
        Integer I = i;
        this.map.put(o, I);
        if (i >= this.array.length) {
            Object[] old = this.array;
            this.array = new Object[2 * i];
            System.arraycopy(old, 0, this.array, 0, old.length);
        }
        this.array[i] = o;
        this.nextIndex = Math.max(this.nextIndex, i + 1);
    }

    @Override
    public int getMaximumIndex() {
        return this.nextIndex - 1;
    }

    @Override
    public int getSize() {
        return this.map.size();
    }
}

